package com.tiviacz.travelersbackpack.inventory;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.Optional;

public record FluidVariantWrapper(FluidVariant fluidVariant, long amount) {
    public static final Codec<FluidVariantWrapper> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    FluidVariant.CODEC.fieldOf("fluidVariant").forGetter(FluidVariantWrapper::fluidVariant),
                    Codec.LONG.fieldOf("amount").forGetter(FluidVariantWrapper::amount)
            ).apply(instance, FluidVariantWrapper::new)
    );

    public static final class_9139<class_9129, FluidVariantWrapper> STREAM_CODEC = class_9139.method_56435(
            FluidVariant.PACKET_CODEC, FluidVariantWrapper::fluidVariant,
            class_9135.field_48551, FluidVariantWrapper::amount,
            FluidVariantWrapper::new
    );

    public static Optional<FluidVariantWrapper> parse(class_7225.class_7874 provider, class_2520 tag) {
        return CODEC.parse(provider.method_57093(class_2509.field_11560), tag).result(); //.resultOrPartial(p_330102_ -> TravelersBackpack.LOGGER.error("Tried to load invalid FluidVariantWrapper: '{}'", p_330102_));
    }

    public static FluidVariantWrapper parseOptional(class_7225.class_7874 provider, class_2520 tag) {
        return parse(provider, tag).isPresent() ? parse(provider, tag).get() : blank();
    }

    public Optional<class_2520> save(class_7225.class_7874 provider) {
        return CODEC.encode(this, provider.method_57093(class_2509.field_11560), new class_2487()).resultOrPartial(p_330104_ -> TravelersBackpack.LOGGER.error("Tried to save invalid FluidVariantWrapper: '{}'", p_330104_));
    }

    public class_2520 saveOptional(class_7225.class_7874 provider) {
        return save(provider).isPresent() ? save(provider).get() : new class_2487();
    }

    public boolean isEmpty() {
        return fluidVariant.isBlank() || amount <= 0;
    }

    public long getAmount() {
        return amount;
    }

    public static FluidVariantWrapper blank() {
        return new FluidVariantWrapper(FluidVariant.blank(), 0);
    }

    public FluidVariantWrapper copyWithAmount(long amount) {
        if(this.isEmpty()) {
            return blank();
        } else {
            if(amount <= 0) {
                return blank();
            }
            FluidVariantWrapper fluidVariant = this.copy();
            fluidVariant.setAmount(amount);
            return fluidVariant;
        }
    }

    public FluidVariantWrapper copy() {
        if(this.isEmpty()) {
            return blank();
        } else {
            return new FluidVariantWrapper(this.fluidVariant, this.amount);
        }
    }

    public FluidVariantWrapper setAmount(long amount) {
        return new FluidVariantWrapper(this.fluidVariant, amount);
    }

    public FluidVariantWrapper grow(long addedAmount) {
        return this.setAmount(this.getAmount() + addedAmount);
    }

    public FluidVariantWrapper shrink(long removedAmount) {
        return this.grow(-removedAmount);
    }
}
