package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.*;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

public class InventoryActions {
    public static boolean transferContainerTank(TanksUpgrade upgrade, FluidTank tank, int slotIn) {
        ItemStackHandler itemStackHandler = upgrade.getFluidSlotsHandler();

        //Copy ItemStackHandler and set stack size to 1 to not break FluidStorage for multiple buckets
        ItemStackHandler itemStackHandlerCopy = new ItemStackHandler(itemStackHandler.getSlots());
        itemStackHandlerCopy.setStackInSlot(slotIn, itemStackHandler.getStackInSlot(slotIn).method_46651(1));

        SingleSlotStorage<ItemVariant> slotStorage = InventoryStorage.of(itemStackHandlerCopy, null).getSlot(slotIn);

        class_1799 stackIn = itemStackHandler.getStackInSlot(slotIn);
        int slotOut = slotIn + 1;

        if(tank == null || stackIn.method_7960() || stackIn.method_7909() == class_1802.field_8162) return false;

        // --- POTION PART ---
        if(stackIn.method_7909() instanceof class_1812 && stackIn.method_7909() != class_1802.field_8469) {
            boolean hasFluidStorage = FluidUtil.hasFluidStorageConstant(stackIn);
            if(!hasFluidStorage) {
                long amount = FluidConstants.BOTTLE;
                int potionType = 0;
                if(stackIn.method_7909() == class_1802.field_8436) potionType = 1;
                if(stackIn.method_7909() == class_1802.field_8150) potionType = 2;
                FluidVariant variant = FluidStackHelper.setPotionFluidVariant(stackIn, potionType);
                FluidVariantWrapper wrapper = new FluidVariantWrapper(variant, amount);

                if(tank.isEmpty() || FluidUtil.isSameVariant(variant, tank.getFluid().fluidVariant())) {
                    if(tank.getFluidAmount() + amount <= tank.getCapacity()) {
                        class_1799 bottle = potionType != 0 ? class_1799.field_8037.method_7972() : new class_1799(class_1802.field_8469);
                        class_1799 currentStackOut = itemStackHandler.getStackInSlot(slotOut);

                        if(currentStackOut.method_7960() || currentStackOut.method_7909() == bottle.method_7909() || bottle.method_7960()) {
                            if(currentStackOut.method_7909() == bottle.method_7909() && !bottle.method_7960()) {
                                if(currentStackOut.method_7947() + 1 > currentStackOut.method_7914()) return false;

                                bottle.method_7939(itemStackHandler.getStackInSlot(slotOut).method_7947() + 1);
                            }

                            tank.fill(wrapper, false);
                            InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                            if(!bottle.method_7960()) {
                                itemStackHandler.setStackInSlot(slotOut, bottle);
                            }

                            playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), class_3417.field_14978, true);

                            return true;
                        }
                    }
                }
            }
        }

        if(stackIn.method_7909() == class_1802.field_8469) {
            if(tank.getFluid().fluidVariant().getFluid() == ModFluids.POTION_STILL && tank.getFluidAmount() >= FluidConstants.BOTTLE) {
                class_1799 stackOut = FluidStackHelper.getItemStackFromFluidStack(tank.getFluid().fluidVariant());
                class_1799 currentStackOut = itemStackHandler.getStackInSlot(slotOut);

                if(currentStackOut.method_7960()) {
                    tank.drain(FluidConstants.BOTTLE, false);
                    InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);

                    playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), class_3417.field_14978, false);

                    return true;
                }
            }
        }
        // --- POTION PART ---

        Optional<Storage<FluidVariant>> fluidStorage = FluidUtil.getFluidStorageAtSlot(slotStorage);

        if(!Transaction.isOpen()) {
            try(Transaction transaction = Transaction.openOuter()) {
                if(fluidStorage.isPresent()) {
                    ResourceAmount<FluidVariant> fluidVariantWrapper;
                    try(Transaction transaction1 = transaction.openNested()) {
                        fluidVariantWrapper = StorageUtil.findExtractableContent(fluidStorage.get(), transaction1);
                        transaction1.commit();
                    }
                    //ResourceAmount<FluidVariant> fluidVariantWrapper = StorageUtil.findExtractableContent(fluidStorage.get(), transaction);

                    //Container ===> Tank
                    if(fluidVariantWrapper != null && fluidVariantWrapper.resource().getFluid() != null && fluidVariantWrapper.amount() > 0) {
                        if(tank.getAmount() > 0 && !FluidUtil.isSameVariant(fluidVariantWrapper.resource(), tank.getResource())) {
                            transaction.close();
                            return false;
                        }
                        class_1799 slotOutStack = itemStackHandler.getStackInSlot(slotOut);
                        //Fluid sound
                        class_3414 fluidSound = FluidVariantAttributes.getEmptySound(fluidVariantWrapper.resource());

                        if(StorageUtil.move(fluidStorage.get(), tank, f -> true, fluidVariantWrapper.amount(), transaction) > 0) {
                            class_1799 transferResultStack = slotStorage.getResource().toStack();
                            if(!transferResultStack.method_7960()) {
                                if(slotOutStack.method_7960() || slotOutStack.method_7909() == transferResultStack.method_7909()) {
                                    if(slotOutStack.method_7909() == transferResultStack.method_7909()) {
                                        transferResultStack.method_7939(slotOutStack.method_7947() + 1);
                                        if(transferResultStack.method_7947() > slotOutStack.method_7914()) {
                                            transaction.abort();
                                            return false;
                                        }
                                    }
                                    itemStackHandler.setStackInSlot(slotOut, transferResultStack);
                                }
                            }
                            InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                            playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, false);
                            transaction.commit();
                            return true;
                        }
                    }
                }

                //Tank ===> Container

                if(tank.isEmpty() || tank.getFluidAmount() <= 0) return false;

                if(isFluidEqual(stackIn, tank, transaction)) {
                    long amount = 0;
                    try(Transaction transaction1 = transaction.openNested()) {
                        amount = StorageUtil.simulateInsert(fluidStorage.get(), tank.getFluid().fluidVariant(), tank.getFluidAmount(), transaction1);
                        transaction1.commit();
                    }

                    //Fluid sound
                    class_3414 fluidSound = FluidTypeHelper.getSound(tank.getFluid().fluidVariant(), FluidTypeHelper.BUCKET_FILL);

                    long transferAmount = 0;
                    try(Transaction transaction1 = transaction.openNested()) {
                        transferAmount = FluidUtil.tryFillContainerAtSlot(tank, amount, fluidStorage.get(), true, transaction1);
                    }
                    class_1799 stackOut = slotStorage.getResource().toStack();

                    if(stackOut.method_7960()) {
                        transaction.abort();
                        return false;
                    }

                    if(transferAmount > 0) {
                        class_1799 slotOutStack = itemStackHandler.getStackInSlot(slotOut);

                        if(slotOutStack.method_7960() || slotOutStack.method_7909() == stackOut.method_7909()) {
                            if(slotOutStack.method_7909() == stackOut.method_7909()) {
                                stackOut.method_7939(slotOutStack.method_7947() + 1);

                                if(stackOut.method_7947() > slotOutStack.method_7914()) {
                                    transaction.abort();
                                    return false;
                                }
                            }

                            playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, true);
                            itemStackHandler.setStackInSlot(slotOut, stackOut);
                            InventoryHelper.removeItem(upgrade.getFluidSlotsHandler(), slotIn, 1);
                            transaction.commit();
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean isFluidEqual(class_1799 stackIn, FluidTank tank, Transaction main) {
        if(FluidUtil.hasFluidStorageConstant(stackIn)) {
            ResourceAmount<FluidVariant> fluidVariantWrapper = null;
            try(Transaction transaction = main.openNested()) {
                fluidVariantWrapper = StorageUtil.findExtractableContent(FluidUtil.getFluidStorageConstant(stackIn).get(), transaction);
                transaction.commit();
            }
            if(fluidVariantWrapper == null) {
                return true;
            } else if(!fluidVariantWrapper.resource().isBlank() && fluidVariantWrapper.amount() > 0) {
                return FluidUtil.isSameVariant(fluidVariantWrapper.resource(), tank.getFluid().fluidVariant());
            }
        }
        return false;
    }

    public static void playFluidSound(@Nullable class_1657 player, List<class_1657> usingPlayers, class_3414 soundEvent, boolean fill) {
        if(soundEvent == null) {
            if(fill) {
                soundEvent = class_3417.field_15126;
            } else {
                soundEvent = class_3417.field_14834;
            }
        }

        if(player != null) {
            player.method_37908().method_43128(null, player.method_19538().method_10216(), player.method_19538().method_10214() + 0.5, player.method_19538().method_10215(), soundEvent, class_3419.field_15245, 1.0F, 1.0F);
        } else if(!usingPlayers.isEmpty()) {
            class_1657 user = usingPlayers.get(0);
            if(user.field_7512 instanceof BackpackBlockEntityMenu menu) {
                class_243 backpackPos = menu.getWrapper().getBackpackPos().method_46558();
                menu.player.method_37908().method_43128(null, backpackPos.method_10216(), backpackPos.method_10214() + 0.5, backpackPos.method_10215(), soundEvent, class_3419.field_15245, 1.0F, 1.0F);
            }
            if(user.field_7512 instanceof BackpackItemMenu menu && menu.getWrapper().getScreenID() == Reference.ITEM_SCREEN_ID && !menu.player.method_37908().field_9236) {
                menu.player.method_17356(soundEvent, class_3419.field_15245, 1.0F, 1.0F);
                //menu.player.level().playLocalSound(menu.player.position().x(), menu.player.position().y() + 0.5, menu.player.position().z(), soundEvent, SoundSource.BLOCKS, 1.0F, 1.0F, false);
            }
        }
    }
}