package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class FilterSlotItemHandler extends SlotItemHandler {
    protected final UpgradeBase upgrade;
    protected final int activeSlotCount;

    public FilterSlotItemHandler(UpgradeBase upgrade, ItemStackHandler itemHandler, int index, int xPosition, int yPosition, int activeSlotCount) {
        super(itemHandler, index, xPosition, yPosition);
        this.upgrade = upgrade;
        this.activeSlotCount = activeSlotCount;
    }

    @Override
    public boolean method_7682() {
        return upgrade.isTabOpened() && this.field_7874 < this.activeSlotCount;
    }

    @Override
    public boolean method_7680(class_1799 pStack) {
        return upgrade.isTabOpened() && this.field_7874 < this.activeSlotCount && super.method_7680(pStack);
    }

    @Override
    public boolean method_55059() {
        return true;
    }

    @Override
    public boolean method_7674(class_1657 player) {
        return upgrade.getUpgradeManager().getWrapper().isOwner(player) && this.field_7874 < this.activeSlotCount;
    }

    @Override
    public Optional<class_1799> method_34264(int count, int decrement, class_1657 player) {
        if(!this.method_7674(player)) {
            return Optional.empty();
        }
        this.method_7673(class_1799.field_8037);
        return Optional.empty();
    }

    @Override
    public class_1799 method_32755(class_1799 stack, int increment) {
        if(!stack.method_7960() && this.method_7680(stack)) {
            this.method_7673(stack.method_46651(1));
        }
        return stack;
    }
}