package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class SlotItemHandler extends class_1735 {
    private static class_1263 emptyInventory = new class_1277(0);
    private final ItemStackHandler itemHandler;
    protected final int field_7874;

    public SlotItemHandler(ItemStackHandler itemHandler, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.itemHandler = itemHandler;
        this.field_7874 = index;
    }

    @Override
    public boolean method_7680(class_1799 stack) {
        if(stack.method_7960())
            return false;
        return itemHandler.isItemValid(field_7874, stack);
    }

    @Override
    public class_1799 method_7677() {
        return this.getItemHandler().getStackInSlot(field_7874);
    }

    // Override if your IItemHandler does not implement IItemHandlerModifiable
    @Override
    public void method_7673(class_1799 stack) {
        ((ItemStackHandler)this.getItemHandler()).setStackInSlot(field_7874, stack);
        this.method_7668();
    }

    // Override if your IItemHandler does not implement IItemHandlerModifiable
    // @Override
    public void initialize(class_1799 stack) {
        ((ItemStackHandler)this.getItemHandler()).setStackInSlot(field_7874, stack);
        this.method_7668();
    }

    @Override
    public void method_7670(class_1799 oldStackIn, class_1799 newStackIn) {
    }

    @Override
    public int method_7675() {
        return this.itemHandler.getSlotLimit(this.field_7874);
    }

    @Override
    public int method_7676(class_1799 stack) {
        class_1799 maxAdd = stack.method_7972();
        int maxInput = stack.method_7914();
        maxAdd.method_7939(maxInput);

        ItemStackHandler handler = this.getItemHandler();
        class_1799 currentStack = handler.getStackInSlot(field_7874);
        if(handler instanceof ItemStackHandler) {
            ItemStackHandler handlerModifiable = (ItemStackHandler)handler;

            handlerModifiable.setStackInSlot(field_7874, class_1799.field_8037);

            class_1799 remainder = handlerModifiable.insertItem(field_7874, maxAdd, true);

            handlerModifiable.setStackInSlot(field_7874, currentStack);

            return maxInput - remainder.method_7947();
        } else {
            class_1799 remainder = handler.insertItem(field_7874, maxAdd, true);

            int current = currentStack.method_7947();
            int added = maxInput - remainder.method_7947();
            return current + added;
        }
    }

    @Override
    public boolean method_7674(class_1657 playerIn) {
        return !this.getItemHandler().extractItem(field_7874, 1, true).method_7960();
    }

    @Override
    public class_1799 method_7671(int amount) {
        return this.getItemHandler().extractItem(field_7874, amount, false);
    }

    public ItemStackHandler getItemHandler() {
        return itemHandler;
    }
}

