package com.tiviacz.travelersbackpack.inventory.sorter;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.*;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class SortSelector {
    public enum SortType {
        CATEGORY, NAME, COUNT;

        public SortType next() {
            SortType[] values = values();
            int nextIndex = (this.ordinal() + 1) % values.length;
            return values[nextIndex];
        }
    }

    public static Comparator<class_1799> getSortTypeComparator(List<class_1799> stacks, SortType type) {
        return switch(type) {
            case CATEGORY -> Comparator.comparing(SortSelector::getStringForCategorySort);
            case NAME -> Comparator.comparing(SortSelector::getStringForNameSort);
            case COUNT -> getCountTypeComparator(stacks);
        };
    }

    public static Comparator<class_1799> getCountTypeComparator(List<class_1799> stacks) {
        HashMap<class_1792, Integer> counts = calculateCount(stacks);
        List<class_1792> sortedItems = new ArrayList<>(counts.keySet());
        sortedItems.sort((item1, item2) -> {
            int countCompare = Integer.compare(counts.get(item2), counts.get(item1));
            if(countCompare != 0) {
                return countCompare;
            }
            return item1.method_7876().compareTo(item2.method_7876());
        });

        return (stack1, stack2) -> {
            if(stack1.method_7960() && stack2.method_7960()) return 0;
            if(stack1.method_7960()) return 1;
            if(stack2.method_7960()) return -1;

            int index1 = sortedItems.indexOf(stack1.method_7909());
            int index2 = sortedItems.indexOf(stack2.method_7909());

            return Integer.compare(index1, index2);
        };
    }

    public static HashMap<class_1792, Integer> calculateCount(List<class_1799> stacks) {
        HashMap<class_1792, Integer> itemCounts = new HashMap<>();

        for(class_1799 stack : stacks) {
            if(!stack.method_7960()) {
                class_1792 item = stack.method_7909();
                int count = stack.method_7947();

                itemCounts.put(item, itemCounts.getOrDefault(item, 0) + count);
            }
        }
        return itemCounts;
    }

    public static String getStringForCategorySort(class_1799 stack) {
        String name = class_7923.field_41178.method_10221(stack.method_7909()).toString();
        name = specialCases(stack, name);
        return name;
    }

    public static String getStringForNameSort(class_1799 stack) {
        String key = class_7923.field_41178.method_10221(stack.method_7909()).toString();
        String itemName = key.split(":")[1];
        itemName = specialCases(stack, itemName);
        return itemName;
    }

    private static String specialCases(class_1799 stack, String name) {
        class_1792 item = stack.method_7909();
        name = stackSize(stack, name);
        if(item instanceof class_1772) {
            return enchantedBookNameCase(stack, name);
        }
        if(item instanceof class_1831) {
            return toolDurabilityCase(stack, name);
        }
        return name;
    }

    private static String stackSize(class_1799 stack, String name) {
        int invertedCount = 9999 - stack.method_7947();
        return name + String.format("%04d", invertedCount);
    }

    private static String enchantedBookNameCase(class_1799 stack, String name) {
        Set<Object2IntMap.Entry<class_6880<class_1887>>> enchants = stack.method_57824(class_9334.field_49643).method_57539();
        List<String> names = new ArrayList<>();
        StringBuilder enchantNames = new StringBuilder();

        for(Object2IntMap.Entry<class_6880<class_1887>> e : enchants) {
            names.add(class_1887.method_8179(e.getKey(), e.getIntValue()).getString());
        }

        Collections.sort(names);
        for(String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return name + " " + enchants.size() + " " + enchantNames;
    }

    private static String toolDurabilityCase(class_1799 stack, String name) {
        return name + stack.method_7919();
    }
}