package com.tiviacz.travelersbackpack.inventory.upgrades.crafting;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.ResultArrowElement;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.minecraft.class_332;

public class CraftingWidget extends UpgradeWidgetBase<CraftingUpgrade> {
    private final ResultArrowElement resultArrowElement;
    public final WidgetElement arrowElement = new WidgetElement(new Point(8, 91), new Point(12, 12));

    public CraftingWidget(BackpackScreen screen, CraftingUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(51, 0), "screen.travelersbackpack.crafting_upgrade");
        this.resultArrowElement = new ResultArrowElement(screen, this, this.arrowElement);
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        this.resultArrowElement.renderBg(guiGraphics, x, y, mouseX, mouseY);
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.resultArrowElement.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if(this.resultArrowElement.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}