package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_9334;

public class FeedingFilterSettings extends FilterSettingsBase {
    //Button Types
    public static final int ALLOW_MODE = 0;
    public static final int HUNGER_MODE = 1;
    public static final int IGNORE_EFFECT_MODE = 2;

    //Options
    public static final int ALLOW = 0;
    public static final int BLOCK = 1;

    public static final int ALWAYS_EAT = 0;
    public static final int HALF_NUTRITION = 1;
    public static final int FULL_NUTRITION = 2;

    public static final int BLOCK_BAD_EFFECTS = 0;
    public static final int ALLOW_BAD_EFFECTS = 1;

    public FeedingFilterSettings(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings) {
        super(storage, items, filterSettings, TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount);
    }

    @Override
    public boolean matchesFilter(@Nullable class_1657 player, class_1799 stack) {
        class_1702 foodData = player.method_7344();
        if(filterSettings.get(ALLOW_MODE) == ALLOW) {
            return this.filterItems.stream().anyMatch(food -> class_1799.method_31577(food.method_46651(1), stack)) && compareHungerLevel(foodData, stack) && checkHarmfulEffects(stack);
        }
        if(filterSettings.get(ALLOW_MODE) == BLOCK) {
            return this.filterItems.stream().noneMatch(food -> class_1799.method_31577(food.method_46651(1), stack)) && compareHungerLevel(foodData, stack) && checkHarmfulEffects(stack);
        }
        return false;
    }

    public boolean compareHungerLevel(class_1702 foodData, class_1799 stack) {
        if(filterSettings.get(HUNGER_MODE) == ALWAYS_EAT) {
            return foodData.method_7587();
        }
        if(filterSettings.get(HUNGER_MODE) == HALF_NUTRITION) {
            return getNutritionDifference(foodData, stack) <= getHalfOfStackHunger(stack);
        }
        if(filterSettings.get(HUNGER_MODE) == FULL_NUTRITION) {
            return getNutritionDifference(foodData, stack) <= 0;
        }
        return false;
    }

    public boolean checkHarmfulEffects(class_1799 stack) {
        if(filterSettings.get(IGNORE_EFFECT_MODE) == BLOCK_BAD_EFFECTS) {
            return checkHarmfulEffect(stack.method_57824(class_9334.field_50075));
        } else {
            return true;
        }
    }

    public boolean checkHarmfulEffect(class_4174 props) {
        for(class_4174.class_9423 effect : props.comp_2495()) {
            if(effect.comp_2496().method_5579().comp_349().method_18792() == class_4081.field_18272) {
                return false;
            }
        }
        return true;
    }

    public int getNutritionDifference(class_1702 foodData, class_1799 stack) {
        if(foodData.method_7587()) {
            class_4174 foodProps = stack.method_57824(class_9334.field_50075);
            int foodNutrition = foodProps.comp_2491();
            int playerNutrition = foodData.method_7586();
            return playerNutrition + foodNutrition - 20;
        }
        return 0;
    }

    public int getHalfOfStackHunger(class_1799 stack) {
        return stack.method_57824(class_9334.field_50075).comp_2491() / 2;
    }
}