package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.*;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class FeedingUpgrade extends FilterUpgradeBase<FeedingUpgrade, FeedingFilterSettings> implements IEnable, ITickableUpgrade {
    private static final int STILL_HUNGRY_COOLDOWN = 10;

    public FeedingUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 49),
                TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount,
                TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.slotsInRow, filter, List.of());
    }

    @Override
    public boolean hasTagSelector() {
        return false;
    }

    @Override
    public List<Integer> getFilter() {
        return getDataHolderStack().method_57825(ModDataComponents.FILTER_SETTINGS, List.of(1, 1, 0));
    }

    @Override
    public FeedingFilterSettings createFilterSettings(UpgradeManager manager, class_2371<class_1799> filter, List<String> filterTags) {
        return new FeedingFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(getFilterSlotCount()).filter(stack -> !stack.method_7960()).toList(), getFilter());
    }

    public boolean canEat(class_1657 player, class_1799 stack) {
        return getFilterSettings().matchesFilter(player, stack) && !player.method_7357().method_7904(stack.method_7909()); //Cooldown patch for everlasting foods from Artifacts
    }

    @Override
    @Environment(EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new FeedingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    protected FilterHandler createFilter(class_2371<class_1799> stacks, int size) {
        return new FilterHandler(stacks, size) {
            @Override
            protected void onContentsChanged(int slot) {
                updateDataHolderUnchecked(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(size, filter));

                getFilterSettings().updateFilter(getDataHolderStack().method_57824(ModDataComponents.BACKPACK_CONTAINER).getItems());
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return stack.method_57826(class_9334.field_50075);
            }
        };
    }

    @Override
    public int getTickRate() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.tickRate;
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if(getCooldown() == 0) {
            return;
        }
        if(currentTick % getCooldown() != 0) {
            return;
        }

        if(level.field_9236) {
            return;
        }

        //Load storage if not loaded in artificial wrapper
        getUpgradeManager().getWrapper().loadAdditionally(BackpackWrapper.STORAGE_ID);

        if(feedPlayerAndGetHungry(player, level)) {
            setCooldown(STILL_HUNGRY_COOLDOWN);
            return;
        }

        if(!hasCooldown() || getCooldown() != getTickRate()) {
            setCooldown(getTickRate());
        }
    }

    private boolean feedPlayerAndGetHungry(class_1657 player, class_1937 level) {
        int hungerLevel = 20 - player.method_7344().method_7586();
        if(hungerLevel == 0 || level.field_9236) {
            return false;
        }
        return tryFeedingFoodFromStorage(level, hungerLevel, player) && player.method_7344().method_7586() < 20;
    }

    private boolean tryFeedingFoodFromStorage(class_1937 level, int hungerLevel, class_1657 player) {
        ItemStackHandler storage = getUpgradeManager().getWrapper().getStorageForInputOutput();
        return InventoryHelper.iterate(storage, (slot, stack) -> tryFeedingStack(level, hungerLevel, player, slot, stack, storage));
    }

    private boolean tryFeedingStack(class_1937 level, int hungerLevel, class_1657 player, Integer slot, class_1799 stack, ItemStackHandler backpackStorage) {
        if(isEdible(stack, player) && canEat(player, stack)) {
            class_1799 mainHandItem = player.method_6047();
            player.method_6122(class_1268.field_5808, stack);
            //player.getInventory().items.set(player.getInventory().selected, stack);

            class_1799 singleItemCopy = stack.method_7972();
            singleItemCopy.method_7939(1);

            if(singleItemCopy.method_7913(level, player, class_1268.field_5808).method_5467() == class_1269.field_21466) {
                stack.method_7934(1);
                backpackStorage.setStackInSlot(slot, stack);

                //player.getInventory().items.set(player.getInventory().selected, mainHandItem);
                //ItemStack resultItem = singleItemCopy.finishUsingItem(level, player); //EventHooks.onItemUseFinish(player, singleItemCopy, 0, singleItemCopy.getItem().finishUsingItem(singleItemCopy, level, player));

                class_1271<class_1799> result = UseItemCallback.EVENT.invoker().interact(player, level, class_1268.field_5808);
                class_1799 resultItem = result.method_5466();
                if(result.method_5467() == class_1269.field_5811) {
                    resultItem = singleItemCopy.method_7909().method_7861(singleItemCopy, level, player);
                }

                if(!resultItem.method_7960()) {
                    class_1799 insertResult = InventoryHelper.addItemStackToHandler(backpackStorage, resultItem, false);
                    if(!insertResult.method_7960()) {
                        player.method_7328(insertResult, true);
                    }
                }
                player.method_6122(class_1268.field_5808, mainHandItem);
                return true;
            }
            player.method_6122(class_1268.field_5808, mainHandItem);
            //player.getInventory().items.set(player.getInventory().selected, mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(class_1799 stack, class_1309 player) {
        if(!stack.method_57826(class_9334.field_50075)) {
            return false;
        }
        class_4174 foodProperties = stack.method_57824(class_9334.field_50075);
        return foodProperties != null && foodProperties.comp_2491() >= 1;
    }
}