package com.tiviacz.travelersbackpack.inventory.upgrades.magnet;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class MagnetWidget extends FilterUpgradeWidgetBase<MagnetWidget, MagnetUpgrade> {
    public MagnetWidget(BackpackScreen screen, MagnetUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.magnet_upgrade");

        FilterButton<MagnetWidget> whitelistButton = new FilterButton<>(this, upgrade.getFilter().get(MagnetFilterSettings.ALLOW_MODE), ButtonStates.ALLOW_FEEDING, new Point(pos.x() + 6, pos.y() + 22));
        FilterButton<MagnetWidget> objectButton = new FilterButton<>(this, upgrade.getFilter().get(MagnetFilterSettings.OBJECT_CATEGORY), ButtonStates.OBJECT_TYPE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        FilterButton<MagnetWidget> ignoreModeButton = new FilterButton<>(this, upgrade.getFilter().get(MagnetFilterSettings.IGNORE_MODE), ButtonStates.IGNORE_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));

        this.addFilterButton(whitelistButton);
        this.addFilterButton(objectButton);
        this.addFilterButton(ignoreModeButton);
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);

        if(isTabOpened()) {
            if(getFilterButton(ButtonStates.ALLOW_FEEDING).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(screen.getFont(), WHITELIST_TOOLTIPS.get(getFilterButton(ButtonStates.ALLOW_FEEDING).getCurrentState()), mouseX, mouseY);
            }
            if(getFilterButton(ButtonStates.OBJECT_TYPE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(screen.getFont(), OBJECT_TOOLTIPS.get(getFilterButton(ButtonStates.OBJECT_TYPE).getCurrentState()), mouseX, mouseY);
            }
            if(getFilterButton(ButtonStates.IGNORE_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(screen.getFont(), IGNORE_MODE_TOOLTIPS.get(getFilterButton(ButtonStates.IGNORE_MODE).getCurrentState()), mouseX, mouseY);
            }
        }
    }

    private static final List<class_2561> WHITELIST_TOOLTIPS = List.of(
            class_2561.method_43471("screen.travelersbackpack.filter_allow"),
            class_2561.method_43471("screen.travelersbackpack.filter_block"));

    private static final List<class_2561> OBJECT_TOOLTIPS = List.of(
            class_2561.method_43471("screen.travelersbackpack.filter_item"),
            class_2561.method_43471("screen.travelersbackpack.filter_modid"),
            class_2561.method_43471("screen.travelersbackpack.filter_tag"));

    private static final List<class_2561> IGNORE_MODE_TOOLTIPS = List.of(
            class_2561.method_43471("screen.travelersbackpack.filter_match_components"),
            class_2561.method_43471("screen.travelersbackpack.filter_ignore_components"));
}