package com.tiviacz.travelersbackpack.inventory.upgrades.refill;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RefillUpgrade extends UpgradeBase<RefillUpgrade> implements IEnable, ITickableUpgrade, IFilterSlots {
    private final FilterHandler filter;

    public RefillUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 28));
        this.filter = createFilter(filter, getFilterSlotCount());
    }

    @Override
    public int getFilterSlotCount() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.refillUpgradeSettings.filterSlotCount;
    }

    @Override
    public int getSlotsInRow() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.refillUpgradeSettings.slotsInRow;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new UpgradeWidgetBase<>(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), new Point(137, 0), "screen.travelersbackpack.refill_upgrade");
    }

    @Override
    public List<? extends class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        List<class_1735> slots = new ArrayList<>();
        for(int i = 0; i < getRows(); i++) {
            for(int j = 0; j < getSlotsInRow(i); j++) {
                slots.add(new FilterSlotItemHandler(this, this.filter, j + i * getSlotsInRow(), x + 7 + j * 18, y + 23 + i * 18, getFilterSlotCount()) {
                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                    }
                });
            }
        }
        return slots;
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if(getCooldown() == 0) {
            return;
        }
        if(currentTick % getCooldown() != 0) {
            return;
        }

        //Load storage if not loaded in artificial wrapper
        getUpgradeManager().getWrapper().loadAdditionally(BackpackWrapper.STORAGE_ID);

        //var cap = player.getAttachments().getCapability(Capabilities.ItemHandler.ENTITY);
        //if(cap != null) {
        tryRefillItems(player);
        //}

        if(!hasCooldown() || getCooldown() != getTickRate()) {
            setCooldown(getTickRate());
        }
    }

    public void tryRefillItems(class_1657 player) {
        InventoryHelper.iterateHandler(this.filter, (slot, filterStack) -> {
            if(!filterStack.method_7960()) {
                refill(player.method_31548(), player, filterStack);
            }
        });
    }

    public void refill(class_1661 playerInv, class_1657 player, class_1799 filterStack) {
        Pair<Integer, Integer> pair = countAndSupply(playerInv, filterStack, player); //Current Count and Slot
        int missingCount = getMissingCount(filterStack, pair.getFirst());
        if(pair.getFirst() >= filterStack.method_7914() || missingCount <= 0) {
            return;
        }

        boolean standalone = false;
        if(pair.getFirst() == 0) {
            int count = pair.getFirst();
            pair = Pair.of(count, player.method_31548().method_7376());
            standalone = true;
        }

        if(pair.getSecond() == -1) {
            return;
        }

        //Extract the missing count from backpack
        ItemStackHandler backpackStorage = upgradeManager.getWrapper().getStorage();
        class_1799 extracted = InventoryHelper.extractFromBackpack(backpackStorage, filterStack, missingCount, true);

        if(extracted.method_7960()) {
            return;
        }

        boolean addItem = true;
        int extractedCount = extracted.method_7947();

        if(!standalone) {
            player.method_31548().method_5438(pair.getSecond()).method_7933(extractedCount);
        } else {
            addItem = player.method_7270(extracted);
        }

        //Actually remove the items from backpack
        if(addItem) {
            InventoryHelper.extractFromBackpack(backpackStorage, filterStack, extractedCount, false);
        }
    }

    private Pair<Integer, Integer> countAndSupply(class_1661 playerInv, class_1799 filterStack, class_1657 player) {
        AtomicInteger count = new AtomicInteger();
        AtomicInteger supplySlot = new AtomicInteger(-1);
        InventoryHelper.iteratePlayerInv(playerInv, (slot, stack) -> {
            if(class_1799.method_31577(stack, filterStack)) {
                if(supplySlot.get() == -1) {
                    supplySlot.set(slot);
                }
                count.addAndGet(stack.method_7947());
            }
        });
        if(player.field_7512 != null) {
            if(class_1799.method_31577(player.field_7512.method_34255(), filterStack)) {
                count.addAndGet(player.field_7512.method_34255().method_7947());
            }
        }
        return Pair.of(count.get(), supplySlot.get());
    }

    private int getMissingCount(class_1799 filterStack, int count) {
        return filterStack.method_7914() - count;
    }

    @Override
    public int getTickRate() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.refillUpgradeSettings.tickRate;
    }

    protected FilterHandler createFilter(class_2371<class_1799> stacks, int size) {
        return new FilterHandler(stacks, size) {
            @Override
            protected void onContentsChanged(int slot) {
                updateDataHolderUnchecked(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(size, filter));
            }
        };
    }
}