package com.tiviacz.travelersbackpack.inventory.upgrades.smelting;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.*;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9331;
import net.minecraft.class_9696;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class AbstractSmeltingUpgrade<T> extends UpgradeBase<T> implements IEnable, ITickableUpgrade, IMoveSelector {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    private final class_1937 level;
    protected ItemStackHandler items;
    private class_8786<? extends class_1874> cachedRecipe = null;
    private boolean recipeFetched = false;
    private final class_3956<? extends class_1874> recipeType;
    private final class_1863.class_7266<class_9696, ? extends class_1874> quickCheck;
    private final String upgradeName;

    public AbstractSmeltingUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> furnaceContents, class_3956<? extends class_1874> recipeType, String upgradeName) {
        super(manager, dataHolderSlot, new Point(66, 82));
        this.level = manager.getWrapper().getLevel();
        this.items = createHandler(furnaceContents);
        this.recipeType = recipeType;
        this.quickCheck = class_1863.method_42302(this.recipeType);
        this.upgradeName = upgradeName;
    }

    @Environment(EnvType.CLIENT)
    @Override
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AbstractSmeltingWidget<>(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), "screen.travelersbackpack." + upgradeName);
    }

    @Override
    public void onUpgradeRemoved(class_1799 removedStack) {
        removedStack.method_57381(ModDataComponents.COOKING_TOTAL_TIME);
        removedStack.method_57381(ModDataComponents.COOKING_FINISH_TIME);
        removedStack.method_57381(ModDataComponents.BURN_TOTAL_TIME);
        removedStack.method_57381(ModDataComponents.BURN_FINISH_TIME);
    }

    @Override
    public List<class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        List<class_1735> slots = new ArrayList<>();
        slots.add(new UpgradeSlotItemHandler<AbstractSmeltingUpgrade<?>>(this, this.items, SLOT_INPUT, x + 7, y + 23));
        slots.add(new UpgradeSlotItemHandler<AbstractSmeltingUpgrade<?>>(this, this.items, SLOT_FUEL, x + 7, y + 23 + 36));
        slots.add(new UpgradeSlotItemHandler<AbstractSmeltingUpgrade<?>>(this, this.items, SLOT_RESULT, x + 7 + 18 + 18, y + 23 + 18));
        return slots;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if(!enabled) {
            stopCooking();
            stopBurning();
            /*if(isCooking()) {
                long remainingTime = getCookingFinishTime() - this.level.getGameTime();
                setCookingTotalTime((int)remainingTime);
                setCookingFinishTime(0);
            }
            if(isBurning()) {
                long remainingTime = getBurnFinishTime() - this.level.getGameTime();
                setBurnTotalTime((int)remainingTime);
                setBurnFinishTime(0);
            }*/
        } else {
            /*if(getCookingTotalTime() > 0) {
                setCookingFinishTime(this.level.getGameTime() + getCookingTotalTime());
            }
            if(getBurnTotalTime() > 0) {
                setBurnFinishTime(this.level.getGameTime() + getBurnTotalTime());
            }*/
            checkCooking(this.level, false);
        }
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if(level.field_9236 || !isEnabled(this)) {
            return;
        }

        long currentTime = level.method_8510();
        if(isBurning()) {
            if(isCooking()) {
                if(currentTime >= getCookingFinishTime()) {
                    finishCooking();
                }
            }

            if(currentTime >= getBurnFinishTime()) {
                finishBurning();
            }
        }

        if(player != null && player.field_7512 instanceof BackpackBaseMenu) {
            tickSmelting(level);
        }

        if(!hasCooldown() || getCooldown() != getTickRate()) {
            setCooldown(getTickRate());
        }
    }

    @Override
    public int getTickRate() {
        return 5;
    }

    public boolean isFuel(class_1799 pStack) {
        return getBurnDuration(pStack) > 0;
    }

    public boolean isBurning() {
        return getBurnFinishTime() > (long)0;
    }

    public boolean isCooking() {
        return getCookingFinishTime() > (long)0;
    }

    public boolean hasFuel() {
        return (!getStack(SLOT_FUEL).method_7960() && isFuel(getStack(SLOT_FUEL))) || isBurning();
    }

    public void tickSmelting(class_1937 level) {
        if(!this.recipeFetched && this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.method_42303(new class_9696(getStack(SLOT_INPUT)), level).orElse(null);
            this.recipeFetched = true;
        }

        boolean shouldStop = false;

        if(isCooking()) {
            if(isBurning()) {
                if(this.cachedRecipe != null) {
                    class_8786<? extends class_1874> currentRecipe = this.quickCheck.method_42303(new class_9696(getStack(SLOT_INPUT)), level).orElse(null);
                    if(this.cachedRecipe != currentRecipe) {
                        this.cachedRecipe = currentRecipe;
                        shouldStop = true;
                    }
                } else {
                    shouldStop = true;
                }
            }
        }

        if(shouldStop) {
            stopCooking();
            checkCooking(level, false);
        }
    }

    public void checkCooking(class_1937 level, boolean force) {
        if(level.field_9236 || !isEnabled(this)) {
            return;
        }

        if(this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.method_42303(new class_9696(getStack(SLOT_INPUT)), level).orElse(null);
        }

        if((force || !isCooking()) && canBurn(this.cachedRecipe)) {
            if(!isBurning()) {
                startBurning();
            }
            startCooking(this.cachedRecipe.comp_1933());
        }
    }

    public void startCooking(class_1874 recipe) {
        int cookingDuration = recipe.method_8167();
        setCookingFinishTime(this.level.method_8510() + cookingDuration);
        setCookingTotalTime(cookingDuration);
    }

    public void startBurning() {
        int litDuration = getBurnDuration(getStack(SLOT_FUEL));
        setBurnFinishTime(this.level.method_8510() + litDuration);
        setBurnTotalTime(litDuration);
        shrinkFuelSlot();
    }

    private boolean canBurn(@Nullable class_8786<? extends class_1874> recipe) {
        if(!getStack(SLOT_INPUT).method_7960() && recipe != null && hasFuel()) {
            class_1799 cookingResult = recipe.comp_1933().method_59982(new class_9696(getStack(SLOT_INPUT)), this.level.method_30349());
            if(cookingResult.method_7960()) {
                return false;
            } else {
                class_1799 resultSlotStack = getStack(SLOT_RESULT);
                if(resultSlotStack.method_7960()) {
                    return true;
                } else if(!class_1799.method_7984(resultSlotStack, cookingResult)) {
                    return false;
                } else if(resultSlotStack.method_7947() + cookingResult.method_7947() <= this.items.getSlotLimit(SLOT_RESULT) && resultSlotStack.method_7947() + cookingResult.method_7947() <= resultSlotStack.method_7914()) { // Forge fix: make furnace respect stack sizes in furnace recipes
                    return true;
                } else {
                    return resultSlotStack.method_7947() + cookingResult.method_7947() <= cookingResult.method_7914(); // Forge fix: make furnace respect stack sizes in furnace recipes
                }
            }
        } else {
            return false;
        }
    }

    public void finishCooking() {
        if(this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.method_42303(new class_9696(getStack(SLOT_INPUT)), level).orElse(null);
        }
        if(this.cachedRecipe != null) {
            class_1799 result = this.cachedRecipe.comp_1933().method_59982(new class_9696(getStack(SLOT_INPUT)), level.method_30349());

            //Reduce input slot count
            class_1799 input = getStack(SLOT_INPUT).method_7972();
            class_1799 resultSlot = getStack(SLOT_RESULT).method_7972();

            if(!resultSlot.method_7960()) {
                resultSlot.method_7933(1);
            } else {
                resultSlot = result;
            }

            if(input.method_31574(class_2246.field_10562.method_8389()) && !getStack(SLOT_FUEL).method_7960() && getStack(SLOT_FUEL).method_31574(class_1802.field_8550)) {
                setStack(SLOT_FUEL, new class_1799(class_1802.field_8705));
            }

            input.method_7934(1);
            setStack(SLOT_INPUT, input);
            setStack(SLOT_RESULT, resultSlot);
        }

        if(canBurn(this.cachedRecipe)) {
            checkCooking(this.level, true);
        } else {
            stopCooking();
        }
    }

    public void shrinkFuelSlot() {
        class_1799 fuel = getStack(SLOT_FUEL).method_7972();
        if(fuel.method_7909().method_7858() != null) {
            setStack(SLOT_FUEL, fuel.method_7909().method_7858().method_7854());
        } else {
            fuel.method_7934(1);
            setStack(SLOT_FUEL, fuel);
        }
    }

    public void finishBurning() {
        class_1799 fuel = getStack(SLOT_FUEL).method_7972();

        if(isFuel(fuel) && isCooking()) {
            startBurning();
        } else {
            stopCooking();
            stopBurning();
            this.cachedRecipe = null;
        }
    }

    public void setStack(int slot, class_1799 stack) {
        this.items.setStackInSlot(slot, stack);
    }

    public class_1799 getStack(int slot) {
        return this.items.getStackInSlot(slot);
    }

    protected int getBurnDuration(class_1799 pFuel) {
        if(pFuel.method_7960()) {
            return 0;
        } else {
            return getFabricBurnDuration(pFuel);
        }
    }

    protected int getFabricBurnDuration(class_1799 fuel) {
        if(FuelRegistry.INSTANCE.get(fuel.method_7909()) != null) {
            return FuelRegistry.INSTANCE.get(fuel.method_7909());
        }
        return 0;
    }

    public int getBurnTotalTime() {
        return getDataHolderStack().method_57825(ModDataComponents.BURN_TOTAL_TIME, 0);
    }

    public long getBurnFinishTime() {
        return getDataHolderStack().method_57825(ModDataComponents.BURN_FINISH_TIME, (long)0);
    }

    public int getCookingTotalTime() {
        return getDataHolderStack().method_57825(ModDataComponents.COOKING_TOTAL_TIME, 0);
    }

    public long getCookingFinishTime() {
        return getDataHolderStack().method_57825(ModDataComponents.COOKING_FINISH_TIME, (long)0);
    }

    public void setBurnTotalTime(int time) {
        setStackData(ModDataComponents.BURN_TOTAL_TIME, time);
    }

    public void setBurnFinishTime(long time) {
        setStackData(ModDataComponents.BURN_FINISH_TIME, time);
    }

    public void setCookingTotalTime(int time) {
        setStackData(ModDataComponents.COOKING_TOTAL_TIME, time);
    }

    public void setCookingFinishTime(long time) {
        setStackData(ModDataComponents.COOKING_FINISH_TIME, time);
    }

    public void stopCooking() {
        setCookingFinishTime(0);
        setCookingTotalTime(0);
    }

    public void stopBurning() {
        setBurnFinishTime(0);
        setBurnTotalTime(0);
    }

    public void setSlotChanged(class_1799 dataHolderStack, int index, class_1799 stack) {
        dataHolderStack.method_57367(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(3), new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
    }

    public <D> void setStackData(class_9331<D> data, D value) {
        class_1799 stack = getDataHolderStack().method_7972();
        if(value == null) {
            stack.method_57381(data);
        } else {
            stack.method_57379(data, value);
        }
        getUpgradeManager().getUpgradesHandler().setStackInSlot(getDataHolderSlot(), stack);
    }

    private ItemStackHandler createHandler(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks) {
            @Override
            protected void onContentsChanged(int slot) {
                updateDataHolderUnchecked(dataHolderStack -> setSlotChanged(dataHolderStack, slot, getStackInSlot(slot)));

                if(getUpgradeManager().getWrapper().getScreenID() == Reference.WEARABLE_SCREEN_ID) {
                    checkCooking(AbstractSmeltingUpgrade.this.level, false);
                }
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                if(slot == SLOT_INPUT) {
                    return BackpackSlotItemHandler.isItemValid(stack);
                }
                if(slot == SLOT_FUEL) {
                    class_1799 fuel = getStack(SLOT_FUEL);
                    return getFabricBurnDuration(stack) > 0 || stack.method_31574(class_1802.field_8550) && !fuel.method_31574(class_1802.field_8550);
                }
                return false;
            }

            @Override
            protected int getStackLimit(int slot, @NotNull class_1799 stack) {
                if(slot == SLOT_FUEL && stack.method_31574(class_1802.field_8550)) {
                    return 1;
                }
                return super.getStackLimit(slot, stack);
            }
        };
    }
}