package com.tiviacz.travelersbackpack.item;

import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.entity.BackpackItemEntity;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.util.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_481;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5620;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class TravelersBackpackItem extends class_1747 {
    @Deprecated(forRemoval = true)
    public final class_2960 texture;

    public TravelersBackpackItem(class_2248 block) {
        this(block, "");
    }

    @Deprecated(forRemoval = true)
    public TravelersBackpackItem(class_2248 block, String name) {
        this(block, class_2960.method_60655(TravelersBackpack.MODID, "textures/model/" + name.toLowerCase(Locale.ENGLISH) + ".png"));
    }

    @Deprecated(forRemoval = true)
    public TravelersBackpackItem(class_2248 block, class_2960 texture) {
        super(block, new class_1793().method_7889(1)
                .method_57349(ModDataComponents.TIER, 0)
                .method_57349(ModDataComponents.SLEEPING_BAG_COLOR, class_1767.field_7964.method_7789())
                .method_57349(ModDataComponents.IS_VISIBLE, true));

        //Texture location
        this.texture = texture;
    }

    @Deprecated(forRemoval = true)
    public class_2960 getBackpackTexture() {
        return this.texture;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);

        if(hand == class_1268.field_5810 || player.method_18276()) {
            return class_1271.method_22431(itemstack);
        }

        if(!TravelersBackpackConfig.getConfig().backpackSettings.allowOnlyEquippedBackpack) {
            if(!level.field_9236) {
                BackpackContainer.openBackpack((class_3222)player, player.method_31548().method_7391(), Reference.ITEM_SCREEN_ID, player.method_31548().field_7545);
            }
        } else {
            if(!ComponentUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
                ServerActions.equipBackpack(player);
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
            }
        }
        return class_1271.method_29237(itemstack, level.field_9236);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1269 interactionResult = this.method_7712(new class_1750(context));
        return !interactionResult.method_23665() ? this.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467() : interactionResult;
    }

    @Override
    public class_1269 method_7712(class_1750 context) {
        if(!context.method_7716() || (context.method_20287() == class_1268.field_5808 && context.method_8036() != null && !context.method_8036().method_18276())) {
            return class_1269.field_5814;
        } else {
            class_1750 blockitemusecontext = this.method_16356(context);

            if(blockitemusecontext == null) {
                return class_1269.field_5814;
            } else {
                class_2680 blockstate = this.method_7707(blockitemusecontext);

                if(blockstate == null) {
                    return class_1269.field_5814;
                } else if(!this.method_7708(blockitemusecontext, blockstate)) {
                    return class_1269.field_5814;
                } else {
                    class_2338 blockpos = blockitemusecontext.method_8037();
                    class_1937 level = blockitemusecontext.method_8045();
                    class_1657 player = blockitemusecontext.method_8036();
                    class_1799 itemstack = blockitemusecontext.method_8041();
                    class_2680 blockstate1 = level.method_8320(blockpos);

                    if(blockstate1.method_27852(blockstate.method_26204())) {
                        this.method_7710(blockpos, level, player, itemstack, blockstate1);
                        blockstate1.method_26204().method_9567(level, blockpos, blockstate1, player, itemstack);

                        if(level.method_8321(blockpos) instanceof BackpackBlockEntity blockEntity) {
                            blockEntity.setBackpack(itemstack, level.method_30349());
                        }

                        if(player instanceof class_3222 serverPlayer) {
                            class_174.field_1191.method_23889(serverPlayer, blockpos, itemstack);
                        }
                    }

                    level.method_33596(player, class_5712.field_28164, blockpos);
                    class_2498 soundtype = blockstate1.method_26231();
                    level.method_8396(player, blockpos, this.method_19260(blockstate1), class_3419.field_15245, (soundtype.method_10597() + 1.0F) / 2.0F, soundtype.method_10599() * 0.8F);

                    if(player == null || !player.method_31549().field_7477) {
                        itemstack.method_7934(1);
                    }

                    return class_1269.method_29236(level.field_9236);
                }
            }
        }
    }

    @Override
    protected boolean method_7710(class_2338 pPos, class_1937 pLevel, @Nullable class_1657 pPlayer, class_1799 pStack, class_2680 pState) {
        return method_7714(pLevel, pPlayer, pPos, pStack);
    }

    public static boolean method_7714(class_1937 pLevel, @Nullable class_1657 pPlayer, class_2338 pPos, class_1799 pStack) {
        MinecraftServer minecraftserver = pLevel.method_8503();
        if(minecraftserver == null) {
            return false;
        } else {
            class_2586 blockEntity = pLevel.method_8321(pPos);
            if(blockEntity != null) {
                if(pLevel.field_9236 || !blockEntity.method_11011() || pPlayer != null && pPlayer.method_7338()) {
                    blockEntity.method_58683(pStack.method_7972());
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCreative(class_1657 player) {
        return player.method_37908().method_8608() && player.field_7512 instanceof class_481.class_483;
    }

    @Override
    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        if(isCreative(player) || stack.method_7947() > 1 || !slot.method_7674(player) || action != class_5536.field_27014) {
            return super.method_31565(stack, slot, action, player);
        }
        class_1799 itemstack = slot.method_7677();
        if(BackpackSlotItemHandler.isItemValid(itemstack)) {
            int count = add(player, stack, itemstack, true);
            if(count <= 0) {
                return false;
            }
            int j = add(player, stack, slot.method_32753(count, count, player), false);
            if(j > 0) {
                this.playInsertSound(player);
            }
            return true;
        }
        return super.method_31565(stack, slot, action, player);
    }

    @Override
    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if(isCreative(player) || stack.method_7947() > 1 || !slot.method_7680(stack) || action != class_5536.field_27014) {
            return super.method_31566(stack, other, slot, action, player, access);
        }
        if(slot.method_32754(player)) {
            int i = add(player, stack, other, false);
            if(i > 0) {
                this.playInsertSound(player);
                other.method_7934(i);
            }
            return true;
        }
        return super.method_31566(stack, other, slot, action, player, access);
    }

    private static int add(class_1657 player, class_1799 backpackStack, class_1799 insertedStack, boolean simulate) {
        int k = insertedStack.method_7947();
        if(!insertedStack.method_7960() && BackpackSlotItemHandler.isItemValid(insertedStack)) {
            BackpackWrapper wrapper = BackpackWrapper.fromStack(backpackStack);
            class_1799 result = InventoryHelper.addItemStackToHandler(wrapper.getStorageForInputOutput(), insertedStack, simulate);
            return k - result.method_7947();
        } else {
            return 0;
        }
    }

    private void playInsertSound(class_1297 pEntity) {
        pEntity.method_5783(class_3417.field_34376, 0.8F, 0.8F + pEntity.method_37908().method_8409().method_43057() * 0.4F);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);

        if(stack.method_57826(ModDataComponents.TIER)) {
            tooltipComponents.add(class_2561.method_43471("tier.travelersbackpack." + Tiers.of(stack.method_57824(ModDataComponents.TIER)).getName()));
        }

        if(stack.method_57826(ModDataComponents.BACKPACK_CONTAINER) && !KeyHelper.isCtrlPressed()) {
            tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.inventory_tooltip").method_27692(class_124.field_1078));
        }

        if(TravelersBackpackConfig.getConfig().client.obtainTips) {
            if(stack.method_7909() == ModItems.BAT_TRAVELERS_BACKPACK) {
                tooltipComponents.add(class_2561.method_43471("obtain.travelersbackpack.bat").method_27692(class_124.field_1078));
            }
            if(stack.method_7909() == ModItems.VILLAGER_TRAVELERS_BACKPACK) {
                tooltipComponents.add(class_2561.method_43471("obtain.travelersbackpack.villager").method_27692(class_124.field_1078));
            }
            if(stack.method_7909() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
                tooltipComponents.add(class_2561.method_43471("obtain.travelersbackpack.iron_golem").method_27692(class_124.field_1078));
            }
        }
        //Check if specific ability is enabled && Check if Abilities are enabled overall
        if(BackpackAbilities.ALLOWED_ABILITIES.contains(stack.method_7909()) && TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities) {
            if(KeyHelper.isShiftPressed()) {
                //Custom Descriptions
                if(BackpackAbilities.CUSTOM_DESCRIPTIONS.contains(stack.method_7909())) {
                    tooltipComponents.add(class_2561.method_43471("ability.travelersbackpack." + this.method_7866(stack).replaceAll("block.travelersbackpack.", "")).method_27692(class_124.field_1078));
                }
                boolean whenEquippedPresent = false;
                //Add descriptions based on BackpackEffects (Can be added)
                if(BackpackAbilities.getBackpackEffects().containsKey(stack.method_7909())) {
                    tooltipComponents.add(class_2561.method_43471("ability.travelersbackpack.when_equipped").method_27692(class_124.field_1064));
                    whenEquippedPresent = true;
                    BackpackAbilities.getBackpackEffects().entries().stream().filter(entry -> entry.getKey() == stack.method_7909()).forEach(entry -> {
                        class_5250 mutablecomponent = class_2561.method_43470("- ");
                        mutablecomponent.method_10852(class_2561.method_43471(entry.getValue().effect().comp_349().method_5567()));
                        if(entry.getValue().amplifier() > 0) {
                            mutablecomponent = class_2561.method_43469("potion.withAmplifier", mutablecomponent, class_2561.method_43471("potion.potency." + entry.getValue().amplifier()));
                        }
                        if(BackpackAbilities.getCooldowns().containsKey(stack.method_7909())) {
                            mutablecomponent.method_27693(" " + TextUtils.getConvertedTime(entry.getValue().minDuration()));
                        }
                        tooltipComponents.add(mutablecomponent.method_27692(entry.getValue().effect().comp_349().method_18792().method_18793()));
                    });
                }

                //Add attribute modifiers
                addAttributeModifierTooltip(stack, tooltipComponents, whenEquippedPresent);

                //Tooltip to show if ability is available for equipped backpack, block, or both
                if(BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add(class_2561.method_43471("ability.travelersbackpack.item_and_block"));
                } else if(BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add(class_2561.method_43471("ability.travelersbackpack.block"));
                } else if(BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack)) {
                    tooltipComponents.add(class_2561.method_43471("ability.travelersbackpack.item"));
                }
            } else {
                tooltipComponents.add(class_2561.method_43471("ability.travelersbackpack.hold_shift").method_27692(class_124.field_1078));
            }
        }
    }

    private void addAttributeModifierTooltip(class_1799 stack, List<class_2561> components, boolean whenEquippedPresent) {
        Multimap<class_6880<class_1320>, class_1322> multimap = BackpackAbilities.ABILITIES.getAttributeAbilityMultimap(stack);
        if(!multimap.isEmpty()) {
            if(!whenEquippedPresent) {
                components.add(class_2561.method_43471("ability.travelersbackpack.when_equipped").method_27692(class_124.field_1064));
            }
            for(Map.Entry<class_6880<class_1320>, class_1322> entry : multimap.entries()) {
                class_6880<class_1320> attribute = entry.getKey();
                class_1322 modifier = entry.getValue();
                double d = modifier.comp_2449();
                double e;
                if(modifier.comp_2450() != class_1322.class_1323.field_6330 && modifier.comp_2450() != class_1322.class_1323.field_6331) {
                    if(attribute.method_55838(class_5134.field_23718)) {
                        e = d * (double)10.0F;
                    } else {
                        e = d;
                    }
                } else {
                    e = d * (double)100.0F;
                }

                if(d > (double)0.0F) {
                    components.add(class_2561.method_43469("attribute.modifier.plus." + modifier.comp_2450().method_56082(), new Object[]{class_9285.field_49329.format(e), class_2561.method_43471(((class_1320)attribute.comp_349()).method_26830())}).method_27692(((class_1320)attribute.comp_349()).method_60494(true)));
                } else if(d < (double)0.0F) {
                    components.add(class_2561.method_43469("attribute.modifier.take." + modifier.comp_2450().method_56082(), new Object[]{class_9285.field_49329.format(-e), class_2561.method_43471(((class_1320)attribute.comp_349()).method_26830())}).method_27692(((class_1320)attribute.comp_349()).method_60494(false)));
                }
            }
        }
    }

    @Nullable
    public class_1297 createEntity(class_1937 level, class_1297 entity, class_1799 itemstack) {
        if(!(entity instanceof class_1542 itemEntity)) {
            return null;
        }
        if(!hasCustomData(itemEntity.method_6983())) {
            return null;
        }

        return createBackpackEntity(level, itemEntity, itemstack);
    }

    public boolean hasCustomData(class_1799 stack) {
        if(stack.method_57825(ModDataComponents.BACKPACK_CONTAINER, BackpackContainerContents.fromItems(0, List.of())).getItems().stream().anyMatch(itemStack -> !itemStack.method_7960())) {
            return true;
        }
        class_2371<class_1799> upgrades = stack.method_57825(ModDataComponents.UPGRADES, BackpackContainerContents.fromItems(0, List.of())).getItems();
        if(upgrades.stream().anyMatch(itemStack -> !itemStack.method_7960() && !itemStack.method_31574(ModItems.TANKS_UPGRADE)) && upgrades.stream().anyMatch(itemStack -> itemStack.method_31574(ModItems.TANKS_UPGRADE))) {
            return true;
        }
        if(stack.method_57825(ModDataComponents.TOOLS_CONTAINER, BackpackContainerContents.fromItems(0, List.of())).getItems().stream().anyMatch(itemStack -> !itemStack.method_7960())) {
            return true;
        }
        if(stack.method_57825(ModDataComponents.TIER, 0) >= Tiers.DIAMOND.getOrdinal()) {
            return true;
        }
        return false;
    }

    @Nullable
    private BackpackItemEntity createBackpackEntity(class_1937 level, class_1542 itemEntity, class_1799 itemstack) {
        BackpackItemEntity backpackItemEntity = ModItems.BACKPACK_ITEM_ENTITY.method_5883(level);
        if(backpackItemEntity != null) {
            backpackItemEntity.method_5814(itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321());
            backpackItemEntity.method_6979(itemstack.method_7972());
            backpackItemEntity.method_6982(itemEntity.field_7202);
            if(itemEntity.method_24921() != null) {
                backpackItemEntity.method_6981(itemEntity.method_24921());
            }
            backpackItemEntity.method_18799(itemEntity.method_18798());
        }
        return backpackItemEntity;
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 pStack) {
        return Optional.of(new BackpackTooltipComponent(pStack));
    }

    @Override
    public boolean method_31568() {
        return false;
    }

    public static void registerCauldronInteraction() {
        class_5620.field_27776.comp_1982().put(ModItems.STANDARD_TRAVELERS_BACKPACK, class_5620.field_27782);
    }
}