package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import org.apache.commons.lang3.function.TriFunction;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_7699;

public class CraftingUpgradeItem extends UpgradeItem {
    public CraftingUpgradeItem(class_1793 pProperties) {
        super(pProperties, "crafting_upgrade");
    }

    @Override
    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.enableCraftingUpgrade && super.method_45382(enabledFeatures);
    }

    @Override
    public boolean requiresEquippedBackpack() {
        return false;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return CraftingUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents contents = provider.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(9));
            return Optional.of(new CraftingUpgrade(upgradeManager, dataHolderSlot, contents.getItems()));
        };
    }
}