package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetUpgrade;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_7699;
import org.apache.commons.lang3.function.TriFunction;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MagnetUpgradeItem extends UpgradeItem {
    public MagnetUpgradeItem(class_1793 pProperties) {
        super(pProperties, null);
    }

    @Override
    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.enableUpgrade && super.method_45382(enabledFeatures);
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        tooltipComponents.add(class_2561.method_43469("item.travelersbackpack.magnet_upgrade_tooltip", TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.pullRange).method_27692(class_124.field_1078));
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public boolean isTickingUpgrade() {
        return true;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return MagnetUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = provider.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(9));
            List<String> filterTags = new ArrayList<>(provider.method_57825(ModDataComponents.FILTER_TAGS, new ArrayList<>()));
            return Optional.of(new MagnetUpgrade(upgradeManager, dataHolderSlot, filter.getItems(), filterTags));
        };
    }
}
