package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.refill.RefillUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import org.apache.commons.lang3.function.TriFunction;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_7699;

public class RefillUpgradeItem extends UpgradeItem {
    public RefillUpgradeItem(class_1793 pProperties) {
        super(pProperties, "refill_upgrade");
    }

    @Override
    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.refillUpgradeSettings.enableUpgrade && super.method_45382(enabledFeatures);
    }

    @Override
    public boolean isTickingUpgrade() {
        return true;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return RefillUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = provider.method_57825(ModDataComponents.BACKPACK_CONTAINER, new BackpackContainerContents(9));
            return Optional.of(new RefillUpgrade(upgradeManager, dataHolderSlot, filter.getItems()));
        };
    }
}