package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import java.util.List;

public class TierUpgrade extends class_1792 {
    private final Upgrade type;

    public TierUpgrade(class_1793 pProperties, Upgrade type) {
        super(pProperties);
        this.type = type;
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        switch(type) {
            case BLANK_UPGRADE:
                tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.blank_upgrade_tooltip").method_27692(class_124.field_1078));
                break;
            case IRON_TIER_UPGRADE:
                tooltipComponents.add(class_2561.method_43469("item.travelersbackpack.tier_upgrade_tooltip", Tiers.LEATHER.getName()).method_27692(class_124.field_1078));
                break;
            case GOLD_TIER_UPGRADE:
                tooltipComponents.add(class_2561.method_43469("item.travelersbackpack.tier_upgrade_tooltip", Tiers.IRON.getName()).method_27692(class_124.field_1078));
                break;
            case DIAMOND_TIER_UPGRADE:
                tooltipComponents.add(class_2561.method_43469("item.travelersbackpack.tier_upgrade_tooltip", Tiers.GOLD.getName()).method_27692(class_124.field_1078));
                break;
            case NETHERITE_TIER_UPGRADE:
                tooltipComponents.add(class_2561.method_43469("item.travelersbackpack.tier_upgrade_tooltip", Tiers.DIAMOND.getName()).method_27692(class_124.field_1078));
                break;
        }
    }

    public enum Upgrade {
        BLANK_UPGRADE,
        IRON_TIER_UPGRADE,
        GOLD_TIER_UPGRADE,
        DIAMOND_TIER_UPGRADE,
        NETHERITE_TIER_UPGRADE
    }
}