package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import org.apache.commons.lang3.function.TriFunction;

import java.util.List;
import java.util.Optional;

public abstract class UpgradeItem extends class_1792 {
    private final class_2561 tooltipComponent;

    public UpgradeItem(class_1793 pProperties, String tooltipKey) {
        super(pProperties);
        this.tooltipComponent = tooltipKey == null ? null : class_2561.method_43471("item.travelersbackpack." + tooltipKey + "_tooltip").method_27692(class_124.field_1078);
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        if(this.tooltipComponent != null) {
            tooltipComponents.add(this.tooltipComponent);
        }
        tooltipComponents.add(class_2561.method_43471("item.travelersbackpack.upgrade_apply_tooltip"));
    }

    public boolean isTickingUpgrade() {
        return false;
    }

    public boolean requiresEquippedBackpack() {
        return true;
    }

    public abstract Class<? extends UpgradeBase<?>> getUpgradeClass();

    public abstract TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade();
}