package com.tiviacz.travelersbackpack.mixin;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupUpgrade;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1542.class)
public abstract class ItemEntityMixin {
    @Shadow
    public abstract class_1799 getItem();

    @Shadow
    public int pickupDelay;

    @Shadow
    public abstract void setItem(class_1799 stack);

    @Inject(method = "playerTouch", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;getCount()I"), cancellable = true)
    private void playerTouch(class_1657 player, CallbackInfo ci) {
        if(this.getItem().method_7960() || this.pickupDelay > 0) {
            return;
        }

        class_1937 level = player.method_37908();

        if(ComponentUtils.isWearingBackpack(player)) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper(player);
            if(wrapper.getUpgradeManager().getUpgrade(AutoPickupUpgrade.class).isPresent() && wrapper.getUpgradeManager().getUpgrade(AutoPickupUpgrade.class).get().canPickup(this.getItem())) {
                class_1799 remainingStack = InventoryHelper.insertItemStacked(wrapper.getStorageForInputOutput(), this.getItem(), false);
                if(remainingStack != this.getItem()) {
                    level.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.2F, (level.field_9229.method_43057() - level.field_9229.method_43057()) * 1.4F + 2.0F);
                    this.setItem(remainingStack);
                    ci.cancel();
                }
            }
        }
    }
}