package com.tiviacz.travelersbackpack.mixin;

import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import net.minecraft.class_310;
import net.minecraft.class_312;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_312.class, priority = 500)
public class MouseHandlerMixin {
    @Shadow
    @Final
    private class_310 minecraft;

    @Inject(method = "onScroll", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Inventory;swapPaint(D)V"), cancellable = true)
    private void mouseWheelDetect(long window, double horizontal, double vertical, CallbackInfo ci) {
        boolean bl = this.minecraft.field_1690.method_42439().method_41753();
        double d = this.minecraft.field_1690.method_41806().method_41753();
        double e = (bl ? Math.signum(horizontal) : horizontal) * d;
        double f = (bl ? Math.signum(vertical) : vertical) * d;

        if(KeybindHandler.mouseWheelDetect(e, f)) ci.cancel();
    }
}