package com.tiviacz.travelersbackpack.mixin.abilities;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.init.ModItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_2302;
import net.minecraft.class_2526;
import net.minecraft.class_2680;
import net.minecraft.class_47;
import net.minecraft.class_52;

@Mixin(class_52.class)
public class LootTableMixin {

    @Inject(at = @At(value = "TAIL"), method = "getRandomItems(Lnet/minecraft/world/level/storage/loot/LootContext;)Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", cancellable = true)
    public void setTarget(class_47 context, CallbackInfoReturnable<ObjectArrayList<class_1799>> cir) {
        ObjectArrayList<class_1799> generatedLoot = cir.getReturnValue();

        class_2680 blockState = context.method_296(class_181.field_1224);
        boolean grassVariant = false;

        if(blockState == null) {
            return;
        }

        if(blockState.method_26204() instanceof class_2526) {
            grassVariant = true;
        }

        if(!grassVariant) {
            if(!(blockState.method_26204() instanceof class_2302) || !blockState.method_28498(class_2302.field_10835) || blockState.method_11654(class_2302.field_10835) != class_2302.field_31079) {
                return;
            }
        }

        boolean modifiedLoot = false;
        class_1297 entity = context.method_296(class_181.field_1226);
        if(entity instanceof class_1657 player && BackpackAbilities.ABILITIES.checkBackpack(player, ModItems.HAY_TRAVELERS_BACKPACK)) {
            if(grassVariant) {
                if(context.method_294().method_43057() < 0.15F) {
                    if(!POSSIBLE_CROP_ITEMS.isEmpty()) {
                        class_1799 randomCrop = POSSIBLE_CROP_ITEMS.get(context.method_294().method_43048(POSSIBLE_CROP_ITEMS.size()));
                        generatedLoot.add(randomCrop);
                        modifiedLoot = true;
                    }
                }
            } else {
                for(class_1799 stack : generatedLoot) {
                    if(context.method_294().method_43057() < 0.4F) {
                        int count = stack.method_7947();
                        stack.method_7939(count * 2);
                        modifiedLoot = true;
                    }
                }
            }
        }
        if(modifiedLoot) {
            cir.setReturnValue(generatedLoot);
        }
    }

    private static final List<class_1799> POSSIBLE_CROP_ITEMS = List.of(new class_1799(class_1802.field_8179), new class_1799(class_1802.field_8567), new class_1799(class_1802.field_8186));
}
