package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.component.ITravelersBackpack;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class BackpackDeathHelper {
    public static boolean onPlayerDrops(class_1937 level, class_1657 player, class_1799 stack) {
        if(!level.field_9236) BackpackManager.addBackpack((class_3222)player, stack);

        //If grave mod installed, then skip. Backpack will be stored inside grave
        if(TravelersBackpack.isAnyGraveModInstalled()) return true;

        boolean drop = true;

        if(TravelersBackpackConfig.getConfig().backpackSettings.backpackDeathPlace) {
            if(TravelersBackpackConfig.getConfig().backpackSettings.backpackForceDeathPlace)
                drop = !placeBackpack(level, player, player.method_24515(), stack);
            else drop = !tryPlace(level, player, stack);
        }

        return drop;
    }

    private static boolean placeBackpack(class_1937 level, class_1657 player, class_2338 placePos, class_1799 stack) {
        class_2248 block = class_2248.method_9503(stack.method_7909());
        int y = placePos.method_10264();

        if(TravelersBackpackConfig.getConfig().backpackSettings.backpackForceDeathPlace) {
            class_2338 playerPos = player.method_24515();
            y = playerPos.method_10264();

            if(TravelersBackpackConfig.getConfig().backpackSettings.voidProtection) {
                if(y <= level.method_31607()) {
                    y = level.method_31607() + 5;
                }
            }

            for(int i = y; i < level.method_31605(); i++) {
                if(level.method_8320(new class_2338(playerPos.method_10263(), i, playerPos.method_10260())).method_26215()) {
                    y = i;
                    break;
                }
            }

            class_2338 targetPos = new class_2338(playerPos.method_10263(), y, playerPos.method_10260());

            if(level.method_8320(targetPos).method_26204().method_9520() > -1) {
                while(level.method_8321(targetPos) != null) {
                    targetPos = targetPos.method_10084();
                }

                if(!level.method_8501(targetPos, block.method_9564())) {
                    return false;
                }

                placeBackpackInTheWorld(level, player, targetPos, block, stack);
                return true;
            }
            return false;
        } else {
            if(y <= level.method_31607() || y >= level.method_31605()) return false;

            class_2338 targetPos = new class_2338(placePos.method_10263(), y, placePos.method_10260());

            if(!level.method_8501(targetPos, block.method_9564())) {
                return false;
            }

            placeBackpackInTheWorld(level, player, targetPos, block, stack);
            return true;
        }
    }

    /**
     * @param level     Current level
     * @param player    Current player
     * @param targetPos Final position to place backpack
     * @param block     Block to place
     * @param stack     Backpack stack
     */
    private static void placeBackpackInTheWorld(class_1937 level, class_1657 player, class_2338 targetPos, class_2248 block, class_1799 stack) {
        PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSendMessagePacket(false, targetPos));
        LogHelper.info("Your backpack has been placed at" + " X: " + targetPos.method_10263() + " Y: " + targetPos.method_10264() + " Z: " + targetPos.method_10260());

        level.method_43128(player, targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260(), block.method_9564().method_26231().method_10598(), class_3419.field_15245, 0.5F, 1.0F);

        TravelersBackpackItem.method_7714(level, player, targetPos, stack);
        level.method_8320(targetPos).method_26204().method_9567(level, targetPos, level.method_8320(targetPos), player, stack);
        ((BackpackBlockEntity)level.method_8321(targetPos)).setBackpack(stack, level.method_30349());

        if(ComponentUtils.isWearingBackpack(player) && !level.field_9236) {
            ComponentUtils.getComponent(player).ifPresent(ITravelersBackpack::remove);
        }
    }

    private static boolean tryPlace(class_1937 level, class_1657 player, class_1799 stack) {
        int X = (int)player.method_23317();
        int Z = (int)player.method_23321();
        int[] positions = {0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6};

        for(int Y : positions) {
            int y = (int)player.method_23318();
            if(TravelersBackpackConfig.getConfig().backpackSettings.voidProtection) {
                if(y <= level.method_31607()) {
                    y = level.method_31607() + 5;
                }
            }
            class_2338 spawn = getNearestEmptyChunkCoordinatesSpiral(player, level, X, Z, new class_2338(X, y + Y, Z), 12, true, 1, (byte)0);
            if(spawn != null) {
                return placeBackpack(level, player, spawn, stack);
            }
        }
        return false;
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> getTicker(class_2591<A> type, class_2591<E> targetType, class_5558<? super E> ticker) {
        return targetType == type ? (class_5558<A>)ticker : null;
    }

    /**
     * Gets you the nearest Empty Chunk Coordinates, free of charge! Looks in two dimensions and finds a block
     * that a: can have stuff placed on it and b: has space above it.
     * This is a spiral search, will begin at close range and move out.
     *
     * @param level  The world object.
     * @param origX  Original X coordinate
     * @param origZ  Original Z coordinate
     * @param pos    Moving X coordinate, should be the same as origX when called.
     * @param pos    Y coordinate, does not move.
     * @param pos    Moving Z coordinate, should be the same as origZ when called.
     * @param radius The radius of the search. If set to high numbers, will create a ton of lag
     * @param except Wether to include the origin of the search as a valid block.
     * @param steps  Number of steps of the recursive recursiveness that recurses through the recursion. It is the first size of the spiral, should be one (1) always at the first call.
     * @param pass   Pass switch for the witchcraft I can't quite explain. Set to 0 always at the beggining.
     * @return The coordinates of the block in the chunk of the world of the game of the server of the owner of the computer, where you can place something above it.
     */
    public static class_2338 getNearestEmptyChunkCoordinatesSpiral(class_1657 player, class_1937 level, int origX, int origZ, class_2338 pos, int radius, boolean except, int steps, byte pass) {
        //Spiral search, because Mr Darkona is awesome :)
        //This is so the backpack tries to get placed near the death point first
        //And then goes looking farther away at each step
        //Steps mod 2 == 0 => X++, Z--
        //Steps mod 2 == 1 => X--, Z++

        if(steps >= radius) {
            return null;
        }

        int i = pos.method_10263();
        int j = pos.method_10260();

        if(steps % 2 == 0) {
            if(pass == 0) {
                for(; i <= pos.method_10263() + steps; i++) {
                    class_2338 blockPos = checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if(blockPos != null) {
                        return blockPos;
                    }
                }
                pass++;
                return getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass);
            }

            if(pass == 1) {
                for(; j >= pos.method_10260() - steps; j--) {
                    class_2338 blockPos = checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if(blockPos != null) {
                        return blockPos;
                    }
                }
                pass--;
                steps++;
                return getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass);
            }
        }

        if(steps % 2 == 1) {
            if(pass == 0) {
                for(; i >= pos.method_10263() - steps; i--) {
                    class_2338 blockPos = checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if(blockPos != null) {
                        return blockPos;
                    }
                }
                pass++;
                return getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass);
            }

            if(pass == 1) {
                for(; j <= pos.method_10260() + steps; j++) {
                    class_2338 blockPos = checkCoordsForBackpack(player, level, origX, origZ, pos, except);
                    if(blockPos != null) {
                        return blockPos;
                    }
                }
                pass--;
                steps++;
                return getNearestEmptyChunkCoordinatesSpiral(player, level, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass);
            }
        }
        return null;
    }

    public static boolean isTopSolid(class_1937 level, class_1657 player, class_2338 pos) {
        return level.method_8320(pos.method_10074()).method_26168(level, pos.method_10074(), player);
    }

    private static class_2338 checkCoordsForBackpack(class_1657 player, class_1937 level, int origX, int origZ, class_2338 pos, boolean except) {
        if(except && isTopSolid(level, player, pos) && (level.method_8320(pos).method_26215() || level.method_8320(pos).method_45474()) && !areCoordinatesTheSame(new class_2338(origX, pos.method_10264(), origZ), pos)) {
            return pos;
        }
        if(!except && isTopSolid(level, player, pos) && (level.method_8320(pos).method_26215() || level.method_8320(pos).method_45474())) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(class_2338 pos1, class_2338 pos2) {
        return pos1 == pos2;
    }

    public static class_2338 findBlock3D(class_1937 level, int x, int y, int z, class_2248 block, int hRange, int vRange) {
        for(int i = (y - vRange); i <= (y + vRange); i++) {
            for(int j = (x - hRange); j <= (x + hRange); j++) {
                for(int k = (z - hRange); k <= (z + hRange); k++) {
                    if(level.method_8320(new class_2338(j, i, k)).method_26204() == block) {
                        return new class_2338(j, i, k);
                    }
                }
            }
        }
        return null;
    }
}