package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.init.ModFluids;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class FluidStackHelper {
    public static class_3414 getFluidEmptySound(FluidVariant fluidVariant) {
        class_3414 soundevent = FluidVariantAttributes.getEmptySound(fluidVariant); //.getFluidType().getSound(SoundActions.BUCKET_EMPTY);

        if(soundevent == null) {
            soundevent = fluidVariant.getFluid().method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        }

        return soundevent;
    }

    public static class_3414 getFluidFillSound(FluidVariant fluidVariant) {
        class_3414 soundevent = FluidVariantAttributes.getFillSound(fluidVariant);//fluid.getFluidType().getSound(SoundActions.BUCKET_FILL);

        if(soundevent == null) {
            soundevent = fluidVariant.getFluid().method_15791(class_3486.field_15518) ? class_3417.field_15202 : class_3417.field_15126;
        }

        return soundevent;
    }

    public static FluidVariant setPotionFluidVariant(class_1799 stack, int potionType) {
        FluidVariant newVariant;

        if(stack.method_57826(class_9334.field_49651)) {
            class_9326.class_9327 patch = class_9326.method_57841().method_57854(class_9334.field_49651, stack.method_57824(class_9334.field_49651));
            if(potionType == 1 || potionType == 2) {
                class_2487 potionTypeTag = new class_2487();
                potionTypeTag.method_10569("PotionType", potionType);
                patch.method_57854(class_9334.field_49628, class_9279.method_57456(potionTypeTag));
            }
            newVariant = FluidVariant.of(ModFluids.POTION_STILL, patch.method_57852());
        } else {
            newVariant = FluidVariant.of(ModFluids.POTION_STILL);
        }
        return newVariant;
    }

    public static class_1844 getPotionTypeFromFluidVariant(FluidVariant variant) {
        return variant.getComponents().method_57845(class_9334.field_49651).get();
    }

    public static class_1799 getItemStackFromFluidStack(FluidVariant variant) {
        return createPotionStack(class_1802.field_8574, getPotionTypeFromFluidVariant(variant));
    }

    public static class_1799 getSplashItemStackFromFluidStack(FluidVariant fluidStack) {
        return createPotionStack(class_1802.field_8436, getPotionTypeFromFluidVariant(fluidStack));
    }

    public static class_1799 getLingeringItemStackFromFluidStack(FluidVariant fluidStack) {
        return createPotionStack(class_1802.field_8150, getPotionTypeFromFluidVariant(fluidStack));
    }

    public static class_1799 createPotionStack(class_1792 item, class_1844 contents) {
        class_1799 itemStack = new class_1799(item);
        itemStack.method_57379(class_9334.field_49651, contents);
        return itemStack;
    }
}