package com.tiviacz.travelersbackpack.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;

public class RenderHelper {
    public static void renderScreenTank(class_332 guiGraphics, FluidTank tank, double x, double y, double z, double height, double width) {
        renderScreenTank(guiGraphics, tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, z, height, width);
    }

    public static void renderScreenTank(class_332 guiGraphics, FluidVariantWrapper fluid, long capacity, long amount, double x, double y, double z, double height, double width) {
        if(fluid == null || fluid.fluidVariant().getFluid() == null || amount <= 0) {
            return;
        }

        class_1058 icon = FluidVariantRendering.getSprite(fluid.fluidVariant()); //Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of(fluid.getFluid().getFluidType()).getStillTexture());

        if(icon == null) {
            icon = class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }

        int renderAmount = (int)Math.max(Math.min(height, amount * height / capacity), 1);
        int posY = (int)(y + height - renderAmount);

        int color = FluidVariantRendering.getColor(fluid.fluidVariant()); // IClientFluidTypeExtensions.of(fluid.getFluid().getFluidType()).getTintColor(fluid);

        guiGraphics.method_51448().method_22903();

        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((color >> 16 & 0xFF) / 255f, (color >> 8 & 0xFF) / 255f, (color & 0xFF) / 255f, 1);
        RenderSystem.setShaderTexture(0, class_1723.field_21668);
        RenderSystem.disableBlend();

        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);

        for(int i = 0; i < width; i += 16) {
            for(int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - i, 16);
                int drawHeight = Math.min(renderAmount - j, 16);

                int drawX = (int)(x + i);
                int drawY = posY + j;

                float minU;
                float minV;

                minU = icon.method_4594();
                minV = icon.method_4593();

                float maxU = icon.method_4577();
                float maxV = icon.method_4575();

                builder.method_22918(matrix4f, drawX, drawY + drawHeight, (float)z).method_22913(minU, minV + (maxV - minV) * (float)drawHeight / 16F);
                builder.method_22918(matrix4f, drawX + drawWidth, drawY + drawHeight, (float)z).method_22913(minU + (maxU - minU) * (float)drawWidth / 16F, minV + (maxV - minV) * drawHeight / 16F);
                builder.method_22918(matrix4f, drawX + drawWidth, drawY, (float)z).method_22913(minU + (maxU - minU) * drawWidth / 16F, minV);
                builder.method_22918(matrix4f, drawX, drawY, (float)z).method_22913(minU, minV);
            }
        }
        class_286.method_43433(builder.method_60800());
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        guiGraphics.method_51448().method_22909();
    }

    private static final float OFFSET = 0.01F;
    private static final float MINY = OFFSET;
    private static final float MIN = 0.125F + OFFSET;
    private static final float MAX = 0.3F - OFFSET;
    private static final float[][][] coordinates = {
            { // DOWN
                    {MIN, MINY, MAX},
                    {MIN, MINY, MIN},
                    {MAX, MINY, MIN},
                    {MAX, MINY, MAX}
            },
            { // UP
                    {MAX, MAX, MAX},
                    {MAX, MAX, MIN},
                    {MIN, MAX, MIN},
                    {MIN, MAX, MAX}
            },
            { // NORTH
                    {MIN, MINY, MIN},
                    {MIN, MAX, MIN},
                    {MAX, MAX, MIN},
                    {MAX, MINY, MIN}
            },
            { // SOUTH
                    {MAX, MINY, MAX},
                    {MAX, MAX, MAX},
                    {MIN, MAX, MAX},
                    {MIN, MINY, MAX}
            },
            { // WEST
                    {MIN, MINY, MAX},
                    {MIN, MAX, MAX},
                    {MIN, MAX, MIN},
                    {MIN, MINY, MIN}
            },
            { // EAST
                    {MAX, MINY, MIN},
                    {MAX, MAX, MIN},
                    {MAX, MAX, MAX},
                    {MAX, MINY, MAX}
            }
    };

    public static void renderFluidSides(class_4587 poseStack, class_4597 buffer, float height, FluidVariantWrapper fluid, int brightness) {
        Triple<Float, Float, Float> colorParts = getFluidVertexBufferColor(fluid);
        float r = colorParts.getLeft();
        float g = colorParts.getMiddle();
        float b = colorParts.getRight();
        float a = 1.0F;
        Matrix4f matrix4f = poseStack.method_23760().method_23761();

        for(class_2350 direction : class_2350.values()) {
            class_1058 icon = FluidVariantRendering.getSprite(fluid.fluidVariant());//getFluidIcon(fluid, direction);
            class_4588 renderer = buffer.getBuffer(class_1921.method_23028(icon.method_45852()));

            float[][] c = coordinates[direction.ordinal()];
            float replacedMaxV = (direction == class_2350.field_11036 || direction == class_2350.field_11033) ? icon.method_4570(4F / 16) : ((icon.method_4575() - icon.method_4593()) * height + icon.method_4593());
            float replacedU1 = (direction == class_2350.field_11036 || direction == class_2350.field_11033) ? icon.method_4580(4F / 16) : icon.method_4580(7F / 16);
            float replacedU2 = (direction == class_2350.field_11036 || direction == class_2350.field_11033) ? icon.method_4580(8F / 16) : icon.method_4580(8F / 16);

            renderer.method_22918(matrix4f, c[0][0], getHeight(c[0][1], height), c[0][2]).method_22915(r, g, b, a).method_22913(replacedU1, replacedMaxV).method_60803(brightness);
            renderer.method_22918(matrix4f, c[1][0], getHeight(c[1][1], height), c[1][2]).method_22915(r, g, b, a).method_22913(replacedU1, icon.method_4593()).method_60803(brightness);
            renderer.method_22918(matrix4f, c[2][0], getHeight(c[2][1], height), c[2][2]).method_22915(r, g, b, a).method_22913(replacedU2, icon.method_4593()).method_60803(brightness);
            renderer.method_22918(matrix4f, c[3][0], getHeight(c[3][1], height), c[3][2]).method_22915(r, g, b, a).method_22913(replacedU2, replacedMaxV).method_60803(brightness);
        }
    }

    private static float getHeight(float height, float replaceHeight) {
        if(height == MAX) {
            return replaceHeight;
        }
        return height;
    }

    public static void renderFluidInTank(FluidTank tank, class_4587 poseStack, class_4597 buffer, int combinedLightIn, float x, float y, float z) {
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180F));
        if(!tank.isEmpty() && !tank.getFluid().isEmpty()) {
            poseStack.method_46416(x, y, z);
            float height = getTankFillRatio(tank) * 0.99F;
            RenderHelper.renderFluidSides(poseStack, buffer, height, tank.getFluid(), combinedLightIn);
        }
        poseStack.method_22909();
    }

 /*   public static TextureAtlasSprite getFluidIcon(FluidVariantWrapper fluidstack, Direction direction) {
        Block defaultBlock = Blocks.WATER;
        Block block = defaultBlock;
        block = fluidstack.getFluid().getFluidType().getBlockForFluidState(Minecraft.getInstance().level, BlockPos.ZERO, fluidstack.getFluid().defaultFluidState()).getBlock();

        if(direction == null) {
            direction = Direction.UP;
        }

        TextureAtlasSprite icon = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of(fluidstack.getFluid().getFluidType()).getFlowingTexture());

        if(icon == null || (direction == Direction.UP || direction == Direction.DOWN)) {
            //icon = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of(fluidstack.getFluid().getFluidType()).getStillTexture());
            icon = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(FluidVariantRendering.getSprite(fluidstack.fluidVariant().getFluidType()).getStillTexture());
        }
        if(icon == null) {
            icon = getBlockIcon(block);
            if(icon == null) {
                icon = getBlockIcon(defaultBlock);
            }
        }
        return icon;
    } */

    public static class_1058 getBlockIcon(class_2248 block) {
        return class_310.method_1551().method_1541().method_3351().method_3339(block.method_9564());
    }

    public static float getTankFillRatio(FluidTank tank) {
        return Math.min(1.0F, ((float)tank.getFluidAmount()) / (float)tank.getCapacity()) * 0.5F;
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidVariantWrapper fluidStack) {
        int color = FluidVariantRendering.getColor(fluidStack.fluidVariant());
        return intToRGB(color);
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red, green, blue;
        red = (float)(color >> 16 & 255) / 255.0F;
        green = (float)(color >> 8 & 255) / 255.0F;
        blue = (float)(color & 255) / 255.0F;
        return Triple.of(red, green, blue);
    }
}