/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.UpgradeSlot;
import com.tiviacz.travelersbackpack.client.screens.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.MoreButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortingButtons;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.item.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BackpackScreen
extends AbstractBackpackScreen<BackpackBaseMenu>
implements class_3936<BackpackBaseMenu> {
    public boolean tanksVisible;
    public List<UpgradeSlot> upgradeSlots = new ArrayList<UpgradeSlot>();
    public List<IButton> buttons = new ArrayList<IButton>();
    public SortingButtons sortingButtons;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public int warningTicks = 0;

    public BackpackScreen(BackpackBaseMenu backpackMenu, class_1661 inventory, class_2561 component) {
        super(backpackMenu, inventory, backpackMenu.getWrapper().getBackpackScreenTitle());
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.field_25267 = 8 + (this.tanksVisible ? 22 : 0);
    }

    protected void method_25426() {
        super.method_25426();
        this.initButtons();
        this.initWidgets();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.updateScreen(true);
        ((BackpackBaseMenu)this.method_17577()).updateSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    protected void method_37432() {
        super.method_37432();
        if (this.warningTicks > 0) {
            --this.warningTicks;
        }
    }

    public void recalculate() {
        boolean wideTexture;
        this.method_37067();
        this.upgradeSlots.clear();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.tanksVisible = this.getWrapper().tanksVisible();
        this.field_2776 = 0;
        this.field_2800 = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.field_2792 = wideTexture ? (this.tanksVisible ? 256 : 212) : (this.tanksVisible ? 220 : 176);
        this.field_2779 = 17 + this.slotsHeight + playerInventoryHeight;
        this.updateDimensions();
        this.field_25270 = 20 + this.visibleRows * 18;
        this.field_25269 = 8;
        this.field_25267 = 8 + (this.tanksVisible ? 22 : 0);
        this.field_25268 = 6;
        if (this.tanksVisible) {
            this.field_25269 += 22;
        }
        if (wideTexture) {
            this.field_25269 += 18;
        }
        if (((BackpackBaseMenu)this.field_2797).method_7611((int)0).field_7872 >= 0) {
            this.slotYPos = ((BackpackBaseMenu)this.field_2797).method_7611((int)0).field_7872;
        }
    }

    public int getMiddleBar() {
        return 17 + this.calculateSlotHeight(this.visibleRows) + 1;
    }

    public int getWidthAdditions() {
        int addition = 0;
        if (this.tanksVisible) {
            addition += 22;
        }
        if (this.wider) {
            addition += 18;
        }
        return addition;
    }

    public void updateScreen(boolean duplicatedCall) {
        this.isScrollable = false;
        this.recalculate();
        this.method_25426();
        if (!duplicatedCall) {
            this.updateBackpackSlotsPosition();
            this.updatePlayerSlotsPosition();
        }
    }

    @Override
    public void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.renderUpgradeSlots(guiGraphics, x, y);
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        int inventoryXOffset = this.tanksVisible ? 22 : 0;
        this.renderInventoryBackground(guiGraphics, x + inventoryXOffset, y, wideTexture ? BACKGROUND_11 : BACKGROUND_9, this.field_2792, this.slotsHeight);
        int slotsXOffset = 7;
        if (this.tanksVisible) {
            slotsXOffset = 29;
            int halfTankHeight = this.slotsHeight / 2;
            int tanksHeight = 90;
            int uOffset = 56;
            int posOffset = 193;
            if (wideTexture) {
                uOffset = 0;
                posOffset = 229;
            }
            guiGraphics.method_25302(TANKS, x, y, 0, 0, 27, 8 + halfTankHeight);
            guiGraphics.method_25302(TANKS, x, y + 17 - 9 + halfTankHeight, uOffset, 256 - (tanksHeight + halfTankHeight + 17), 27, tanksHeight + halfTankHeight + 17 - 9);
            guiGraphics.method_25302(TANKS, x + posOffset, y, uOffset + 28, 0, 27, 8 + halfTankHeight);
            guiGraphics.method_25302(TANKS, x + posOffset, y + 17 - 9 + halfTankHeight, uOffset + 28, 256 - (tanksHeight + halfTankHeight + 17), 27, tanksHeight + halfTankHeight + 17 - 9);
        }
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 17, this.slotCount);
        this.renderLockedBackpackSlot(guiGraphics);
    }

    public void renderUpgradeSlots(class_332 guiGraphics, int x, int y) {
        for (UpgradeSlot slot : this.upgradeSlots) {
            slot.render(guiGraphics, x, y);
        }
    }

    public void initializeUpgradeSlots() {
        for (int i = 0; i < this.getWrapper().getUpgrades().getSlots(); ++i) {
            int x = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).field_7873 - 4;
            int y = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).field_7872 - 4;
            this.upgradeSlots.add(new UpgradeSlot(this.getWrapper(), new Point(this.getGuiLeft() + x, this.getGuiTop() + y), i, x, y, ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).isHidden));
        }
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4), false);
        this.method_37063(this.settingsWidget);
        int xPos = this.field_2776 + (this.wider ? 36 : 0) + (this.tanksVisible ? 22 : 0) + 120;
        this.sortingButtons = new SortingButtons(this, new Point(xPos, this.field_2800 - 10 + 12), 50, 13);
        this.method_37063(this.sortingButtons);
        int xPosTools = (this.wider ? 36 : 0) + (this.tanksVisible ? 22 : 0);
        this.toolSlotsWidget = new ToolSlotsWidget(this, new Point(this.field_2776 + xPosTools + 110, this.field_2800 - 10 + 15), xPosTools);
        this.method_37063(this.toolSlotsWidget);
        UpgradeManager manager = this.getWrapper().getUpgradeManager();
        Iterator iterator = manager.mappedUpgrades.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional upgrade = (Optional)manager.mappedUpgrades.get((Object)i);
            upgrade.ifPresent(loadedUpgrade -> {
                int x = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).field_7873 - 4;
                int y = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).field_7872 - 4;
                this.method_37063(loadedUpgrade.createWidget(this, x, y));
            });
        }
        this.initializeUpgradeSlots();
        if (this.isScrollable) {
            int scrollXPos = this.field_2776 + 7 + (this.tanksVisible ? 22 : 0);
            this.scroll = new InventoryScroll(this, class_310.method_1551(), 4, this.visibleRows * 18, this.field_2800 + 17, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.method_37063((class_364)this.scroll);
        }
    }

    public void initButtons() {
        this.buttons.clear();
        int xOffset = 0;
        if (this.getWrapper().getScreenID() == 1 && !TravelersBackpack.enableIntegration()) {
            this.buttons.add(new EquipButton(this, this.getWrapper().getBackpackSlotIndex() == this.getScreenPlayer().method_31548().field_7545));
            xOffset += 12;
        }
        if (this.getWrapper().getScreenID() == 2 && this.getWrapper().isOwner(((BackpackBaseMenu)this.method_17577()).player)) {
            this.buttons.add(new MoreButton(this));
            if (!TravelersBackpack.enableIntegration()) {
                this.buttons.add(new UnequipButton(this));
                xOffset += 12;
            }
            if (TravelersBackpackConfig.getConfig().backpackSettings.quickSleepingBag) {
                this.buttons.add(new SleepingBagButton(this, true, xOffset));
                xOffset += 12;
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, false, xOffset));
            }
        }
        if (this.getWrapper().getScreenID() == 3) {
            this.buttons.add(new MoreButton(this));
            this.buttons.add(new SleepingBagButton(this, false, 0));
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, true, 12));
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> {
            if (this.getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
        });
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> {
            if (this.getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        });
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
        this.renderFluidWarningTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void drawUnsortableSlots(class_332 guiGraphics) {
        if (!this.getWrapper().getUnsortableSlots().isEmpty()) {
            this.getWrapper().getUnsortableSlots().forEach(i -> guiGraphics.method_25302(ICONS, this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25, 55, 16, 16));
        }
    }

    @Override
    public void drawMemorySlots(class_332 guiGraphics) {
        if (!this.getWrapper().getMemorySlots().isEmpty()) {
            this.getWrapper().getMemorySlots().forEach(pair -> {
                if (((BackpackBaseMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                    class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                    guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected boolean method_2381(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (!((BackpackBaseMenu)this.field_2797).method_34255().method_7960()) {
            for (class_364 widget : this.method_25396()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).method_25405(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.field_2792) || pMouseY >= (double)(pGuiTop + this.field_2779);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.buttons.forEach(b -> {
            if (this.getWrapper().showMoreButtons() || b instanceof MoreButton || b instanceof EquipButton) {
                b.mouseClicked(mouseX, mouseY, button);
            }
        });
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        FilterUpgradeWidgetBase widget;
        class_364 child;
        if (this.method_19355(mouseX, mouseY).isPresent() && (child = (class_364)this.method_19355(mouseX, mouseY).get()) instanceof FilterUpgradeWidgetBase && ((FilterUpgradeBase)(widget = (FilterUpgradeWidgetBase)child).getUpgrade()).isTagSelector() && widget.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (KeybindHandler.SORT_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            ServerboundActionTagPacket.create(3, 0, KeyHelper.isShiftPressed());
            this.playUIClickSound();
            return true;
        }
        if (KeybindHandler.OPEN_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if (!(playerEntity == null || this.field_2787 != null && this.field_2787.method_7677().method_7909() instanceof TravelersBackpackItem)) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public static void displayTanksUpgradeWarning(class_1657 player) {
        class_437 class_4372;
        if (player.method_37908().field_9236 && (class_4372 = class_310.method_1551().field_1755) instanceof BackpackScreen) {
            BackpackScreen screen = (BackpackScreen)class_4372;
            screen.warningTicks = 60;
        }
    }

    public void renderFluidWarningTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.warningTicks > 0) {
            if (!(((BackpackBaseMenu)this.field_2797).method_34255().method_7909() instanceof TanksUpgradeItem)) {
                this.warningTicks = 0;
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(class_2561.method_43471((String)"screen.travelersbackpack.cant_apply_upgrade"));
            tooltip.add(class_2561.method_43471((String)"screen.travelersbackpack.too_much_fluid"));
            FluidVariantWrapper leftFluidStack = TanksUpgradeItem.getLeftFluidStack(((BackpackBaseMenu)this.field_2797).method_34255());
            FluidVariantWrapper rightFluidStack = TanksUpgradeItem.getRightFluidStack(((BackpackBaseMenu)this.field_2797).method_34255());
            if (!leftFluidStack.isEmpty() && leftFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.createFluidWarning(leftFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            if (!rightFluidStack.isEmpty() && rightFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.createFluidWarning(rightFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            guiGraphics.method_51437(this.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public class_2561 createFluidWarning(FluidVariantWrapper fluidVariantWrapper, long backpackCapacity) {
        return class_2561.method_43470((String)(FluidTypeHelper.getFluidVariantName(fluidVariantWrapper.fluidVariant()).getString() + " " + fluidVariantWrapper.amount() + "/" + backpackCapacity + "mB")).method_27692(class_124.field_1061);
    }
}

