/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.commands.BackpackIconCommands;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.network.ServerboundRetrieveBackpackPacket;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="travelersbackpack", value={Dist.CLIENT})
public class NeoForgeClientEventHandler {
    @SubscribeEvent
    public static void renderBackpackIcon(ScreenEvent.Render.Post event) {
        Screen backpack;
        Screen menu;
        AbstractContainerScreen screen;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Screen screen2 = mc.f_91080_;
        if (screen2 instanceof AbstractContainerScreen) {
            screen = (AbstractContainerScreen)screen2;
            if (!TravelersBackpackItem.isCreative((Player)player)) {
                menu = screen.m_6262_();
                ItemStack carried = menu.m_142621_();
                Slot hoveredSlot = screen.getSlotUnderMouse();
                Optional<TooltipComponent> tooltip = Optional.empty();
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)screen.getGuiLeft(), (float)screen.getGuiTop(), 350.0f);
                for (Slot slot : menu.f_38839_) {
                    ItemStack slotStack = slot.m_7993_();
                    if (carried.m_41720_() instanceof TravelersBackpackItem) {
                        tooltip = Optional.of(new BackpackTooltipComponent(carried, true));
                        if (slotStack.m_41619_() || !slot.m_8010_((Player)player) || !BackpackSlotItemHandler.isItemValid(slotStack)) continue;
                        guiGraphics.m_280488_(mc.f_91062_, "-", slot.f_40220_ + 2, slot.f_40221_ - 1, ChatFormatting.YELLOW.m_126665_().intValue());
                        if (slot != hoveredSlot) continue;
                        NeoForgeClientEventHandler.renderBackpackTooltipOnHover(event, mc, tooltip, screen.getGuiLeft(), screen.getGuiTop(), 350.0f);
                        continue;
                    }
                    if (carried.m_41619_() || !BackpackSlotItemHandler.isItemValid(carried) || !(slotStack.m_41720_() instanceof TravelersBackpackItem) || !slot.m_150651_((Player)player)) continue;
                    tooltip = Optional.of(new BackpackTooltipComponent(slotStack, true));
                    guiGraphics.m_280488_(mc.f_91062_, "+", slot.f_40220_ + 9, slot.f_40221_ + 8, ChatFormatting.YELLOW.m_126665_().intValue());
                    if (slot != hoveredSlot) continue;
                    NeoForgeClientEventHandler.renderBackpackTooltipOnHover(event, mc, tooltip, screen.getGuiLeft(), screen.getGuiTop(), 350.0f);
                }
                guiGraphics.m_280168_().m_85849_();
            }
        }
        if ((menu = mc.f_91080_) instanceof InventoryScreen) {
            screen = (InventoryScreen)menu;
            if (CapabilityUtils.getCapability((Player)player).isPresent() && ((ITravelersBackpack)CapabilityUtils.getCapability((Player)player).resolve().get()).hasBackpack() && TravelersBackpack.enableIntegration()) {
                backpack = ((ITravelersBackpack)CapabilityUtils.getCapability((Player)player).resolve().get()).getBackpack();
                guiGraphics.m_280480_((ItemStack)backpack, screen.getGuiLeft() + 77, screen.getGuiTop() + 62 - 18);
                if (event.getMouseX() >= screen.getGuiLeft() + 77 && event.getMouseX() < screen.getGuiLeft() + 77 + 16 && event.getMouseY() >= screen.getGuiTop() + 62 - 18 && event.getMouseY() < screen.getGuiTop() + 62 - 18 + 16) {
                    AbstractContainerScreen.m_280359_((GuiGraphics)guiGraphics, (int)(screen.getGuiLeft() + 77), (int)(screen.getGuiTop() + 62 - 18), (int)-1000);
                    ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                    components.add(Component.m_237115_((String)"screen.travelersbackpack.retrieve_backpack"));
                    guiGraphics.m_280677_(mc.f_91062_, components, Optional.of(new BackpackTooltipComponent((ItemStack)backpack)), event.getMouseX(), event.getMouseY());
                }
            }
        }
        if (!((Boolean)TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.get()).booleanValue()) {
            return;
        }
        backpack = mc.f_91080_;
        if (backpack instanceof InventoryScreen) {
            screen = (InventoryScreen)backpack;
            if (CapabilityUtils.isWearingBackpack((Player)player)) {
                if (TravelersBackpack.enableIntegration()) {
                    return;
                }
                backpack = CapabilityUtils.getWearingBackpack((Player)player);
                guiGraphics.m_280480_((ItemStack)backpack, screen.getGuiLeft() + 77, screen.getGuiTop() + 62 - 18);
                if (event.getMouseX() >= screen.getGuiLeft() + 77 && event.getMouseX() < screen.getGuiLeft() + 77 + 16 && event.getMouseY() >= screen.getGuiTop() + 62 - 18 && event.getMouseY() < screen.getGuiTop() + 62 - 18 + 16) {
                    AbstractContainerScreen.m_280359_((GuiGraphics)guiGraphics, (int)(screen.getGuiLeft() + 77), (int)(screen.getGuiTop() + 62 - 18), (int)-1000);
                    String button = ModClientEventHandler.OPEN_BACKPACK.getKey().m_84875_().getString();
                    ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                    components.add(Component.m_237110_((String)"screen.travelersbackpack.open_inventory", (Object[])new Object[]{button}));
                    components.add(Component.m_237115_((String)"screen.travelersbackpack.unequip_tip"));
                    components.add(Component.m_237115_((String)"screen.travelersbackpack.hide_icon"));
                    TooltipFlag.Default tooltipflag$default = mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
                    backpack.m_41720_().m_7373_((ItemStack)backpack, player.m_9236_(), components, (TooltipFlag)tooltipflag$default);
                    guiGraphics.m_280677_(mc.f_91062_, components, Optional.of(new BackpackTooltipComponent((ItemStack)backpack)), event.getMouseX(), event.getMouseY());
                }
            }
        }
    }

    private static void renderBackpackTooltipOnHover(ScreenEvent.Render.Post event, Minecraft mc, Optional<TooltipComponent> component, float fx, float fy, float fz) {
        PoseStack poseStack = event.getGuiGraphics().m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(-fx, -fy, -fz);
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        event.getGuiGraphics().m_280677_(mc.f_91062_, List.of(Component.m_237115_((String)"screen.travelersbackpack.add_to_backpack").m_130940_(ChatFormatting.YELLOW)), component, event.getMouseX(), event.getMouseY());
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void hideBackpackIcon(ScreenEvent.MouseButtonPressed.Post event) {
        InventoryScreen screen;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        if (screen2 instanceof InventoryScreen) {
            screen = (InventoryScreen)screen2;
            if (CapabilityUtils.getCapability((Player)player).isPresent() && ((ITravelersBackpack)CapabilityUtils.getCapability((Player)player).resolve().get()).hasBackpack() && TravelersBackpack.enableIntegration() && event.getMouseX() >= (double)(screen.getGuiLeft() + 77) && event.getMouseX() < (double)(screen.getGuiLeft() + 77 + 16) && event.getMouseY() >= (double)(screen.getGuiTop() + 62 - 18) && event.getMouseY() < (double)(screen.getGuiTop() + 62 - 18 + 16) && event.getButton() == 0) {
                PacketDistributorHelper.sendToServer(new ServerboundRetrieveBackpackPacket(((ITravelersBackpack)CapabilityUtils.getCapability((Player)player).resolve().get()).getBackpack().m_41720_().m_7968_()));
            }
        }
        if (!((Boolean)TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.get()).booleanValue()) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack((Player)player) && (screen2 = Minecraft.m_91087_().f_91080_) instanceof InventoryScreen) {
            screen = (InventoryScreen)screen2;
            if (TravelersBackpack.enableIntegration()) {
                return;
            }
            if (event.getMouseX() >= (double)(screen.getGuiLeft() + 77) && event.getMouseX() < (double)(screen.getGuiLeft() + 77 + 16) && event.getMouseY() >= (double)(screen.getGuiTop() + 62 - 18) && event.getMouseY() < (double)(screen.getGuiTop() + 62 - 18 + 16) && event.getButton() == 0) {
                if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                    player.m_213846_((Component)Component.m_237115_((String)"screen.travelersbackpack.hide_icon_info"));
                } else {
                    ServerboundActionTagPacket.create(1, new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void screenTickEvent(ScreenEvent.KeyPressed.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOpeningFromSlot.get()).booleanValue()) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            Slot slot;
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (event.getScreen().getMinecraft().f_91074_ != null && ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode())) && (slot = screen2.getSlotUnderMouse()) != null && slot.m_7993_().m_41720_() instanceof TravelersBackpackItem && slot.m_150651_((Player)event.getScreen().getMinecraft().f_91074_) && slot.f_40218_ instanceof Inventory) {
                ServerboundActionTagPacket.create(2, slot.m_150661_(), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        block12: {
            LocalPlayer player;
            block11: {
                ItemStack heldItem;
                if (event.phase != TickEvent.Phase.START) {
                    return;
                }
                player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                if (player.m_21205_().m_41720_() instanceof HoseItem && NbtHelper.has(player.m_21205_(), "HoseModes")) {
                    while (ModClientEventHandler.TOGGLE_TANK.m_90859_()) {
                        ServerboundActionTagPacket.create(12, new Object[0]);
                    }
                }
                if (((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue() && !ToolSlotItemHandler.isValid(heldItem = player.m_21205_())) {
                    while (ModClientEventHandler.SWAP_TOOL.m_90859_()) {
                        if (heldItem.m_41619_() || !(heldItem.m_41720_() instanceof HoseItem) || !NbtHelper.has(heldItem, "HoseModes")) continue;
                        ServerboundActionTagPacket.create(11, 1.0);
                    }
                }
                if (!CapabilityUtils.isWearingBackpack((Player)player)) break block11;
                while (ModClientEventHandler.OPEN_BACKPACK.m_90859_()) {
                    ServerboundActionTagPacket.create(1, new Object[0]);
                }
                while (ModClientEventHandler.ABILITY.m_90859_()) {
                    if (!BackpackAbilities.ALLOWED_ABILITIES.contains(CapabilityUtils.getWearingBackpack((Player)player).m_41720_())) continue;
                    boolean ability = CapabilityUtils.getBackpackWrapperArtificial((Player)player).isAbilityEnabled();
                    ServerboundActionTagPacket.create(14, !ability);
                    player.m_5661_((Component)Component.m_237115_((String)(ability ? "screen.travelersbackpack.ability_disabled" : "screen.travelersbackpack.ability_enabled")), true);
                }
                if (!((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue()) break block12;
                heldItem = player.m_21205_();
                while (ModClientEventHandler.SWAP_TOOL.m_90859_()) {
                    if (heldItem.m_41619_() || !((Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get()).booleanValue() || !ToolSlotItemHandler.isValid(heldItem)) continue;
                    ServerboundActionTagPacket.create(6, 1.0);
                }
                break block12;
            }
            block5: while (ModClientEventHandler.OPEN_BACKPACK.m_90859_()) {
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                    if (!(stack.m_41720_() instanceof TravelersBackpackItem)) continue;
                    ServerboundActionTagPacket.create(2, i, false);
                    continue block5;
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterClientCommandsEvent event) {
        new BackpackIconCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void mouseWheelDetect(InputEvent.MouseScrollingEvent event) {
        ItemStack heldItem;
        LocalPlayer player;
        Minecraft mc = Minecraft.m_91087_();
        double scrollDelta = event.getScrollDelta();
        if (!((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue() && scrollDelta != 0.0 && (player = mc.f_91074_) != null && player.m_6084_() && ModClientEventHandler.SWAP_TOOL.m_90857_() && !(heldItem = player.m_21205_()).m_41619_()) {
            if (heldItem.m_41720_() instanceof HoseItem && NbtHelper.has(heldItem, "HoseModes")) {
                ServerboundActionTagPacket.create(11, scrollDelta);
                event.setCanceled(true);
            }
            if (CapabilityUtils.isWearingBackpack((Player)player) && ((Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get()).booleanValue() && ToolSlotItemHandler.isValid(heldItem)) {
                ServerboundActionTagPacket.create(6, scrollDelta);
                event.setCanceled(true);
            }
        }
    }
}

