/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidTankItemWrapper
implements IFluidHandlerItem {
    private final ItemStack backpack;
    private final TanksUpgrade upgrade;

    public FluidTankItemWrapper(ItemStack backpack, TanksUpgrade upgrade) {
        this.backpack = backpack;
        this.upgrade = upgrade;
    }

    public ItemStack getContainer() {
        return this.backpack;
    }

    public int getTanks() {
        return 2;
    }

    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return this.upgrade.getLeftTank().getFluid();
        }
        return this.upgrade.getRightTank().getFluid();
    }

    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.upgrade.getLeftTank().getCapacity();
        }
        return this.upgrade.getRightTank().getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        if (tank == 0) {
            return this.upgrade.getLeftTank().isFluidValid(stack);
        }
        return this.upgrade.getRightTank().isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getContainer().m_41613_() > 1) {
            return 0;
        }
        if (this.upgrade.getLeftTank().fill(resource, IFluidHandler.FluidAction.SIMULATE) > 0) {
            return this.upgrade.getLeftTank().fill(resource, action);
        }
        return this.upgrade.getRightTank().fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getContainer().m_41613_() > 1) {
            return FluidStack.EMPTY;
        }
        if (!this.upgrade.getLeftTank().drain(resource, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            return this.upgrade.getLeftTank().drain(resource, action);
        }
        return this.upgrade.getRightTank().drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.getContainer().m_41613_() > 1) {
            return FluidStack.EMPTY;
        }
        if (!this.upgrade.getLeftTank().drain(maxDrain, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            return this.upgrade.getLeftTank().drain(maxDrain, action);
        }
        return this.upgrade.getRightTank().drain(maxDrain, action);
    }
}

