/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilter;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class FilterUpgradeBase<T, F extends FilterSettingsBase>
extends UpgradeBase<T>
implements IFilter,
IFilterSlots {
    protected final ItemStackHandler filter;
    protected final List<Runnable> changeListeners = new ArrayList<Runnable>();
    private final int filterSlotCount;
    private final int slotsInRow;
    private final F filterSettings;

    public FilterUpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize, int filterSlotCount, int slotsInRow, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, openTabSize);
        this.filterSlotCount = filterSlotCount;
        this.slotsInRow = slotsInRow;
        this.filterSettings = this.createFilterSettings(manager, filter, filterTags);
        this.filter = this.createFilter(filter, filterSlotCount);
    }

    public F getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public List<Integer> getFilter() {
        List<Integer> filter = NbtHelper.getOrDefault(this.getDataHolderStack(), "FilterSettings", List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
        if (filter.size() != 3) {
            filter = List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1));
        }
        return filter;
    }

    @Override
    public int getFilterSlotCount() {
        return this.filterSlotCount;
    }

    @Override
    public int getSlotsInRow() {
        return this.slotsInRow;
    }

    @Override
    public void updateSettings() {
        ((FilterSettingsBase)this.getFilterSettings()).updateSettings(this.getFilter());
    }

    public boolean hasTagSelector() {
        return true;
    }

    public boolean isTagSelector() {
        if (!this.hasTagSelector()) {
            return false;
        }
        return this.getFilter().get(1) == 2;
    }

    public ItemStack getFirstFilterStack() {
        return this.filter.getStackInSlot(0);
    }

    public void addChangeListener(Runnable listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        if (this.isTagSelector()) {
            slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, 0, x + 64, y + 23, 1){

                @Override
                public boolean m_5857_(ItemStack pStack) {
                    return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                }
            });
        } else {
            for (int i = 0; i < this.getRows(); ++i) {
                for (int j = 0; j < this.getSlotsInRow(i); ++j) {
                    slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, j + i * this.getSlotsInRow(), x + 7 + j * 18, y + 44 + i * 18, this.getFilterSlotCount()){

                        @Override
                        public boolean m_5857_(ItemStack pStack) {
                            return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                        }
                    });
                }
            }
        }
        return slots;
    }

    @Override
    public Point getTabSize() {
        Point tabSize = super.getTabSize();
        if (this.isTabOpened()) {
            if (this.isTagSelector()) {
                return new Point(87, 103);
            }
            int x = this.openTabSize.x();
            if (this.getSlotsInRow() > 3) {
                x += (this.getSlotsInRow() - 3) * 18;
            }
            return new Point(x, this.openTabSize.y() + 18 * this.getRows());
        }
        return tabSize;
    }

    public abstract F createFilterSettings(UpgradeManager var1, NonNullList<ItemStack> var2, List<String> var3);

    protected abstract FilterHandler createFilter(NonNullList<ItemStack> var1, int var2);
}

