/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class NbtHelper {
    public static boolean isInteger(String key) {
        return key.equals("StorageSlots") || key.equals("UpgradeSlots") || key.equals("ToolSlots") || key.equals("Tier") || key.equals("Cooldown") || key.equals("SortType") || key.equals("SleepingBagColor") || key.equals("UpgradeTickInterval") || key.equals("Color") || key.equals("CookingTotalTime") || key.equals("BurnTotalTime");
    }

    public static boolean isBoolean(String key) {
        return key.equals("TabOpen") || key.equals("UpgradeEnabled") || key.equals("ShiftClickToBackpack") || key.equals("ShowToolSlots") || key.equals("ShowMoreButtons") || key.equals("IsPlaying") || key.equals("AbilityEnabled") || key.equals("IsVisible");
    }

    public static boolean isLong(String key) {
        return key.equals("BurnFinishTime") || key.equals("CookingFinishTime");
    }

    public static void set(ItemStack stack, String key, Object value) {
        if (NbtHelper.isInteger(key)) {
            stack.m_41784_().m_128405_(key, ((Integer)value).intValue());
            return;
        }
        if (NbtHelper.isBoolean(key)) {
            stack.m_41784_().m_128379_(key, ((Boolean)value).booleanValue());
            return;
        }
        if (NbtHelper.isLong(key)) {
            stack.m_41784_().m_128356_(key, ((Long)value).longValue());
            return;
        }
        switch (key) {
            case "Inventory": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeHandler((ItemStackHandler)value));
                break;
            }
            case "Upgrades": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeHandler((ItemStackHandler)value));
                break;
            }
            case "ToolsInventory": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeHandler((ItemStackHandler)value));
                break;
            }
            case "StarterUpgrades": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeStarterUpgrades((List)value));
                break;
            }
            case "RenderInfo": {
                stack.m_41784_().m_128365_(key, (Tag)((RenderInfo)value).compoundTag());
                break;
            }
            case "Fluids": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeFluids((Fluids)value));
                break;
            }
            case "FilterSettings": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeIntList((List)value, key));
                break;
            }
            case "FilterTags": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeStringList((List)value, key));
                break;
            }
            case "UnsortableSlots": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeIntList((List)value, key));
                break;
            }
            case "MemorySlots": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeMemorySlots((List)value));
                break;
            }
            case "HoseModes": {
                stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeIntList((List)value, key));
                break;
            }
            default: {
                stack.m_41784_().m_128365_(key, (Tag)((CompoundTag)value));
            }
        }
    }

    public static <T> T getOrDefault(ItemStack stack, String key, T defaultValue) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(key)) {
            if (NbtHelper.isInteger(key)) {
                return (T)Integer.valueOf(stack.m_41783_().m_128451_(key));
            }
            if (NbtHelper.isBoolean(key)) {
                return (T)Boolean.valueOf(stack.m_41783_().m_128471_(key));
            }
            if (NbtHelper.isLong(key)) {
                return (T)Long.valueOf(stack.m_41783_().m_128454_(key));
            }
            if (stack.m_41783_().m_128441_(key)) {
                switch (key) {
                    case "Inventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "Upgrades": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "ToolsInventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "StarterUpgrades": {
                        return (T)NbtHelper.deserializeStarterUpgrades(stack.m_41783_().m_128469_(key));
                    }
                    case "RenderInfo": {
                        return (T)new RenderInfo(stack.m_41783_().m_128469_(key));
                    }
                    case "Fluids": {
                        return (T)new Fluids(NbtHelper.deserializeLeftFluidStack(stack.m_41783_().m_128469_(key)), NbtHelper.deserializeRightFluidStack(stack.m_41783_().m_128469_(key)));
                    }
                    case "FilterSettings": {
                        return (T)NbtHelper.deserializeIntList(stack.m_41783_(), key);
                    }
                    case "FilterTags": {
                        return (T)NbtHelper.deserializeStringList(stack.m_41783_(), key);
                    }
                    case "UnsortableSlots": {
                        return (T)NbtHelper.deserializeIntList(stack.m_41783_(), key);
                    }
                    case "MemorySlots": {
                        return (T)NbtHelper.deserializeMemorySlots(stack.m_41783_());
                    }
                    case "HoseModes": {
                        return (T)NbtHelper.deserializeIntList(stack.m_41783_(), key);
                    }
                }
                return (T)stack.m_41783_().m_128469_(key);
            }
        }
        return defaultValue;
    }

    @Nullable
    public static <T> T get(ItemStack stack, String key) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(key)) {
            if (NbtHelper.isInteger(key)) {
                return (T)Integer.valueOf(stack.m_41783_().m_128451_(key));
            }
            if (NbtHelper.isBoolean(key)) {
                return (T)Boolean.valueOf(stack.m_41783_().m_128471_(key));
            }
            if (NbtHelper.isLong(key)) {
                return (T)Long.valueOf(stack.m_41783_().m_128454_(key));
            }
            if (stack.m_41783_().m_128441_(key)) {
                switch (key) {
                    case "Inventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "Upgrades": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "ToolsInventory": {
                        return (T)NbtHelper.deserializeHandler(stack, key);
                    }
                    case "StarterUpgrades": {
                        return (T)NbtHelper.deserializeStarterUpgrades(stack.m_41783_().m_128469_(key));
                    }
                    case "RenderInfo": {
                        return (T)new RenderInfo(stack.m_41783_().m_128469_(key));
                    }
                    case "Fluids": {
                        return (T)new Fluids(NbtHelper.deserializeLeftFluidStack(stack.m_41783_().m_128469_(key)), NbtHelper.deserializeRightFluidStack(stack.m_41783_().m_128469_(key)));
                    }
                    case "FilterSettings": {
                        return (T)NbtHelper.deserializeIntList(stack.m_41783_(), key);
                    }
                    case "FilterTags": {
                        return (T)NbtHelper.deserializeStringList(stack.m_41783_(), key);
                    }
                    case "UnsortableSlots": {
                        return (T)NbtHelper.deserializeIntList(stack.m_41783_(), key);
                    }
                    case "MemorySlots": {
                        return (T)NbtHelper.deserializeMemorySlots(stack.m_41783_());
                    }
                    case "HoseModes": {
                        return (T)NbtHelper.deserializeIntList(stack.m_41783_(), key);
                    }
                }
                return (T)stack.m_41783_().m_128469_(key);
            }
        }
        return null;
    }

    public static boolean has(ItemStack stack, String key) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128441_(key);
        }
        return false;
    }

    public static void remove(ItemStack stack, String key) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(key);
        }
    }

    public static CompoundTag serializeHandler(ItemStackHandler handler) {
        return NbtHelper.serializeNBT(handler);
    }

    public static CompoundTag serializeNBT(ItemStackHandler handler) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < handler.getSlots(); ++i) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            handler.getStackInSlot(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", nbtTagList.size());
        return nbt;
    }

    public static CompoundTag serializeStarterUpgrades(List<ItemStack> upgrades) {
        return NbtHelper.serializeList(upgrades);
    }

    public static List<ItemStack> deserializeStarterUpgrades(CompoundTag tag) {
        return NbtHelper.deserializeList(tag);
    }

    public static CompoundTag getHandlerNbt(ItemStack stack, String key) {
        return stack.m_41783_().m_128469_(key);
    }

    public static CompoundTag expandTag(ItemStack stack, String key, int defaultSize) {
        CompoundTag tag = NbtHelper.getHandlerNbt(stack, key);
        NonNullList stacks = NonNullList.m_122780_((int)defaultSize, (Object)ItemStack.f_41583_);
        ListTag tagList = tag.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        return NbtHelper.serializeHandler(new ItemStackHandler(stacks));
    }

    public static NonNullList<ItemStack> deserializeHandler(ItemStack stack, String key) {
        ListTag tagList = stack.m_41783_().m_128469_(key).m_128437_("Items", 10);
        int size = stack.m_41783_().m_128441_("Size") ? stack.m_41783_().m_128469_(key).m_128451_("Size") : tagList.size();
        NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        return stacks;
    }

    public static void update(ItemStack backpack, String key, int defaultSize, int slot, ItemStack stack) {
        if (backpack.m_41782_() && backpack.m_41783_().m_128441_(key)) {
            CompoundTag unboxed = backpack.m_41783_().m_128469_(key);
            ListTag itemsListed = unboxed.m_128437_("Items", 10);
            CompoundTag newItemTag = new CompoundTag();
            newItemTag.m_128405_("Slot", slot);
            stack.m_41739_(newItemTag);
            if (slot >= 0 && slot < itemsListed.size()) {
                itemsListed.set(slot, (Tag)newItemTag);
            }
        } else {
            ListTag nbtTagList = new ListTag();
            for (int i = 0; i < defaultSize; ++i) {
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                ItemStack.f_41583_.m_41777_().m_41739_(itemTag);
                nbtTagList.add((Object)itemTag);
            }
            CompoundTag newItemTag = new CompoundTag();
            newItemTag.m_128405_("Slot", slot);
            stack.m_41739_(newItemTag);
            if (slot >= 0 && slot < nbtTagList.size()) {
                nbtTagList.set(slot, (Tag)newItemTag);
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Items", (Tag)nbtTagList);
            nbt.m_128405_("Size", nbtTagList.size());
            backpack.m_41784_().m_128365_(key, (Tag)nbt);
        }
    }

    public static FluidStack deserializeLeftFluidStack(CompoundTag tag) {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("leftFluidStack"));
    }

    public static FluidStack deserializeRightFluidStack(CompoundTag tag) {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("rightFluidStack"));
    }

    public static CompoundTag serializeFluids(Fluids fluids) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("leftFluidStack", (Tag)fluids.leftFluidStack().writeToNBT(new CompoundTag()));
        tag.m_128365_("rightFluidStack", (Tag)fluids.rightFluidStack().writeToNBT(new CompoundTag()));
        return tag;
    }

    public static CompoundTag serializeList(List<ItemStack> stacks) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            stacks.get(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public static List<ItemStack> deserializeList(CompoundTag tag) {
        ListTag tagList = tag.m_128437_("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < tagList.size(); ++i) {
            stacks.add(ItemStack.m_41712_((CompoundTag)tagList.m_128728_(i)));
        }
        return stacks;
    }

    public static ListTag serializeIntList(List<Integer> ints, String key) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < ints.size(); ++i) {
            nbtTagList.add(i, (Tag)IntTag.m_128679_((int)ints.get(i)));
        }
        return nbtTagList;
    }

    public static List<Integer> deserializeIntList(CompoundTag tag, String key) {
        ListTag tagList = tag.m_128437_(key, 3);
        if (tagList.isEmpty()) {
            ListTag oldList = tag.m_128469_(key).m_128437_(key, 3);
            tag.m_128365_(key, (Tag)oldList);
            tagList = oldList;
        }
        ArrayList<Integer> filter = new ArrayList<Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            filter.add(tagList.m_128763_(i));
        }
        return filter;
    }

    public static ListTag serializeStringList(List<String> strings, String key) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < strings.size(); ++i) {
            nbtTagList.add(i, (Tag)StringTag.m_129297_((String)strings.get(i)));
        }
        return nbtTagList;
    }

    public static List<String> deserializeStringList(CompoundTag tag, String key) {
        ListTag tagList = tag.m_128437_(key, 8);
        ArrayList<String> filter = new ArrayList<String>();
        for (int i = 0; i < tagList.size(); ++i) {
            filter.add(tagList.m_128778_(i));
        }
        return filter;
    }

    public static ListTag serializeMemorySlots(List<Pair<Integer, Pair<ItemStack, Boolean>>> memorySlots) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < memorySlots.size(); ++i) {
            CompoundTag pairTag = new CompoundTag();
            pairTag.m_128405_("Slot", ((Integer)memorySlots.get(i).getFirst()).intValue());
            pairTag.m_128365_("Pair", (Tag)NbtHelper.serializeMemoryStack((Pair<ItemStack, Boolean>)((Pair)memorySlots.get(i).getSecond())));
            nbtTagList.add((Object)pairTag);
        }
        return nbtTagList;
    }

    public static CompoundTag serializeMemoryStack(Pair<ItemStack, Boolean> memoryStack) {
        CompoundTag pair = new CompoundTag();
        ((ItemStack)memoryStack.getFirst()).m_41739_(pair);
        pair.m_128379_("matchNbt", ((Boolean)memoryStack.getSecond()).booleanValue());
        return pair;
    }

    public static List<Pair<Integer, Pair<ItemStack, Boolean>>> deserializeMemorySlots(CompoundTag tag) {
        ListTag tagList = tag.m_128437_("MemorySlots", 10);
        if (tagList.isEmpty()) {
            ListTag oldList = tag.m_128469_("MemorySlots").m_128437_("MemorySlots", 10);
            tag.m_128365_("MemorySlots", (Tag)oldList);
            tagList = oldList;
        }
        ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag pairTag = tagList.m_128728_(i);
            int index = pairTag.m_128451_("Slot");
            Pair<ItemStack, Boolean> pair = NbtHelper.deserializeMemoryStack(pairTag.m_128469_("Pair"));
            memorySlots.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)index, pair));
        }
        return memorySlots;
    }

    public static Pair<ItemStack, Boolean> deserializeMemoryStack(CompoundTag tag) {
        return Pair.of((Object)ItemStack.m_41712_((CompoundTag)tag), (Object)tag.m_128471_("matchNbt"));
    }

    public static CompoundTag serializeMemorySlotsPacket(List<Pair<Integer, Boolean>> memorySlots) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < memorySlots.size(); ++i) {
            CompoundTag pairTag = new CompoundTag();
            pairTag.m_128405_("Slot", ((Integer)memorySlots.get(i).getFirst()).intValue());
            pairTag.m_128379_("matchNbt", ((Boolean)memorySlots.get(i).getSecond()).booleanValue());
            nbtTagList.add((Object)pairTag);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("MemorySlots", (Tag)nbtTagList);
        return tag;
    }

    public static List<Pair<Integer, Boolean>> deserializeMemorySlotsPacket(CompoundTag tag) {
        ListTag tagList = tag.m_128437_("MemorySlots", 10);
        ArrayList<Pair<Integer, Boolean>> memorySlots = new ArrayList<Pair<Integer, Boolean>>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag pairTag = tagList.m_128728_(i);
            int index = pairTag.m_128451_("Slot");
            boolean matchNbt = pairTag.m_128471_("matchNbt");
            memorySlots.add((Pair<Integer, Boolean>)Pair.of((Object)index, (Object)matchNbt));
        }
        return memorySlots;
    }
}

