/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SupporterBadgeWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.UnsortablesWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.VisibilityWidget;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BackpackSettingsScreen
extends AbstractBackpackScreen<BackpackSettingsMenu>
implements class_3936<BackpackSettingsMenu> {
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    public SupporterBadgeWidget supporterBadgeWidget;
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<Integer>();
    public List<Pair<Integer, Pair<class_1799, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<class_1799, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>();
    public boolean visibility;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, class_1661 inventory, class_2561 component) {
        super(backpackSettingsMenu, inventory, backpackSettingsMenu.getWrapper().getBackpackScreenTitle());
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.lastUnsortableSlots = new ArrayList<Integer>(this.wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<Integer>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>(this.wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>(this.lastMemorySlots);
        this.visibility = (Boolean)this.wrapper.getBackpackStack().method_58695(ModDataComponents.IS_VISIBLE, (Object)true);
        this.field_25267 = 8;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    protected void method_25426() {
        super.method_25426();
        this.initWidgets();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.isScrollable = false;
        this.recalculate();
        this.method_25426();
        ((BackpackSettingsMenu)this.method_17577()).updateSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    public void recalculate() {
        boolean wideTexture;
        this.method_37067();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.field_2776 = 0;
        this.field_2800 = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.field_2792 = wideTexture ? 212 : 176;
        this.field_2779 = 17 + this.slotsHeight + playerInventoryHeight;
        this.updateDimensions();
        this.field_25270 = 20 + this.visibleRows * 18;
        this.field_25269 = 8;
        this.field_25267 = 8;
        this.field_25268 = 6;
        if (wideTexture) {
            this.field_25269 += 18;
        }
        if (((BackpackSettingsMenu)this.field_2797).method_7611((int)0).field_7872 >= 0) {
            this.slotYPos = ((BackpackSettingsMenu)this.field_2797).method_7611((int)0).field_7872;
        }
    }

    @Override
    public void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        this.renderInventoryBackground(guiGraphics, x, y, wideTexture ? BackpackScreen.BACKGROUND_11 : BackpackScreen.BACKGROUND_9, this.field_2792, this.slotsHeight);
        int slotsXOffset = 7;
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 17, this.slotCount);
        this.renderLockedBackpackSlot(guiGraphics);
    }

    public void initWidgets() {
        if (this.isScrollable) {
            int scrollXPos = this.field_2776 + 7;
            this.scroll = new InventoryScroll(this, class_310.method_1551(), 4, this.visibleRows * 18, this.field_2800 + 17, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.method_37063((class_364)this.scroll);
        }
        this.settingsWidget = new SettingsWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4), true);
        this.method_37063(this.settingsWidget);
        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1));
        this.method_37063(this.unsortablesWidget);
        this.memoryWidget = new MemoryWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1), false);
        this.method_37063(this.memoryWidget);
        if (this.getWrapper().getScreenID() == 2) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1 + 24 + 1));
            this.method_37063(this.visibilityWidget);
            if (this.getWrapper().isOwner(this.getScreenPlayer()) && Supporters.SUPPORTERS_REFERENCE.contains(this.getScreenPlayer().method_7334().name())) {
                this.supporterBadgeWidget = new SupporterBadgeWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1 + 24 + 1 + 24 + 1));
                this.method_37063(this.supporterBadgeWidget);
            }
        }
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.method_25396().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<class_364> widgets = this.method_25396().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for (int i = 0; i < widgets.size(); ++i) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = (SettingsWidgetBase)widgets.get(i);
            if (i > 0) {
                previousWidget = (SettingsWidgetBase)widgets.get(i - 1);
            }
            if (previousWidget == null) continue;
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    @Override
    public void drawUnsortableSlots(class_332 guiGraphics) {
        if (this.unsortablesWidget.isTabOpened()) {
            if (!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25.0f, 55.0f, 16, 16, 256, 256));
            }
        } else if (!this.lastUnsortableSlots.isEmpty()) {
            this.lastUnsortableSlots.forEach(i -> guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25.0f, 55.0f, 16, 16, 256, 256));
        }
    }

    @Override
    public void drawMemorySlots(class_332 guiGraphics) {
        if (this.memoryWidget.isTabOpened()) {
            if (!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, 25.0f, 73.0f, 16, 16, 256, 256);
                    } else {
                        guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, 25.0f, 91.0f, 16, 16, 256, 256);
                    }
                    if (((BackpackSettingsMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                        class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                        guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                        guiGraphics.method_25294(this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                    }
                });
            }
        } else if (!this.lastMemorySlots.isEmpty()) {
            this.lastMemorySlots.forEach(pair -> {
                if (((BackpackSettingsMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                    class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                    guiGraphics.method_25294(this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 type) {
        if (this.selectSlots(slot, button)) {
            return;
        }
        super.method_2383(slot, slotId, button, type);
    }

    @Override
    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        class_1735 slot = this.field_2787;
        if (this.selectSlots(slot, event.method_74245())) {
            return true;
        }
        return super.method_25403(event, dragX, dragY);
    }

    public boolean selectSlots(class_1735 slot, int button) {
        if (slot != null && slot.field_7874 >= 0 && slot.field_7874 < this.wrapper.getStorage().getSlots()) {
            if (this.unsortablesWidget.isTabOpened()) {
                if (button == 0 && !this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.add(slot.field_7874);
                    return true;
                }
                if (button == 1 && this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.remove((Object)slot.field_7874);
                    return true;
                }
            }
            if (this.memoryWidget.isTabOpened()) {
                if (button == 0 && !this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    if (slot.method_7677().method_7960()) {
                        return false;
                    }
                    this.memorySlots.add((Pair<Integer, Pair<class_1799, Boolean>>)Pair.of((Object)slot.field_7874, (Object)Pair.of((Object)slot.method_7677(), (Object)this.memoryWidget.matchComponents)));
                    return true;
                }
                if (button == 1 && this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot.field_7874);
                    return true;
                }
            }
        }
        return false;
    }

    public void method_25419() {
        this.sendDataToServer();
        super.method_25419();
    }

    public boolean method_25404(class_11908 event) {
        if (KeybindHandler.OPEN_BACKPACK.method_1417(event)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if (playerEntity != null) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(event);
    }
}

