/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.BackpackEffect;
import com.tiviacz.travelersbackpack.config.Cooldown;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.CooldownHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final class_1322 NETHERITE_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"netherite_backpack_armor"), 4.0, class_1322.class_1323.field_6328);
    public final class_1322 DIAMOND_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"diamond_backpack_armor"), 3.0, class_1322.class_1323.field_6328);
    public final class_1322 IRON_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"iron_backpack_armor"), 2.0, class_1322.class_1323.field_6328);
    public final class_1322 GOLD_ARMOR_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"gold_backpack_armor"), 2.0, class_1322.class_1323.field_6328);
    public final class_1322 ENDERMAN_REACH_DISTANCE_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"enderman_backpack_reach"), 1.0, class_1322.class_1323.field_6328);
    public final class_1322 WARDEN_MAX_HEALTH_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"warden_backpack_max_health"), 4.0, class_1322.class_1323.field_6328);
    public final class_1322 FOX_MOVEMENT_SPEED_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"fox_movement_speed"), 0.1, class_1322.class_1323.field_6331);
    public final class_1322 LUCK_MODIFIER = new class_1322(class_2960.method_60655((String)"travelersbackpack", (String)"emerald_backpack_luck"), 1.0, class_1322.class_1323.field_6328);
    private final class_4051 ocelotAbilityTargeting = class_4051.method_36625().method_18418(64.0);
    public static final List<class_1792> ALLOWED_ABILITIES = new ArrayList<class_1792>();
    public static final Multimap<class_1792, BackpackEffect> BACKPACK_EFFECTS = ArrayListMultimap.create();
    public static final Map<class_1792, Cooldown> COOLDOWNS = new HashMap<class_1792, Cooldown>();
    public static List<class_1792> ITEM_ABILITIES_LIST = new ArrayList<TravelersBackpackItem>(List.of(ModItems.NETHERITE_TRAVELERS_BACKPACK, ModItems.DIAMOND_TRAVELERS_BACKPACK, ModItems.GOLD_TRAVELERS_BACKPACK, ModItems.EMERALD_TRAVELERS_BACKPACK, ModItems.IRON_TRAVELERS_BACKPACK, ModItems.LAPIS_TRAVELERS_BACKPACK, ModItems.QUARTZ_TRAVELERS_BACKPACK, ModItems.CAKE_TRAVELERS_BACKPACK, ModItems.CACTUS_TRAVELERS_BACKPACK, ModItems.HAY_TRAVELERS_BACKPACK, ModItems.PUMPKIN_TRAVELERS_BACKPACK, ModItems.CREEPER_TRAVELERS_BACKPACK, ModItems.DRAGON_TRAVELERS_BACKPACK, ModItems.ENDERMAN_TRAVELERS_BACKPACK, ModItems.BLAZE_TRAVELERS_BACKPACK, ModItems.GHAST_TRAVELERS_BACKPACK, ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK, ModItems.SPIDER_TRAVELERS_BACKPACK, ModItems.WITHER_TRAVELERS_BACKPACK, ModItems.WARDEN_TRAVELERS_BACKPACK, ModItems.BAT_TRAVELERS_BACKPACK, ModItems.BEE_TRAVELERS_BACKPACK, ModItems.OCELOT_TRAVELERS_BACKPACK, ModItems.COW_TRAVELERS_BACKPACK, ModItems.CHICKEN_TRAVELERS_BACKPACK, ModItems.SQUID_TRAVELERS_BACKPACK, ModItems.FOX_TRAVELERS_BACKPACK));
    public static List<class_1792> ITEM_ABILITIES_REMOVAL_LIST = new ArrayList<TravelersBackpackItem>(List.of(ModItems.NETHERITE_TRAVELERS_BACKPACK, ModItems.DIAMOND_TRAVELERS_BACKPACK, ModItems.GOLD_TRAVELERS_BACKPACK, ModItems.IRON_TRAVELERS_BACKPACK, ModItems.EMERALD_TRAVELERS_BACKPACK, ModItems.ENDERMAN_TRAVELERS_BACKPACK, ModItems.WARDEN_TRAVELERS_BACKPACK, ModItems.FOX_TRAVELERS_BACKPACK));
    public static List<class_1792> BLOCK_ABILITIES_LIST = new ArrayList<TravelersBackpackItem>(List.of(ModItems.REDSTONE_TRAVELERS_BACKPACK, ModItems.BOOKSHELF_TRAVELERS_BACKPACK, ModItems.SPONGE_TRAVELERS_BACKPACK, ModItems.CACTUS_TRAVELERS_BACKPACK, ModItems.MELON_TRAVELERS_BACKPACK));
    public static List<class_1792> CUSTOM_DESCRIPTIONS = new ArrayList<TravelersBackpackItem>(List.of(ModItems.LAPIS_TRAVELERS_BACKPACK, ModItems.REDSTONE_TRAVELERS_BACKPACK, ModItems.BOOKSHELF_TRAVELERS_BACKPACK, ModItems.SPONGE_TRAVELERS_BACKPACK, ModItems.CAKE_TRAVELERS_BACKPACK, ModItems.CACTUS_TRAVELERS_BACKPACK, ModItems.HAY_TRAVELERS_BACKPACK, ModItems.PUMPKIN_TRAVELERS_BACKPACK, ModItems.MELON_TRAVELERS_BACKPACK, ModItems.CREEPER_TRAVELERS_BACKPACK, ModItems.ENDERMAN_TRAVELERS_BACKPACK, ModItems.BLAZE_TRAVELERS_BACKPACK, ModItems.GHAST_TRAVELERS_BACKPACK, ModItems.SPIDER_TRAVELERS_BACKPACK, ModItems.WITHER_TRAVELERS_BACKPACK, ModItems.WARDEN_TRAVELERS_BACKPACK, ModItems.BEE_TRAVELERS_BACKPACK, ModItems.OCELOT_TRAVELERS_BACKPACK, ModItems.COW_TRAVELERS_BACKPACK, ModItems.CHICKEN_TRAVELERS_BACKPACK));

    public boolean abilityTick(@Nullable class_1799 backpack, @Nullable class_1657 player) {
        boolean tickCooldown = false;
        if (backpack != null) {
            class_1792 backpackItem = backpack.method_7909();
            boolean effectHasCooldown = false;
            if (BackpackAbilities.getBackpackEffects().containsKey((Object)backpack.method_7909())) {
                if (BackpackAbilities.getCooldowns().containsKey(backpack.method_7909())) {
                    effectHasCooldown = true;
                }
                if (!effectHasCooldown) {
                    Collection backpackEffects = BackpackAbilities.getBackpackEffects().get((Object)backpackItem);
                    for (BackpackEffect backpackEffect : backpackEffects) {
                        if (backpack.method_7909() == ModItems.SQUID_TRAVELERS_BACKPACK.method_8389() && backpackEffect.effect() == class_1294.field_5925 && !player.method_5799()) continue;
                        this.addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                    }
                } else {
                    if (!BackpackAbilities.hasCooldown(backpack)) {
                        Collection backpackEffects = BackpackAbilities.getBackpackEffects().get((Object)backpackItem);
                        for (BackpackEffect backpackEffect : backpackEffects) {
                            this.addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                        }
                        BackpackAbilities.setCooldown(ComponentUtils.getBackpackWrapperArtificial(player), backpackItem);
                    }
                    tickCooldown = true;
                }
            }
            if (backpackItem == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.NETHERITE_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.DIAMOND_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.GOLD_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.GOLD_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.EMERALD_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23726, this.LUCK_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.IRON_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23724, this.IRON_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_47758, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23716, this.WARDEN_MAX_HEALTH_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.FOX_TRAVELERS_BACKPACK) {
                this.attributeAbility(player, false, (class_6880<class_1320>)class_5134.field_23719, this.FOX_MOVEMENT_SPEED_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.CAKE_TRAVELERS_BACKPACK) {
                this.cakeAbility(backpack, player);
                return true;
            }
            if (backpackItem == ModItems.CACTUS_TRAVELERS_BACKPACK) {
                this.cactusAbilityEquipped(player, backpack);
                return false;
            }
            if (backpackItem == ModItems.CHICKEN_TRAVELERS_BACKPACK) {
                this.chickenAbility(backpack, player, false);
                return true;
            }
            if (backpackItem == ModItems.CREEPER_TRAVELERS_BACKPACK) {
                return true;
            }
            if (backpackItem == ModItems.BLAZE_TRAVELERS_BACKPACK) {
                this.blazeAbility(player);
                return false;
            }
            if (backpackItem == ModItems.SPIDER_TRAVELERS_BACKPACK) {
                this.spiderAbility(player);
                return false;
            }
            if (backpackItem == ModItems.OCELOT_TRAVELERS_BACKPACK) {
                this.ocelotAbility(player);
                return false;
            }
            if (backpackItem == ModItems.COW_TRAVELERS_BACKPACK) {
                this.cowAbility(backpack, player);
                return true;
            }
            if (backpackItem == ModItems.WITHER_TRAVELERS_BACKPACK) {
                BackpackAbilities.witherAbilityTick(player);
                return false;
            }
        }
        return tickCooldown;
    }

    public boolean abilityTickBlock(@Nullable BackpackBlockEntity blockEntity) {
        class_1792 backpackItem;
        if (blockEntity.getWrapper() != null && (backpackItem = blockEntity.getWrapper().getBackpackStack().method_7909()) == ModItems.CACTUS_TRAVELERS_BACKPACK) {
            this.cactusAbilityBlockEntity(blockEntity.getWrapper(), blockEntity);
            return false;
        }
        return false;
    }

    public void abilityRemoval(@Nullable class_1799 stack, @Nullable class_1657 player) {
        if (stack.method_7909() == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.NETHERITE_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.DIAMOND_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.IRON_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.IRON_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.GOLD_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.GOLD_ARMOR_MODIFIER);
        }
        if (stack.method_7909() == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_47758, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        }
        if (stack.method_7909() == ModItems.WARDEN_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23716, this.WARDEN_MAX_HEALTH_MODIFIER);
        }
        if (stack.method_7909() == ModItems.EMERALD_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23726, this.LUCK_MODIFIER);
        }
        if (stack.method_7909() == ModItems.FOX_TRAVELERS_BACKPACK) {
            this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23719, this.FOX_MOVEMENT_SPEED_MODIFIER);
        }
    }

    public void animateTick(BackpackBlockEntity backpackBlockEntity, class_2680 stateIn, class_1937 level, class_2338 pos, class_5819 rand) {
        if (backpackBlockEntity.getWrapper() != null && backpackBlockEntity.getWrapper().isAbilityEnabled()) {
            class_2248 block = stateIn.method_26204();
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK) {
                this.bookshelfAbility(null, backpackBlockEntity);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
                this.spongeAbility(backpackBlockEntity);
            }
        }
    }

    public Multimap<class_6880<class_1320>, class_1322> getAttributeAbilityMultimap(class_1799 backpack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (backpack.method_7909() == ModItems.NETHERITE_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_23724, (Object)this.NETHERITE_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.method_7909() == ModItems.DIAMOND_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_23724, (Object)this.DIAMOND_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.method_7909() == ModItems.GOLD_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_23724, (Object)this.GOLD_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.method_7909() == ModItems.IRON_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_23724, (Object)this.IRON_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.method_7909() == ModItems.ENDERMAN_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_47758, (Object)this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            return multimap;
        }
        if (backpack.method_7909() == ModItems.WARDEN_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_23716, (Object)this.WARDEN_MAX_HEALTH_MODIFIER);
            return multimap;
        }
        if (backpack.method_7909() == ModItems.FOX_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_23719, (Object)this.FOX_MOVEMENT_SPEED_MODIFIER);
            return multimap;
        }
        if (backpack.method_7909() == ModItems.EMERALD_TRAVELERS_BACKPACK) {
            multimap.put((Object)class_5134.field_23726, (Object)this.LUCK_MODIFIER);
            return multimap;
        }
        return multimap;
    }

    public void attributeAbility(class_1657 player, boolean isRemoval, class_6880<class_1320> attribute, class_1322 modifier) {
        class_1324 armor = player.method_5996(attribute);
        if (isRemoval && armor != null && armor.method_6196(modifier.comp_2447())) {
            armor.method_6200(modifier.comp_2447());
        }
        if (!isRemoval && armor != null && !armor.method_6196(modifier.comp_2447())) {
            armor.method_26837(modifier);
        }
    }

    public void armorAbilityRemovals(class_1657 player) {
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.NETHERITE_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.DIAMOND_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.IRON_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23724, this.GOLD_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_47758, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23716, this.WARDEN_MAX_HEALTH_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23719, this.FOX_MOVEMENT_SPEED_MODIFIER);
        this.attributeAbility(player, true, (class_6880<class_1320>)class_5134.field_23726, this.LUCK_MODIFIER);
    }

    public int lapisAbility(class_1657 player) {
        float random;
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.LAPIS_TRAVELERS_BACKPACK) && (random = player.method_59922().method_43057()) <= 0.15f) {
            if (random <= 0.025f) {
                BackpackAbilities.sendParticlesPacket((class_2394)class_2398.field_28479, player, 2);
            }
            return 2;
        }
        return 1;
    }

    public void bookshelfAbility(@Nullable class_1657 player, @Nullable BackpackBlockEntity backpackBlockEntity) {
        class_2338 enchanting = BackpackDeathHelper.findBlock3D(backpackBlockEntity.method_10997(), backpackBlockEntity.method_11016().method_10263(), backpackBlockEntity.method_11016().method_10264(), backpackBlockEntity.method_11016().method_10260(), class_2246.field_10485, 2, 2);
        if (enchanting != null) {
            if (!backpackBlockEntity.method_10997().method_22347(new class_2338((enchanting.method_10263() - backpackBlockEntity.method_11016().method_10263()) / 2 + backpackBlockEntity.method_11016().method_10263(), enchanting.method_10264(), (enchanting.method_10260() - backpackBlockEntity.method_11016().method_10260()) / 2 + backpackBlockEntity.method_11016().method_10260()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                backpackBlockEntity.method_10997().method_8406((class_2394)class_2398.field_11215, (double)enchanting.method_10263() + 0.5, (double)enchanting.method_10264() + 2.0, (double)enchanting.method_10260() + 0.5, (double)((float)(backpackBlockEntity.method_11016().method_10263() - enchanting.method_10263()) + backpackBlockEntity.method_10997().field_9229.method_43057()) - 0.5, (double)((float)(backpackBlockEntity.method_11016().method_10264() - enchanting.method_10264()) - backpackBlockEntity.method_10997().field_9229.method_43057() - 1.0f), (double)((float)(backpackBlockEntity.method_11016().method_10260() - enchanting.method_10260()) + backpackBlockEntity.method_10997().field_9229.method_43057()) - 0.5);
            }
        }
    }

    public void spongeAbility(BackpackBlockEntity backpackBlockEntity) {
        TanksUpgrade tanksUpgrade;
        if (backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent() && !(tanksUpgrade = backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get()).getLeftTank().isEmpty() && !tanksUpgrade.getRightTank().isEmpty() && tanksUpgrade.getLeftTank().getFluid().fluidVariant().getFluid().method_15780((class_3611)class_3612.field_15910) && tanksUpgrade.getRightTank().getFluid().fluidVariant().getFluid().method_15780((class_3611)class_3612.field_15910) && tanksUpgrade.getLeftTank().getFluidAmount() == tanksUpgrade.getLeftTank().getCapacity() && tanksUpgrade.getRightTank().getFluidAmount() == tanksUpgrade.getRightTank().getCapacity()) {
            float f = backpackBlockEntity.method_10997().field_9229.method_43057() * (float)Math.PI * 2.0f;
            float f1 = backpackBlockEntity.method_10997().field_9229.method_43057() * 0.5f + 0.5f;
            float f2 = class_3532.method_15374((float)f) * 0.5f * f1;
            float f3 = class_3532.method_15362((float)f) * 0.5f * f1;
            backpackBlockEntity.method_10997().method_8406((class_2394)class_2398.field_11202, (double)((float)backpackBlockEntity.method_11016().method_10263() + f2 + 0.5f), (double)((float)backpackBlockEntity.method_11016().method_10264() + backpackBlockEntity.method_10997().field_9229.method_43057()), (double)((float)backpackBlockEntity.method_11016().method_10260() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(backpackBlockEntity.method_10997().field_9229.method_43048(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void cakeAbility(class_1799 backpack, class_1657 player) {
        if (!BackpackAbilities.hasCooldown(backpack)) {
            player.method_7344().method_7585(20, 0.1f);
            player.method_6092(new class_1293(class_1294.field_5924, 200));
            player.method_73183().method_8396(null, player.method_24515(), (class_3414)class_3417.field_20614.comp_349(), class_3419.field_15256, 0.6f, (player.method_73183().field_9229.method_43057() - player.method_73183().field_9229.method_43057()) * 0.3f + 1.0f);
            class_1937 class_19372 = player.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 server = (class_3218)class_19372;
                for (int i = 0; i < 3; ++i) {
                    float f = server.field_9229.method_43057() * (float)Math.PI * 2.0f;
                    float f1 = server.field_9229.method_43057() * 0.5f + 0.5f;
                    float f2 = class_3532.method_15374((float)f) * 0.5f * f1;
                    float f3 = class_3532.method_15362((float)f) * 0.5f * f1;
                    server.method_65096((class_2394)class_2398.field_11201, player.method_73189().field_1352 + (double)f2, player.method_5829().field_1322 + (double)player.method_73183().field_9229.method_43057() + 0.5, player.method_73189().field_1350 + (double)f3, 3, (double)((float)Math.pow(2.0, (double)(player.method_73183().field_9229.method_43048(169) - 12) / 12.0)) / 24.0, -1.0, 0.0, 0.0);
                }
            }
            if (BackpackAbilities.getCooldowns().containsKey(backpack.method_7909())) {
                Cooldown config = BackpackAbilities.getCooldowns().get(backpack.method_7909());
                backpack.method_57379(ModDataComponents.COOLDOWN, (Object)CooldownHelper.createCooldown(config.minCooldown(), config.maxCooldown()));
            }
        }
    }

    public void chickenAbility(class_1799 backpack, class_1657 player, boolean firstSwitch) {
        if (firstSwitch && !player.method_73183().method_8608() && !BackpackAbilities.hasCooldown(backpack)) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
            BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().method_7909());
            return;
        }
        if (!BackpackAbilities.hasCooldown(backpack)) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
            player.method_73183().method_8396(null, player.method_24515(), class_3417.field_15219, class_3419.field_15256, 1.0f, (player.method_73183().field_9229.method_43057() - player.method_73183().field_9229.method_43057()) * 0.3f + 1.0f);
            if (player.method_73183().method_8608()) {
                return;
            }
            class_1937 class_19372 = player.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                player.method_5706(serverLevel, (class_1935)class_1802.field_8803);
            }
            BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().method_7909());
        }
    }

    public void cactusAbilityEquipped(@Nullable class_1657 player, @Nullable class_1799 backpack) {
        BackpackWrapper wrapper;
        int gameTime = (int)player.method_73183().method_8510();
        int cooldown = (Integer)backpack.method_58695(ModDataComponents.COOLDOWN, (Object)0);
        if (cooldown >= 1000) {
            wrapper = ComponentUtils.getBackpackWrapper(player, ComponentUtils.UPGRADES_ONLY);
            if (wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidVariantWrapper water = new FluidVariantWrapper(FluidVariant.of((class_3611)class_3612.field_15910), 81000L);
                if (!player.method_73183().method_8608()) {
                    leftTank.fill(water, true);
                    rightTank.fill(water, true);
                }
                if (player.method_73183().method_8608()) {
                    return;
                }
                wrapper.setCooldown(0);
            } else {
                return;
            }
        }
        int drops = 0;
        if (gameTime % 100 == 0) {
            wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
            if (player.method_5799()) {
                drops += 50;
            }
            if (this.isUnderRain(player.method_24515(), player.method_73183())) {
                drops += 50;
            }
            int getCurrentDrops = wrapper.getCooldown();
            if (drops > 0) {
                if (player.method_73183().method_8608()) {
                    return;
                }
                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public void cactusAbilityBlockEntity(@Nullable BackpackWrapper wrapper, @Nullable BackpackBlockEntity blockEntity) {
        int cooldown = wrapper.getCooldown();
        if (cooldown >= 1000) {
            if (wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidVariantWrapper water = new FluidVariantWrapper(FluidVariant.of((class_3611)class_3612.field_15910), 81000L);
                leftTank.fill(water, true);
                rightTank.fill(water, true);
                wrapper.setCooldown(0);
            } else {
                return;
            }
        }
        int drops = 0;
        int gameTime = (int)blockEntity.method_10997().method_8510();
        if (gameTime % 100 == 0) {
            if (this.isUnderRain(blockEntity.method_11016(), blockEntity.method_10997())) {
                drops += 50;
            }
            int getCurrentDrops = wrapper.getCooldown();
            if (drops > 0) {
                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public static void melonAbility(BackpackBlockEntity backpackBlockEntity) {
        if (backpackBlockEntity.getWrapper().isAbilityEnabled() && backpackBlockEntity.getWrapper().getCooldown() <= 0) {
            class_2248.method_9577((class_1937)backpackBlockEntity.method_10997(), (class_2338)backpackBlockEntity.method_11016(), (class_1799)new class_1799((class_1935)class_1802.field_8497, backpackBlockEntity.method_10997().field_9229.method_43051(0, 3)));
            BackpackAbilities.setCooldown(backpackBlockEntity.getWrapper(), backpackBlockEntity.getWrapper().getBackpackStack().method_7909());
        }
    }

    public static void pumpkinAbility(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        boolean flag = ABILITIES.checkBackpack(player, (class_1792)ModItems.PUMPKIN_TRAVELERS_BACKPACK);
        if (flag) {
            cir.setReturnValue((Object)false);
        }
    }

    public static boolean creeperAbility(class_1657 player) {
        BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
        if (player.method_29504() && wrapper != null && wrapper.getBackpackStack().method_7909() == ModItems.CREEPER_TRAVELERS_BACKPACK && wrapper.isAbilityEnabled() && wrapper.getCooldown() <= 0) {
            player.method_6033(1.0f);
            player.method_6012();
            player.method_6092(new class_1293(class_1294.field_5924, 450, 1));
            player.method_6092(new class_1293(class_1294.field_5898, 100, 1));
            player.method_6092(new class_1293(class_1294.field_5918, 400, 0));
            player.method_73183().method_55117((class_1297)player, player.method_48923().method_48802(player), null, player.method_23322(0.5), player.method_23318(), player.method_23325(0.5), 3.0f, false, class_1937.class_7867.field_40888);
            player.method_73183().method_8396(null, player.method_24515(), class_3417.field_15057, class_3419.field_15256, 1.2f, 0.5f);
            if (!player.method_73183().method_8608()) {
                BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().method_7909());
            }
            return true;
        }
        return false;
    }

    public void blazeAbility(class_1657 player) {
        if (player.field_6017 >= 3.0) {
            for (int i = 0; i < 4; ++i) {
                player.method_73183().method_8406((class_2394)class_2398.field_11237, player.method_23322(0.5), player.method_23319(), player.method_23325(0.5), 0.0, 0.0, 0.0);
            }
            player.field_6017 = 0.0;
        }
    }

    public static void blazeAbility(class_3966 result, class_1677 fireball, CallbackInfo ci) {
        class_1657 player;
        class_1297 class_12972 = result.method_17782();
        if (class_12972 instanceof class_1657 && ABILITIES.checkBackpack(player = (class_1657)class_12972, (class_1792)ModItems.BLAZE_TRAVELERS_BACKPACK)) {
            player.method_73183().method_8396(null, player.method_24515(), (class_3414)class_3417.field_15150.comp_349(), class_3419.field_15248, 1.0f, 0.8f + player.method_73183().field_9229.method_43057() * 0.4f);
            BackpackAbilities.sendParticlesPacket((class_2394)class_2398.field_11240, player, 3);
            fireball.method_31472();
            ci.cancel();
        }
    }

    public static void ghastAbility(class_1571 ghast, class_1309 livingEntity, CallbackInfo ci) {
        class_1657 player;
        if (livingEntity instanceof class_1657 && ABILITIES.checkBackpack(player = (class_1657)livingEntity, (class_1792)ModItems.GHAST_TRAVELERS_BACKPACK) && ghast.method_49107() != player) {
            ci.cancel();
        }
    }

    public void spiderAbility(class_1657 player) {
        if (player.field_5976 && !player.method_52535()) {
            if (player.method_6128()) {
                player.method_66281();
            }
            if (!player.method_24828() && player.method_18276()) {
                player.method_18800(player.method_18798().field_1352, 0.0, player.method_18798().field_1350);
            } else {
                player.method_18800(player.method_18798().field_1352, 0.2, player.method_18798().field_1350);
                class_1937 level = player.method_73183();
                class_2680 state = level.method_8320(player.method_24515().method_10093(player.method_5735()));
                player.method_73183().method_8406((class_2394)new class_2388(class_2398.field_11217, state), player.method_23317() + (level.field_9229.method_43058() - 0.5) * (double)player.method_18377(class_4050.field_18076).comp_2185(), player.method_23318() + 0.1, player.method_23321() + (level.field_9229.method_43058() - 0.5) * (double)player.method_18377(class_4050.field_18076).comp_2185(), 0.0, 1.5, 0.0);
            }
        }
    }

    public static void witherAbilityTick(class_1657 player) {
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.WITHER_TRAVELERS_BACKPACK) && player.method_6059(class_1294.field_5920)) {
            player.method_6016(class_1294.field_5920);
        }
    }

    public static void witherAbility(class_1657 player, class_1297 target) {
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.WITHER_TRAVELERS_BACKPACK) && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            living.method_6092(new class_1293(class_1294.field_5920, 60, 1));
        }
    }

    public static void wardenAbility(class_1657 player, class_1297 target) {
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.WARDEN_TRAVELERS_BACKPACK) && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            living.method_6092(new class_1293(class_1294.field_5909, 40, 1));
        }
    }

    public static void beeAbility(class_1657 player, class_1297 target) {
        class_1282 damageSource;
        class_3218 serverLevel;
        boolean flag;
        class_1937 class_19372;
        if (ABILITIES.checkBackpack(player, (class_1792)ModItems.BEE_TRAVELERS_BACKPACK) && (class_19372 = player.method_73183()) instanceof class_3218 && (flag = target.method_64397(serverLevel = (class_3218)class_19372, damageSource = player.method_48923().method_48801((class_1309)player), 1.0f))) {
            class_1890.method_60107((class_3218)serverLevel, (class_1297)target, (class_1282)damageSource);
            if (target instanceof class_1309) {
                class_1309 living = (class_1309)target;
                living.method_21755(living.method_21753() + 1);
                living.method_37222(new class_1293(class_1294.field_5899, 80, 0), (class_1297)player);
            }
        }
    }

    public void ocelotAbility(class_1657 player) {
        class_3218 serverLevel;
        class_1937 class_19372 = player.method_73183();
        if (class_19372 instanceof class_3218 && (serverLevel = (class_3218)class_19372).method_64391(class_1588.class, this.ocelotAbilityTargeting, (class_1309)player, player.method_23317(), player.method_23318(), player.method_23321(), player.method_5829().method_1009(6.0, 2.0, 6.0)) != null) {
            this.addTimedMobEffect(player, (class_6880<class_1291>)class_1294.field_5904, 20, 30, 0, false, false, false);
        }
    }

    public void cowAbility(class_1799 stack, class_1657 player) {
        if (!player.method_6026().isEmpty() && !BackpackAbilities.hasCooldown(stack) && player.method_6026().stream().anyMatch(effect -> ((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272)) {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial(player);
            if (!player.method_73183().method_8608()) {
                player.method_73183().method_20290(2007, player.method_24515(), 0xFFFFFF);
                BackpackAbilities.setCooldown(wrapper, stack.method_7909());
            }
            player.method_73183().method_8396(null, player.method_24515(), class_3417.field_29543, class_3419.field_15248, 1.0f, player.method_59922().method_43057() * 0.1f + 0.9f);
            this.removeAllNegativeEffects(player.method_73183(), player);
        }
    }

    public boolean removeAllNegativeEffects(class_1937 level, class_1657 player) {
        if (level.method_8608()) {
            return false;
        }
        if (player.method_6026().isEmpty()) {
            return false;
        }
        List<class_1293> negativeEffects = player.method_6026().stream().filter(effect -> ((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272).toList();
        for (class_1293 instance : negativeEffects) {
            player.method_6016(instance.method_5579());
        }
        return true;
    }

    private boolean isUnderRain(class_2338 pos, class_1937 level) {
        return level.method_8311(pos) && level.method_8419();
    }

    public static boolean isAbilityEnabledInConfig(class_1799 stack) {
        return TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities && ALLOWED_ABILITIES.contains(stack.method_7909());
    }

    public boolean checkBackpack(class_1657 player, class_1792 item) {
        if (!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !ALLOWED_ABILITIES.contains(item)) {
            return false;
        }
        return ComponentUtils.isWearingBackpack(player) && ComponentUtils.getWearingBackpack(player).method_7909() == item && (Boolean)ComponentUtils.getWearingBackpack(player).method_58695(ModDataComponents.ABILITY_ENABLED, (Object)true) != false;
    }

    public void addTimedMobEffect(class_1657 player, class_6880<class_1291> effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if (!player.method_6059(effect)) {
            player.method_6092(new class_1293(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if (player.method_6059(effect) && player.method_6112(effect) != null && player.method_6112(effect).method_5584() <= minDuration) {
            player.method_6092(new class_1293(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        }
    }

    public static void sendParticlesPacket(class_2394 type, class_1657 player, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = player.method_73183().field_9229.method_43059() * 0.02;
            double d1 = player.method_73183().field_9229.method_43059() * 0.02;
            double d2 = player.method_73183().field_9229.method_43059() * 0.02;
            class_1937 class_19372 = player.method_73183();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 server = (class_3218)class_19372;
            server.method_65096(type, player.method_23322(1.0), player.method_23319() + 0.5, player.method_23325(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    public static boolean isOnList(List<class_1792> list, class_1799 stackToCheck) {
        return list.stream().anyMatch(s -> s == stackToCheck.method_7909());
    }

    public static boolean hasCooldown(class_1799 stack) {
        return (Integer)stack.method_58695(ModDataComponents.COOLDOWN, (Object)0) > 0;
    }

    public static void setCooldown(BackpackWrapper wrapper, class_1792 item) {
        if (BackpackAbilities.getCooldowns().containsKey(item)) {
            Cooldown cooldown = BackpackAbilities.getCooldowns().get(item);
            wrapper.setCooldown(CooldownHelper.createCooldown(cooldown.minCooldown(), cooldown.maxCooldown()));
        }
    }

    public static List<class_1792> getAllowedAbilities() {
        return ALLOWED_ABILITIES;
    }

    public static Map<class_1792, Cooldown> getCooldowns() {
        return COOLDOWNS;
    }

    public static Multimap<class_1792, BackpackEffect> getBackpackEffects() {
        return BACKPACK_EFFECTS;
    }
}

