/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.BackpackEffect;
import com.tiviacz.travelersbackpack.config.Cooldown;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfigData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class TravelersBackpackConfig {
    public static TravelersBackpackConfigData getConfig() {
        return (TravelersBackpackConfigData)AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).getConfig();
    }

    public static void saveConfig() {
        AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).save();
    }

    public static void register() {
        AutoConfig.register(TravelersBackpackConfigData.class, JanksonConfigSerializer::new);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((s, m) -> AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).load());
        AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).registerLoadListener((holder, config) -> {
            BackpackAbilities.ALLOWED_ABILITIES.clear();
            TravelersBackpackConfig.loadItemsFromConfig(TravelersBackpackConfig.getConfig().backpackAbilities.allowedAbilities, BackpackAbilities.ALLOWED_ABILITIES);
            BackpackAbilities.getBackpackEffects().clear();
            TravelersBackpackConfig.loadBackpackEffectsFromConfig(config.backpackAbilities.backpackEffects, BackpackAbilities.BACKPACK_EFFECTS);
            BackpackAbilities.getBackpackEffects().entries().stream().forEach(entry -> {
                if (!BackpackAbilities.ALLOWED_ABILITIES.contains(entry.getKey())) {
                    BackpackAbilities.ALLOWED_ABILITIES.add((class_1792)entry.getKey());
                }
                if (!BackpackAbilities.ITEM_ABILITIES_LIST.contains(entry.getKey())) {
                    BackpackAbilities.ITEM_ABILITIES_LIST.add((class_1792)entry.getKey());
                }
            });
            ArrayList<class_1792> allowed = new ArrayList<class_1792>(BackpackAbilities.ALLOWED_ABILITIES);
            BackpackAbilities.ITEM_ABILITIES_LIST.removeIf(item -> !allowed.contains(item));
            BackpackAbilities.BLOCK_ABILITIES_LIST.removeIf(item -> !allowed.contains(item));
            BackpackAbilities.getCooldowns().clear();
            TravelersBackpackConfig.loadCooldownsFromConfig(config.backpackAbilities.cooldowns, BackpackAbilities.COOLDOWNS);
            return class_1269.field_5812;
        });
    }

    public static boolean isToolAllowed(class_1799 value) {
        return TravelersBackpackConfig.isOnItemList(value, TravelersBackpackConfig.getConfig().backpackSettings.toolSlotsAcceptableItems);
    }

    public static boolean isItemBlacklisted(class_1799 value) {
        return TravelersBackpackConfig.isOnItemList(value, TravelersBackpackConfig.getConfig().backpackSettings.blacklistedItems);
    }

    public static boolean isOverworldEntityTypePossible(class_1297 value) {
        return TravelersBackpackConfig.isOnEntityList(value, TravelersBackpackConfig.getConfig().world.possibleOverworldEntityTypes);
    }

    public static boolean isNetherEntityTypePossible(class_1297 value) {
        return TravelersBackpackConfig.isOnEntityList(value, TravelersBackpackConfig.getConfig().world.possibleOverworldEntityTypes);
    }

    public static boolean isOnEntityList(class_1297 value, String[] list) {
        return Arrays.stream(list).anyMatch(p -> p.equals(class_7923.field_41177.method_10221((Object)value.method_5864()).toString()));
    }

    public static boolean isOnItemList(class_1799 value, String[] list) {
        return Arrays.stream(list).anyMatch(p -> p.equals(class_7923.field_41178.method_10221((Object)value.method_7909()).toString()));
    }

    public static class_1792 getRandomCompatibleOverworldBackpackEntry(class_5819 random) {
        String[] backpacks = TravelersBackpackConfig.getConfig().world.overworldBackpacks;
        String selectedBackpack = backpacks[random.method_43048(backpacks.length)];
        return (class_1792)class_7923.field_41178.method_17966(class_2960.method_12829((String)selectedBackpack)).orElseThrow(() -> new NoSuchElementException("Wrong backpack registry name specified in the config!"));
    }

    public static class_1792 getRandomCompatibleNetherBackpackEntry(class_5819 random) {
        String[] backpacks = TravelersBackpackConfig.getConfig().world.netherBackpacks;
        String selectedBackpack = backpacks[random.method_43048(backpacks.length)];
        return (class_1792)class_7923.field_41178.method_17966(class_2960.method_12829((String)selectedBackpack)).orElseThrow(() -> new NoSuchElementException("Wrong backpack registry name specified in the config!"));
    }

    public static class_2487 writeToNbt() {
        TravelersBackpackConfigData data = TravelersBackpackConfig.getConfig();
        class_2487 nbt = new class_2487();
        nbt.method_10556("backpackUpgrades.enableTanksUpgrade", data.backpackUpgrades.enableTanksUpgrade);
        nbt.method_10556("backpackUpgrades.enableCraftingUpgrade", data.backpackUpgrades.enableCraftingUpgrade);
        nbt.method_10556("backpackUpgrades.enableFurnaceUpgrade", data.backpackUpgrades.enableFurnaceUpgrade);
        nbt.method_10556("backpackUpgrades.enableSmokerUpgrade", data.backpackUpgrades.enableSmokerUpgrade);
        nbt.method_10556("backpackUpgrades.enableBlastFurnaceUpgrade", data.backpackUpgrades.enableBlastFurnaceUpgrade);
        nbt.method_10556("backpackUpgrades.enableJukeboxUpgrade", data.backpackUpgrades.enableJukeboxUpgrade);
        nbt.method_10556("backpackUpgrades.pickupUpgradeSettings.enableUpgrade", data.backpackUpgrades.pickupUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.pickupUpgradeSettings.filterSlotCount", data.backpackUpgrades.pickupUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.pickupUpgradeSettings.slotsInRow", data.backpackUpgrades.pickupUpgradeSettings.slotsInRow);
        nbt.method_10556("backpackUpgrades.magnetUpgradeSettings.enableUpgrade", data.backpackUpgrades.magnetUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.filterSlotCount", data.backpackUpgrades.magnetUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.slotsInRow", data.backpackUpgrades.magnetUpgradeSettings.slotsInRow);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.pullRange", data.backpackUpgrades.magnetUpgradeSettings.pullRange);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.tickRate", data.backpackUpgrades.magnetUpgradeSettings.tickRate);
        nbt.method_10556("backpackUpgrades.feedingUpgradeSettings.enableUpgrade", data.backpackUpgrades.feedingUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.feedingUpgradeSettings.filterSlotCount", data.backpackUpgrades.feedingUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.feedingUpgradeSettings.slotsInRow", data.backpackUpgrades.feedingUpgradeSettings.slotsInRow);
        nbt.method_10569("backpackUpgrades.feedingUpgradeSettings.tickRate", data.backpackUpgrades.feedingUpgradeSettings.tickRate);
        nbt.method_10556("backpackUpgrades.refillUpgradeSettings.enableUpgrade", data.backpackUpgrades.refillUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.refillUpgradeSettings.filterSlotCount", data.backpackUpgrades.refillUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.refillUpgradeSettings.slotsInRow", data.backpackUpgrades.refillUpgradeSettings.slotsInRow);
        nbt.method_10569("backpackUpgrades.refillUpgradeSettings.tickRate", data.backpackUpgrades.refillUpgradeSettings.tickRate);
        nbt.method_10556("backpackUpgrades.voidUpgradeSettings.enableUpgrade", data.backpackUpgrades.voidUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.voidUpgradeSettings.filterSlotCount", data.backpackUpgrades.voidUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.voidUpgradeSettings.slotsInRow", data.backpackUpgrades.voidUpgradeSettings.slotsInRow);
        nbt.method_10569("backpackSettings.leather.inventorySlotCount", data.backpackSettings.leather.inventorySlotCount);
        nbt.method_10569("backpackSettings.leather.upgradeSlotCount", data.backpackSettings.leather.upgradeSlotCount);
        nbt.method_10569("backpackSettings.leather.toolSlotCount", data.backpackSettings.leather.toolSlotCount);
        nbt.method_10544("backpackSettings.leather.tankCapacityPerRow", data.backpackSettings.leather.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.iron.inventorySlotCount", data.backpackSettings.iron.inventorySlotCount);
        nbt.method_10569("backpackSettings.iron.upgradeSlotCount", data.backpackSettings.iron.upgradeSlotCount);
        nbt.method_10569("backpackSettings.iron.toolSlotCount", data.backpackSettings.iron.toolSlotCount);
        nbt.method_10544("backpackSettings.iron.tankCapacityPerRow", data.backpackSettings.iron.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.gold.inventorySlotCount", data.backpackSettings.gold.inventorySlotCount);
        nbt.method_10569("backpackSettings.gold.upgradeSlotCount", data.backpackSettings.gold.upgradeSlotCount);
        nbt.method_10569("backpackSettings.gold.toolSlotCount", data.backpackSettings.gold.toolSlotCount);
        nbt.method_10544("backpackSettings.gold.tankCapacityPerRow", data.backpackSettings.gold.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.diamond.inventorySlotCount", data.backpackSettings.diamond.inventorySlotCount);
        nbt.method_10569("backpackSettings.diamond.upgradeSlotCount", data.backpackSettings.diamond.upgradeSlotCount);
        nbt.method_10569("backpackSettings.diamond.toolSlotCount", data.backpackSettings.diamond.toolSlotCount);
        nbt.method_10544("backpackSettings.diamond.tankCapacityPerRow", data.backpackSettings.diamond.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.netherite.inventorySlotCount", data.backpackSettings.netherite.inventorySlotCount);
        nbt.method_10569("backpackSettings.netherite.upgradeSlotCount", data.backpackSettings.netherite.upgradeSlotCount);
        nbt.method_10569("backpackSettings.netherite.toolSlotCount", data.backpackSettings.netherite.toolSlotCount);
        nbt.method_10544("backpackSettings.netherite.tankCapacityPerRow", data.backpackSettings.netherite.tankCapacityPerRow);
        nbt.method_10556("backpackSettings.rightClickEquip", data.backpackSettings.rightClickEquip);
        nbt.method_10556("backpackSettings.rightClickUnequip", data.backpackSettings.rightClickUnequip);
        nbt.method_10556("backpackSettings.allowOnlyEquippedBackpack", data.backpackSettings.allowOnlyEquippedBackpack);
        nbt.method_10556("backpackSettings.allowOpeningFromSlot", data.backpackSettings.allowOpeningFromSlot);
        nbt.method_10556("backpackSettings.preventMultiplePlayersAccess", data.backpackSettings.preventMultiplePlayersAccess);
        nbt.method_10556("backpackSettings.invulnerableBackpack", data.backpackSettings.invulnerableBackpack);
        nbt.method_10582("backpackSettings.toolSlotsAcceptableItems", String.join((CharSequence)",", data.backpackSettings.toolSlotsAcceptableItems));
        nbt.method_10582("backpackSettings.blacklistedItems", String.join((CharSequence)",", data.backpackSettings.blacklistedItems));
        nbt.method_10556("backpackSettings.toolSlotsAcceptEverything", data.backpackSettings.toolSlotsAcceptEverything);
        nbt.method_10556("backpackSettings.allowShulkerBoxes", data.backpackSettings.allowShulkerBoxes);
        nbt.method_10556("backpackSettings.voidProtection", data.backpackSettings.voidProtection);
        nbt.method_10556("backpackSettings.backpackDeathPlace", data.backpackSettings.backpackDeathPlace);
        nbt.method_10556("backpackSettings.backpackForceDeathPlace", data.backpackSettings.backpackForceDeathPlace);
        nbt.method_10556("backpackSettings.quickSleepingBag", data.backpackSettings.quickSleepingBag);
        nbt.method_10556("backpackSettings.enableSleepingBagSpawnPoint", data.backpackSettings.enableSleepingBagSpawnPoint);
        nbt.method_10556("backpackSettings.backSlotIntegration", data.backpackSettings.backSlotIntegration);
        nbt.method_10556("world.enableLoot", data.world.enableLoot);
        nbt.method_10548("world.chance", data.world.chance);
        nbt.method_10556("world.spawnEntitiesWithBackpack", data.world.spawnEntitiesWithBackpack);
        nbt.method_10582("world.possibleOverworldEntityTypes", String.join((CharSequence)",", data.world.possibleOverworldEntityTypes));
        nbt.method_10582("world.possibleNetherEntityTypes", String.join((CharSequence)",", data.world.possibleNetherEntityTypes));
        nbt.method_10582("world.overworldBackpacks", String.join((CharSequence)",", data.world.overworldBackpacks));
        nbt.method_10582("world.netherBackpacks", String.join((CharSequence)",", data.world.netherBackpacks));
        nbt.method_10556("world.enableVillagerTrade", data.world.enableVillagerTrade);
        nbt.method_10556("backpackAbilities.enableBackpackAbilities", data.backpackAbilities.enableBackpackAbilities);
        nbt.method_10556("backpackAbilities.forceAbilityEnabled", data.backpackAbilities.forceAbilityEnabled);
        nbt.method_10582("backpackAbilities.allowedAbilities", String.join((CharSequence)",", data.backpackAbilities.allowedAbilities));
        nbt.method_10582("backpackAbilities.backpackEffects", String.join((CharSequence)",", data.backpackAbilities.backpackEffects));
        nbt.method_10582("backpackAbilities.cooldowns", String.join((CharSequence)",", data.backpackAbilities.cooldowns));
        nbt.method_10556("slownessDebuff.tooManyBackpacksSlowness", data.slownessDebuff.tooManyBackpacksSlowness);
        nbt.method_10569("slownessDebuff.maxNumberOfBackpacks", data.slownessDebuff.maxNumberOfBackpacks);
        nbt.method_10569("slownessDebuff.slownessPerExcessedBackpack", data.slownessDebuff.slownessPerExcessedBackpack);
        return nbt;
    }

    public static TravelersBackpackConfigData readFromNbt(class_2487 nbt) {
        TravelersBackpackConfigData client = TravelersBackpackConfig.getConfig();
        TravelersBackpackConfigData data = new TravelersBackpackConfigData();
        data.client.overlay.enableOverlay = client.client.overlay.enableOverlay;
        data.client.overlay.offsetX = client.client.overlay.offsetX;
        data.client.overlay.offsetY = client.client.overlay.offsetY;
        data.client.showBackpackIconInInventory = client.client.showBackpackIconInInventory;
        data.client.sendBackpackCoordinatesMessage = client.client.sendBackpackCoordinatesMessage;
        data.client.enableToolCycling = client.client.enableToolCycling;
        data.client.disableScrollWheel = client.client.disableScrollWheel;
        data.client.obtainTips = client.client.obtainTips;
        data.client.renderTools = client.client.renderTools;
        data.client.showSupporterBadge = client.client.showSupporterBadge;
        if (nbt == null) {
            return data;
        }
        data.backpackUpgrades.enableTanksUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.enableTanksUpgrade").get();
        data.backpackUpgrades.enableCraftingUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.enableCraftingUpgrade").get();
        data.backpackUpgrades.enableFurnaceUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.enableFurnaceUpgrade").get();
        data.backpackUpgrades.enableSmokerUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.enableSmokerUpgrade").get();
        data.backpackUpgrades.enableBlastFurnaceUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.enableBlastFurnaceUpgrade").get();
        data.backpackUpgrades.enableJukeboxUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.enableJukeboxUpgrade").get();
        data.backpackUpgrades.pickupUpgradeSettings.enableUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.pickupUpgradeSettings.enableUpgrade").get();
        data.backpackUpgrades.pickupUpgradeSettings.filterSlotCount = (Integer)nbt.method_10550("backpackUpgrades.pickupUpgradeSettings.filterSlotCount").get();
        data.backpackUpgrades.pickupUpgradeSettings.slotsInRow = (Integer)nbt.method_10550("backpackUpgrades.pickupUpgradeSettings.slotsInRow").get();
        data.backpackUpgrades.magnetUpgradeSettings.enableUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.magnetUpgradeSettings.enableUpgrade").get();
        data.backpackUpgrades.magnetUpgradeSettings.filterSlotCount = (Integer)nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.filterSlotCount").get();
        data.backpackUpgrades.magnetUpgradeSettings.slotsInRow = (Integer)nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.slotsInRow").get();
        data.backpackUpgrades.magnetUpgradeSettings.pullRange = (Integer)nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.pullRange").get();
        data.backpackUpgrades.magnetUpgradeSettings.tickRate = (Integer)nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.tickRate").get();
        data.backpackUpgrades.feedingUpgradeSettings.enableUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.feedingUpgradeSettings.enableUpgrade").get();
        data.backpackUpgrades.feedingUpgradeSettings.filterSlotCount = (Integer)nbt.method_10550("backpackUpgrades.feedingUpgradeSettings.filterSlotCount").get();
        data.backpackUpgrades.feedingUpgradeSettings.slotsInRow = (Integer)nbt.method_10550("backpackUpgrades.feedingUpgradeSettings.slotsInRow").get();
        data.backpackUpgrades.feedingUpgradeSettings.tickRate = (Integer)nbt.method_10550("backpackUpgrades.feedingUpgradeSettings.tickRate").get();
        data.backpackUpgrades.refillUpgradeSettings.enableUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.refillUpgradeSettings.enableUpgrade").get();
        data.backpackUpgrades.refillUpgradeSettings.filterSlotCount = (Integer)nbt.method_10550("backpackUpgrades.refillUpgradeSettings.filterSlotCount").get();
        data.backpackUpgrades.refillUpgradeSettings.slotsInRow = (Integer)nbt.method_10550("backpackUpgrades.refillUpgradeSettings.slotsInRow").get();
        data.backpackUpgrades.refillUpgradeSettings.tickRate = (Integer)nbt.method_10550("backpackUpgrades.refillUpgradeSettings.tickRate").get();
        data.backpackUpgrades.voidUpgradeSettings.enableUpgrade = (Boolean)nbt.method_10577("backpackUpgrades.voidUpgradeSettings.enableUpgrade").get();
        data.backpackUpgrades.voidUpgradeSettings.filterSlotCount = (Integer)nbt.method_10550("backpackUpgrades.voidUpgradeSettings.filterSlotCount").get();
        data.backpackUpgrades.voidUpgradeSettings.slotsInRow = (Integer)nbt.method_10550("backpackUpgrades.voidUpgradeSettings.slotsInRow").get();
        data.backpackSettings.leather.inventorySlotCount = (Integer)nbt.method_10550("backpackSettings.leather.inventorySlotCount").get();
        data.backpackSettings.leather.upgradeSlotCount = (Integer)nbt.method_10550("backpackSettings.leather.upgradeSlotCount").get();
        data.backpackSettings.leather.toolSlotCount = (Integer)nbt.method_10550("backpackSettings.leather.toolSlotCount").get();
        data.backpackSettings.leather.tankCapacityPerRow = (Long)nbt.method_10537("backpackSettings.leather.tankCapacityPerRow").get();
        data.backpackSettings.iron.inventorySlotCount = (Integer)nbt.method_10550("backpackSettings.iron.inventorySlotCount").get();
        data.backpackSettings.iron.upgradeSlotCount = (Integer)nbt.method_10550("backpackSettings.iron.upgradeSlotCount").get();
        data.backpackSettings.iron.toolSlotCount = (Integer)nbt.method_10550("backpackSettings.iron.toolSlotCount").get();
        data.backpackSettings.iron.tankCapacityPerRow = (Long)nbt.method_10537("backpackSettings.iron.tankCapacityPerRow").get();
        data.backpackSettings.gold.inventorySlotCount = (Integer)nbt.method_10550("backpackSettings.gold.inventorySlotCount").get();
        data.backpackSettings.gold.upgradeSlotCount = (Integer)nbt.method_10550("backpackSettings.gold.upgradeSlotCount").get();
        data.backpackSettings.gold.toolSlotCount = (Integer)nbt.method_10550("backpackSettings.gold.toolSlotCount").get();
        data.backpackSettings.gold.tankCapacityPerRow = (Long)nbt.method_10537("backpackSettings.gold.tankCapacityPerRow").get();
        data.backpackSettings.diamond.inventorySlotCount = (Integer)nbt.method_10550("backpackSettings.diamond.inventorySlotCount").get();
        data.backpackSettings.diamond.upgradeSlotCount = (Integer)nbt.method_10550("backpackSettings.diamond.upgradeSlotCount").get();
        data.backpackSettings.diamond.toolSlotCount = (Integer)nbt.method_10550("backpackSettings.diamond.toolSlotCount").get();
        data.backpackSettings.diamond.tankCapacityPerRow = (Long)nbt.method_10537("backpackSettings.diamond.tankCapacityPerRow").get();
        data.backpackSettings.netherite.inventorySlotCount = (Integer)nbt.method_10550("backpackSettings.netherite.inventorySlotCount").get();
        data.backpackSettings.netherite.upgradeSlotCount = (Integer)nbt.method_10550("backpackSettings.netherite.upgradeSlotCount").get();
        data.backpackSettings.netherite.toolSlotCount = (Integer)nbt.method_10550("backpackSettings.netherite.toolSlotCount").get();
        data.backpackSettings.netherite.tankCapacityPerRow = (Long)nbt.method_10537("backpackSettings.netherite.tankCapacityPerRow").get();
        data.backpackSettings.rightClickEquip = (Boolean)nbt.method_10577("backpackSettings.rightClickEquip").get();
        data.backpackSettings.rightClickUnequip = (Boolean)nbt.method_10577("backpackSettings.rightClickUnequip").get();
        data.backpackSettings.allowOnlyEquippedBackpack = (Boolean)nbt.method_10577("backpackSettings.allowOnlyEquippedBackpack").get();
        data.backpackSettings.allowOpeningFromSlot = (Boolean)nbt.method_10577("backpackSettings.allowOpeningFromSlot").get();
        data.backpackSettings.preventMultiplePlayersAccess = (Boolean)nbt.method_10577("backpackSettings.preventMultiplePlayersAccess").get();
        data.backpackSettings.invulnerableBackpack = (Boolean)nbt.method_10577("backpackSettings.invulnerableBackpack").get();
        data.backpackSettings.toolSlotsAcceptableItems = ((String)nbt.method_10558("backpackSettings.toolSlotsAcceptableItems").get()).split(",");
        data.backpackSettings.blacklistedItems = ((String)nbt.method_10558("backpackSettings.blacklistedItems").get()).split(",");
        data.backpackSettings.toolSlotsAcceptEverything = (Boolean)nbt.method_10577("backpackSettings.toolSlotsAcceptEverything").get();
        data.backpackSettings.allowShulkerBoxes = (Boolean)nbt.method_10577("backpackSettings.allowShulkerBoxes").get();
        data.backpackSettings.voidProtection = (Boolean)nbt.method_10577("backpackSettings.voidProtection").get();
        data.backpackSettings.backpackDeathPlace = (Boolean)nbt.method_10577("backpackSettings.backpackDeathPlace").get();
        data.backpackSettings.backpackForceDeathPlace = (Boolean)nbt.method_10577("backpackSettings.backpackForceDeathPlace").get();
        data.backpackSettings.quickSleepingBag = (Boolean)nbt.method_10577("backpackSettings.quickSleepingBag").get();
        data.backpackSettings.enableSleepingBagSpawnPoint = (Boolean)nbt.method_10577("backpackSettings.enableSleepingBagSpawnPoint").get();
        data.backpackSettings.backSlotIntegration = (Boolean)nbt.method_10577("backpackSettings.backSlotIntegration").get();
        data.world.enableLoot = (Boolean)nbt.method_10577("world.enableLoot").get();
        data.world.chance = ((Float)nbt.method_10583("world.chance").get()).floatValue();
        data.world.spawnEntitiesWithBackpack = (Boolean)nbt.method_10577("world.spawnEntitiesWithBackpack").get();
        data.world.possibleOverworldEntityTypes = ((String)nbt.method_10558("world.possibleOverworldEntityTypes").get()).split(",");
        data.world.possibleNetherEntityTypes = ((String)nbt.method_10558("world.possibleNetherEntityTypes").get()).split(",");
        data.world.overworldBackpacks = ((String)nbt.method_10558("world.overworldBackpacks").get()).split(",");
        data.world.netherBackpacks = ((String)nbt.method_10558("world.netherBackpacks").get()).split(",");
        data.world.enableVillagerTrade = (Boolean)nbt.method_10577("world.enableVillagerTrade").get();
        data.backpackAbilities.enableBackpackAbilities = (Boolean)nbt.method_10577("backpackAbilities.enableBackpackAbilities").get();
        data.backpackAbilities.forceAbilityEnabled = (Boolean)nbt.method_10577("backpackAbilities.forceAbilityEnabled").get();
        data.backpackAbilities.allowedAbilities = ((String)nbt.method_10558("backpackAbilities.allowedAbilities").get()).split(",");
        data.backpackAbilities.backpackEffects = ((String)nbt.method_10558("backpackAbilities.backpackEffects").get()).split(",");
        data.backpackAbilities.cooldowns = ((String)nbt.method_10558("backpackAbilities.cooldowns").get()).split(",");
        data.slownessDebuff.tooManyBackpacksSlowness = (Boolean)nbt.method_10577("slownessDebuff.tooManyBackpacksSlowness").get();
        data.slownessDebuff.maxNumberOfBackpacks = (Integer)nbt.method_10550("slownessDebuff.maxNumberOfBackpacks").get();
        data.slownessDebuff.slownessPerExcessedBackpack = (Integer)nbt.method_10550("slownessDebuff.slownessPerExcessedBackpack").get();
        return data;
    }

    public static void loadItemsFromConfig(String[] configList, List<class_1792> targetList) {
        for (String registryName : configList) {
            class_2960 res = class_2960.method_12829((String)registryName);
            if (!class_7923.field_41178.method_10223(res).isPresent()) continue;
            targetList.add((class_1792)class_7923.field_41178.method_63535(res));
        }
    }

    public static void loadBackpackEffectsFromConfig(String[] configList, Multimap<class_1792, BackpackEffect> backpackEffects) {
        try {
            for (String entry : configList) {
                String[] parts = entry.replace(" ", "").split(";");
                if (parts.length != 5) continue;
                class_2960 backpackRes = class_2960.method_12829((String)parts[0]);
                class_2960 effectRes = class_2960.method_12829((String)parts[1]);
                if (!class_7923.field_41178.method_10250(backpackRes) || !class_7923.field_41174.method_10223(effectRes).isPresent() || !class_7923.field_41178.method_10223(backpackRes).isPresent()) continue;
                class_1792 backpack = (class_1792)class_7923.field_41178.method_63535(backpackRes);
                int minDuration = Integer.parseInt(parts[2]);
                int maxDuration = Integer.parseInt(parts[3]);
                int amplifier = Integer.parseInt(parts[4]);
                if (minDuration < 0 || maxDuration < 0 || amplifier < 0) {
                    TravelersBackpack.LOGGER.error("Backpack Effects: duration and amplifier must be positive integers!");
                }
                if (minDuration > maxDuration) {
                    TravelersBackpack.LOGGER.error("Backpack Effects: minDuration must be less than or equal to maxDuration!");
                }
                backpackEffects.put((Object)backpack, (Object)new BackpackEffect((class_6880<class_1291>)((class_6880)class_7923.field_41174.method_10223(effectRes).get()), minDuration, maxDuration, amplifier));
            }
        }
        catch (Exception e) {
            TravelersBackpack.LOGGER.error("Could not load Backpack Effect from Config! Check your config if entries are correct!");
        }
    }

    public static void loadCooldownsFromConfig(String[] config, Map<class_1792, Cooldown> cooldownConfigs) {
        try {
            for (String entry : config) {
                class_2960 backpackRes;
                String[] parts = entry.replace(" ", "").split(";");
                if (parts.length != 3 || class_7923.field_41178.method_10223(backpackRes = class_2960.method_12829((String)parts[0])).isEmpty()) continue;
                class_1792 backpack = (class_1792)class_7923.field_41178.method_63535(backpackRes);
                int minCooldown = Integer.parseInt(parts[1]);
                int maxCooldown = Integer.parseInt(parts[2]);
                if (minCooldown < 0 || maxCooldown < 0) {
                    TravelersBackpack.LOGGER.error("Cooldowns: cooldowns must be positive integers!");
                }
                if (minCooldown > maxCooldown) {
                    TravelersBackpack.LOGGER.error("Cooldowns: minCooldown must be less than or equal to maxCooldown!");
                }
                cooldownConfigs.put(backpack, new Cooldown(minCooldown, maxCooldown));
            }
        }
        catch (Exception e) {
            TravelersBackpack.LOGGER.error("Could not load Cooldowns from Config! Check your config if entries are correct!");
        }
    }
}

