/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.mixin;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309 {
    @Shadow
    @Final
    private class_1656 field_7503;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;
    private static boolean checkAbilitiesForRemoval = true;

    @Shadow
    public abstract void method_17356(class_3414 var1, class_3419 var2, float var3, float var4);

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"method_5773()V"})
    private void abilityTick(CallbackInfo info) {
        PlayerMixin playerMixin;
        if (this instanceof Object && (playerMixin = this) instanceof class_1657) {
            class_1657 player = (class_1657)playerMixin;
            if (ComponentUtils.isWearingBackpack(player)) {
                BackpackWrapper.tick(ComponentUtils.getWearingBackpack(player), player, false);
            }
            if (TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player)) && !checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, ComponentUtils.getWearingBackpack(player))) {
                checkAbilitiesForRemoval = true;
            }
            if (!(!checkAbilitiesForRemoval || player.method_73183().method_8608() || ComponentUtils.isWearingBackpack(player) && TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities)) {
                ServerActions.runAbilitiesRemoval(player);
                checkAbilitiesForRemoval = false;
            }
            if (TravelersBackpackConfig.getConfig().slownessDebuff.tooManyBackpacksSlowness && !player.method_68878()) {
                if (nextBackpackCountCheck > player.method_73183().method_8510()) {
                    return;
                }
                nextBackpackCountCheck = player.method_73183().method_8510() + 100L;
                AtomicInteger numberOfBackpacks = PlayerMixin.checkBackpacksForSlowness(player);
                if (numberOfBackpacks.get() == 0) {
                    return;
                }
                int maxNumberOfBackpacks = TravelersBackpackConfig.getConfig().slownessDebuff.maxNumberOfBackpacks;
                if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                    int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((numberOfBackpacks.get() - maxNumberOfBackpacks) * TravelersBackpackConfig.getConfig().slownessDebuff.slownessPerExcessedBackpack));
                    player.method_6092(new class_1293(class_1294.field_5909, 200, numberOfSlownessLevels - 1, false, false));
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_7324(Lnet/minecraft/class_1297;)V"})
    private void attack(class_1297 target, CallbackInfo ci) {
        PlayerMixin playerMixin;
        if (TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities && this instanceof Object && (playerMixin = this) instanceof class_1657) {
            class_1657 player = (class_1657)playerMixin;
            BackpackAbilities.beeAbility(player, target);
            BackpackAbilities.witherAbility(player, target);
            BackpackAbilities.wardenAbility(player, target);
        }
    }

    @Inject(method={"method_49484()F"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getFlyingSpeed(CallbackInfoReturnable<Float> cir) {
        class_1657 player;
        PlayerMixin playerMixin = this;
        if (playerMixin instanceof class_1657 && BackpackAbilities.ABILITIES.checkBackpack(player = (class_1657)playerMixin, (class_1792)ModItems.FOX_TRAVELERS_BACKPACK) && (!this.field_7503.field_7479 || this.method_5765())) {
            cir.setReturnValue((Object)Float.valueOf(this.method_5624() ? 0.038999997f : 0.033f));
        }
    }

    private static AtomicInteger checkBackpacksForSlowness(class_1657 player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.method_31548().method_67533().size(); ++i) {
            if (!(((class_1799)player.method_31548().method_67533().get(i)).method_7909() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (player.method_6079().method_7909() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }
}

