/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.inventory.FluidTank;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;

public class FluidUtil {
    public static Optional<Storage<FluidVariant>> getFluidStorageAtCursor(class_1657 player, class_1703 menu) {
        Storage ctx = (Storage)ContainerItemContext.ofPlayerCursor((class_1657)player, (class_1703)menu).find(FluidStorage.ITEM);
        if (ctx != null) {
            return Optional.of(ctx);
        }
        return Optional.empty();
    }

    public static Optional<Storage<FluidVariant>> getFluidStorageAtSlot(SingleSlotStorage<ItemVariant> storage) {
        Storage ctx = (Storage)ContainerItemContext.ofSingleSlot(storage).find(FluidStorage.ITEM);
        if (ctx != null) {
            return Optional.of(ctx);
        }
        return Optional.empty();
    }

    public static boolean hasFluidStorageConstant(class_1799 stack) {
        Storage ctx = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
        return ctx != null;
    }

    public static Optional<Storage<FluidVariant>> getFluidStorageConstant(class_1799 stack) {
        Storage ctx = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
        return Optional.of(ctx);
    }

    public static boolean hasFluid(class_1657 player, class_1703 menu) {
        if (FluidUtil.getFluidStorageAtCursor(player, menu).isPresent()) {
            return FluidUtil.getFluidStorageAtCursor(player, menu).get().supportsExtraction();
        }
        return false;
    }

    public static boolean hasFluid(Storage<FluidVariant> storage) {
        return storage.supportsExtraction();
    }

    public static long tryEmptyContainerAtCursor(FluidTank tank, long maxTransferAmount, Storage<FluidVariant> storage, boolean execute) {
        try (Transaction transaction = Transaction.openOuter();){
            long amount = StorageUtil.move(storage, (Storage)tank, f -> true, (long)maxTransferAmount, (TransactionContext)transaction);
            if (amount > 0L) {
                if (execute) {
                    transaction.commit();
                    long l = amount;
                    return l;
                }
                transaction.abort();
                long l = amount;
                return l;
            }
        }
        return 0L;
    }

    public static long tryFillContainerAtCursor(FluidTank tank, long maxTransferAmount, Storage<FluidVariant> storage, boolean execute) {
        try (Transaction transaction = Transaction.openOuter();){
            long amount = StorageUtil.move((Storage)tank, storage, f -> true, (long)maxTransferAmount, (TransactionContext)transaction);
            if (amount > 0L) {
                if (execute) {
                    transaction.commit();
                    long l = amount;
                    return l;
                }
                transaction.abort();
                long l = amount;
                return l;
            }
        }
        return 0L;
    }

    public static long tryFillBucketAtCursor(FluidTank tank, long maxTransferAmount, Storage<FluidVariant> storage, boolean execute) {
        try (Transaction transaction = Transaction.openOuter();){
            long extractedAmount = tank.extract(tank.getFluid().fluidVariant(), 81000L, (TransactionContext)transaction);
            if (extractedAmount == 81000L) {
                if (execute) {
                    transaction.commit();
                    long l = extractedAmount;
                    return l;
                }
                transaction.abort();
                long l = extractedAmount;
                return l;
            }
        }
        return 0L;
    }

    public static long tryFillContainerAtSlot(FluidTank tank, long maxTransferAmount, Storage<FluidVariant> storage, boolean execute, Transaction transaction) {
        long amount = StorageUtil.move((Storage)tank, storage, f -> true, (long)maxTransferAmount, (TransactionContext)transaction);
        if (amount > 0L) {
            if (execute) {
                transaction.commit();
                return amount;
            }
            transaction.abort();
            return amount;
        }
        return 0L;
    }

    public static boolean isSameVariant(FluidVariant variant, FluidVariant other) {
        return variant.isOf((Object)other.getFluid()) && variant.componentsMatch(other.getComponents());
    }
}

