/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack;

import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.compat.accessories.TravelersBackpackAccessory;
import com.tiviacz.travelersbackpack.compat.accessories.TravelersBackpackAccessoryClient;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurio;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurioClient;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModAdvancements;
import com.tiviacz.travelersbackpack.init.ModAttachmentTypes;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModCreativeTabs;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModLootModifiers;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Supporters;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="travelersbackpack")
public class TravelersBackpack {
    public static final String MODID = "travelersbackpack";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean curiosLoaded;
    public static boolean accessoriesLoaded;
    public static boolean craftingTweaksLoaded;
    public static boolean corpseLoaded;
    public static boolean gravestoneLoaded;
    public static boolean toughasnailsLoaded;
    public static boolean comfortsLoaded;
    public static boolean endermanOverhaulLoaded;
    public static boolean jeiLoaded;

    public TravelersBackpack(IEventBus eventBus, ModContainer modContainer) {
        NeoForgeMod.enableMilkFluid();
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TravelersBackpackConfig.serverSpec);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TravelersBackpackConfig.commonSpec);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TravelersBackpackConfig.clientSpec);
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        eventBus.addListener(this::setup);
        eventBus.addListener(this::doClientStuff);
        ModItems.ITEMS.register(eventBus);
        ModItems.ENTITY_TYPES.register(eventBus);
        ModBlocks.BLOCKS.register(eventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(eventBus);
        ModMenuTypes.MENU_TYPES.register(eventBus);
        ModRecipeSerializers.SERIALIZERS.register(eventBus);
        ModFluids.FLUID_TYPES.register(eventBus);
        ModFluids.FLUIDS.register(eventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(eventBus);
        ModLootModifiers.LOOT_MODIFIER_SERIALIZERS.register(eventBus);
        ModAttachmentTypes.ATTACHMENT_TYPES.register(eventBus);
        ModDataComponents.DATA_COMPONENT_TYPES.register(eventBus);
        ModAdvancements.CRITERION_TRIGGERS.register(eventBus);
        curiosLoaded = ModList.get().isLoaded("curios");
        accessoriesLoaded = ModList.get().isLoaded("accessories");
        craftingTweaksLoaded = ModList.get().isLoaded("craftingtweaks");
        if (curiosLoaded && !accessoriesLoaded) {
            TravelersBackpack.loadCuriosCompat(eventBus);
        }
        corpseLoaded = ModList.get().isLoaded("corpse");
        gravestoneLoaded = ModList.get().isLoaded("gravestone");
        toughasnailsLoaded = ModList.get().isLoaded("toughasnails");
        comfortsLoaded = ModList.get().isLoaded("comforts");
        endermanOverhaulLoaded = ModList.get().isLoaded("endermanoverhaul");
        jeiLoaded = ModList.get().isLoaded("jei");
        Supporters.fetchSupporters();
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TravelersBackpackBlock.registerDispenserBehaviour();
            EffectFluidRegistry.initEffects();
            TravelersBackpack.enableCraftingTweaks();
            TravelersBackpackItem.registerCauldronInteraction();
            if (accessoriesLoaded) {
                TravelersBackpackAccessory.init();
            }
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(ModClientEventHandler::registerUpgradeWidgets);
        if (accessoriesLoaded) {
            TravelersBackpackAccessoryClient.init();
        }
        if (curiosLoaded && !accessoriesLoaded) {
            TravelersBackpackCurioClient.registerCurioRenderer();
        }
    }

    private static void loadCuriosCompat(IEventBus bus) {
        bus.addListener(TravelersBackpackCurio::registerCurio);
    }

    public static boolean enableIntegration() {
        return TravelersBackpack.enableCurios() || TravelersBackpack.enableAccessories();
    }

    public static boolean enableCurios() {
        return curiosLoaded && !accessoriesLoaded && (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get() != false;
    }

    public static boolean enableAccessories() {
        return accessoriesLoaded && (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get() != false;
    }

    public static void enableCraftingTweaks() {
        if (craftingTweaksLoaded) {
            try {
                Class.forName("com.tiviacz.travelersbackpack.compat.craftingtweaks.TravelersBackpackCraftingGridProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isAnyGraveModInstalled() {
        return corpseLoaded || gravestoneLoaded;
    }
}

