/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.Window;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.Collections;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class HudOverlay {
    public static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/overlay.png");
    private static float animationProgress = 0.0f;

    public static void renderOverlay(ItemStack stack, Minecraft mc, GuiGraphics guiGraphics) {
        LocalPlayer player = mc.player;
        Window mainWindow = mc.getWindow();
        int scaledWidth = mainWindow.getGuiScaledWidth() - (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
        int scaledHeight = mainWindow.getGuiScaledHeight() - (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
        int textureX = 10;
        boolean textureY = false;
        KeyMapping key = ModClientEventHandler.SWAP_TOOL;
        boolean moveTools = false;
        if (!((RenderInfo)stack.getOrDefault(ModDataComponents.RENDER_INFO, (Object)RenderInfo.EMPTY)).isEmpty()) {
            moveTools = true;
            RenderInfo renderInfo = (RenderInfo)stack.get(ModDataComponents.RENDER_INFO);
            FluidTank leftTank = new FluidTank(renderInfo.getCapacity());
            leftTank.setFluid(renderInfo.getLeftFluidStack());
            FluidTank rightTank = new FluidTank(renderInfo.getCapacity());
            rightTank.setFluid(renderInfo.getRightFluidStack());
            if (!renderInfo.getRightFluidStack().isEmpty()) {
                HudOverlay.drawGuiTank(guiGraphics, rightTank, scaledWidth + 1, scaledHeight, 21, 8);
            }
            if (!renderInfo.getLeftFluidStack().isEmpty()) {
                HudOverlay.drawGuiTank(guiGraphics, leftTank, scaledWidth - 11, scaledHeight, 21, 8);
            }
            if (player != null && player.getMainHandItem().getItem() instanceof HoseItem) {
                int tank = HoseItem.getHoseTank(player.getMainHandItem());
                boolean selectedTextureX = false;
                boolean selectedTextureY = false;
                if (tank == 1) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth, scaledHeight, (float)textureX, (float)textureY, 10, 23, 256, 256);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth - 12, scaledHeight, (float)selectedTextureX, (float)selectedTextureY, 10, 23, 256, 256);
                }
                if (tank == 2) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth, scaledHeight, (float)selectedTextureX, (float)selectedTextureY, 10, 23, 256, 256);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth - 12, scaledHeight, (float)textureX, (float)textureY, 10, 23, 256, 256);
                }
                if (tank == 0) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth, scaledHeight, (float)textureX, (float)textureY, 10, 23, 256, 256);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth - 12, scaledHeight, (float)textureX, (float)textureY, 10, 23, 256, 256);
                }
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth, scaledHeight, (float)textureX, (float)textureY, 10, 23, 256, 256);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, scaledWidth - 12, scaledHeight, (float)textureX, (float)textureY, 10, 23, 256, 256);
            }
        }
        if (stack.has(ModDataComponents.TOOLS_CONTAINER)) {
            NonNullList<ItemStack> tools = HudOverlay.getTools(((BackpackContainerContents)stack.get(ModDataComponents.TOOLS_CONTAINER)).getItems());
            if (key.isDown() && tools.size() > 2) {
                if (animationProgress < 1.0f) {
                    animationProgress += 0.05f;
                }
                for (int i = 0; i < tools.size(); ++i) {
                    HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(i), scaledWidth - (moveTools ? 30 : 0), (int)((float)(scaledHeight + 11) - animationProgress * (float)(i * 15)));
                }
            } else if (!tools.isEmpty()) {
                if (animationProgress > 0.0f) {
                    for (int i = 0; i < tools.size(); ++i) {
                        HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(i), scaledWidth - (moveTools ? 30 : 0), (int)((float)(scaledHeight + 11) - animationProgress * (float)(i * 15)));
                    }
                    animationProgress -= 0.05f;
                } else {
                    if (!((ItemStack)tools.get(0)).isEmpty()) {
                        HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(0), scaledWidth - (moveTools ? 30 : 0), scaledHeight - 4);
                    }
                    if (tools.size() > 1 && !((ItemStack)tools.get(tools.size() - 1)).isEmpty()) {
                        HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(tools.size() - 1), scaledWidth - (moveTools ? 30 : 0), scaledHeight + 11);
                    }
                }
            }
        }
    }

    public static void drawGuiTank(GuiGraphics guiGraphics, FluidTank tank, int startX, int startY, int height, int width) {
        RenderHelper.renderScreenTank(guiGraphics, tank, startX, startY, 0.0, height, width);
    }

    private static void drawItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        guiGraphics.renderFakeItem(stack, x, y);
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
    }

    public static NonNullList<ItemStack> getTools(NonNullList<ItemStack> inventory) {
        NonNullList tools = NonNullList.create();
        for (ItemStack itemStack : inventory) {
            if (itemStack.isEmpty()) continue;
            tools.add((Object)itemStack);
        }
        Collections.reverse(tools);
        return tools;
    }
}

