/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;

public abstract class Button
implements IButton {
    protected final BackpackScreen screen;
    protected final int x;
    protected int y;
    protected final int width;
    protected final int height;

    public Button(BackpackScreen screen, int x, int y, int width, int height) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void drawButton(GuiGraphics guiGraphics, int mouseX, int mouseY, ResourceLocation texture, int u1, int v1, int u2, int v2) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.screen.getGuiLeft() + this.x + 1, this.screen.getGuiTop() + this.y + 1, (float)u1, (float)v1, this.width - 2, this.height - 2, 256, 256);
        if (this.inButton(mouseX, mouseY)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.screen.getGuiLeft() + this.x, this.screen.getGuiTop() + this.y, (float)u2, (float)v2, this.width, this.height, 256, 256);
        }
    }

    public boolean inButton(MouseButtonEvent event) {
        return this.inButton((int)event.x(), (int)event.y());
    }

    public boolean inButton(int mouseX, int mouseY) {
        return this.x <= (mouseX -= this.screen.getGuiLeft()) && mouseX < this.x + this.width && this.y <= (mouseY -= this.screen.getGuiTop()) && mouseY < this.y + this.height;
    }

    public boolean isWithinBounds(double mouseX, double mouseY, Point startPos, Point size) {
        return mouseX >= (double)(this.x + startPos.x()) && mouseX < (double)(this.x + startPos.x() + size.x()) && mouseY >= (double)(this.y + startPos.y()) && mouseY < (double)(this.y + startPos.y() + size.y());
    }

    public boolean isWithinBounds(double mouseX, double mouseY, WidgetElement element) {
        return this.isWithinBounds(mouseX, mouseY, element.pos(), element.size());
    }
}

