/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class SortingButtons
extends WidgetBase<BackpackScreen> {
    public SortingButtons(BackpackScreen screen, Point pos, int width, int height) {
        super(screen, pos, width, height);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x(), this.pos.y(), 77.0f, 54.0f, this.width, this.height, 256, 256);
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.SORT)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 1, this.pos.y() + 2, 78.0f, 69.0f, 12, 12, 256, 256);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.QUICK_STACK)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 13, this.pos.y() + 2, 90.0f, 69.0f, 12, 12, 256, 256);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 25, this.pos.y() + 2, 102.0f, 69.0f, 12, 12, 256, 256);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_PLAYER)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 37, this.pos.y() + 2, 114.0f, 69.0f, 12, 12, 256, 256);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.SORT)) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"screen.travelersbackpack.sort").getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), list, mouseX, mouseY);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.QUICK_STACK)) {
            list = new ArrayList();
            list.add(Component.translatable((String)"screen.travelersbackpack.quick_stack").getVisualOrderText());
            list.add(Component.translatable((String)"screen.travelersbackpack.quick_stack_shift").getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), list, mouseX, mouseY);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
            list = new ArrayList();
            list.add(Component.translatable((String)"screen.travelersbackpack.transfer_to_backpack").getVisualOrderText());
            list.add(Component.translatable((String)"screen.travelersbackpack.transfer_to_backpack_shift").getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), list, mouseX, mouseY);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_PLAYER)) {
            guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.transfer_to_player"), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean button) {
        if (this.isButtonHovered(this.pos, event, Buttons.SORT)) {
            ServerboundActionTagPacket.create(3, 0, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isButtonHovered(this.pos, event, Buttons.QUICK_STACK)) {
            ServerboundActionTagPacket.create(3, 1, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isButtonHovered(this.pos, event, Buttons.TRANSFER_TO_BACKPACK)) {
            ServerboundActionTagPacket.create(3, 2, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isButtonHovered(this.pos, event, Buttons.TRANSFER_TO_PLAYER)) {
            ServerboundActionTagPacket.create(3, 3, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    public boolean isButtonHovered(Point pos, MouseButtonEvent event, Buttons button) {
        return this.isButtonHovered(pos, (int)event.x(), (int)event.y(), button);
    }

    public boolean isButtonHovered(int mouseX, int mouseY, Buttons button) {
        return 65 + button.ordinal() * 11 + ((BackpackScreen)this.screen).getGuiLeft() <= mouseX && mouseX <= 65 + button.ordinal() * 11 + 8 + ((BackpackScreen)this.screen).getGuiLeft() && -6 + ((BackpackScreen)this.screen).getGuiTop() <= mouseY && mouseY <= 2 + ((BackpackScreen)this.screen).getGuiTop();
    }

    public boolean isButtonHovered(Point pos, int mouseX, int mouseY, Buttons button) {
        return pos.x() + 4 + button.ordinal() * 11 <= mouseX && mouseX <= pos.x() + 4 + button.ordinal() * 11 + 8 && pos.y() + 4 <= mouseY && mouseY <= pos.y() + 4 + 8;
    }

    public static enum Buttons {
        SORT,
        QUICK_STACK,
        TRANSFER_TO_BACKPACK,
        TRANSFER_TO_PLAYER;

    }
}

