/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record Slots(List<Integer> unsortables, List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
    public static final Slots EMPTY = new Slots(List.of(), List.of());
    public static final Codec<Slots> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("unsortables").forGetter(Slots::unsortables), (App)Codec.mapPair((MapCodec)Codec.INT.fieldOf("index"), (MapCodec)Codec.mapPair((MapCodec)ItemStack.OPTIONAL_CODEC.fieldOf("item"), (MapCodec)Codec.BOOL.fieldOf("matchComponents"))).codec().listOf().fieldOf("memory").forGetter(Slots::memory)).apply((Applicative)instance, Slots::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Slots> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), Slots::unsortables, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)Codec.mapPair((MapCodec)Codec.INT.fieldOf("index"), (MapCodec)Codec.mapPair((MapCodec)ItemStack.OPTIONAL_CODEC.fieldOf("item"), (MapCodec)Codec.BOOL.fieldOf("matchComponents"))).codec()).apply(ByteBufCodecs.list()), Slots::memory, Slots::new);

    public static Slots updateUnsortables(Slots oldSlots, List<Integer> data) {
        return new Slots(data, oldSlots.memory());
    }

    public static Slots updateMemory(Slots oldSlots, List<Pair<Integer, Pair<ItemStack, Boolean>>> data) {
        return new Slots(oldSlots.unsortables(), data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        List<Integer> unsortables1;
        List<Integer> list;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Slots)) return false;
        Slots slots = (Slots)obj;
        try {
            unsortables1 = list = slots.unsortables();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        List<Integer> memory1 = list = slots.memory();
        if (!this.unsortables.equals(unsortables1)) return false;
        if (!this.memoryMatch(memory1)) return false;
        return true;
    }

    public boolean memoryMatch(List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
        if (this.memory.size() != memory.size()) {
            return false;
        }
        for (int i = 0; i < this.memory.size(); ++i) {
            Pair<Integer, Pair<ItemStack, Boolean>> thisEntry = this.memory.get(i);
            Pair<Integer, Pair<ItemStack, Boolean>> otherEntry = memory.get(i);
            if (!((Integer)thisEntry.getFirst()).equals(otherEntry.getFirst())) {
                return false;
            }
            Pair thisPair = (Pair)thisEntry.getSecond();
            Pair otherPair = (Pair)otherEntry.getSecond();
            if (!((Boolean)thisPair.getSecond()).equals(otherPair.getSecond())) {
                return false;
            }
            if (!((Boolean)thisPair.getSecond()).booleanValue() || ItemStack.matches((ItemStack)((ItemStack)thisPair.getFirst()), (ItemStack)((ItemStack)otherPair.getFirst()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Slots.hashSlots(this.unsortables, this.memory);
    }

    public static int hashSlots(List<Integer> unsortables, List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
        int hash = 0;
        for (Integer n : unsortables) {
            hash = 31 * hash + (n != null ? n.hashCode() : 0);
        }
        for (Pair pair : memory) {
            int innerHash = 0;
            innerHash = 31 * innerHash + (pair.getFirst() != null ? ((Integer)pair.getFirst()).hashCode() : 0);
            Pair innerPair = (Pair)pair.getSecond();
            innerHash = 31 * innerHash + ItemStack.hashItemAndComponents((ItemStack)((ItemStack)innerPair.getFirst()));
            innerHash = 31 * innerHash + (innerPair.getSecond() != null ? ((Boolean)innerPair.getSecond()).hashCode() : 0);
            hash = 31 * hash + innerHash;
        }
        return hash;
    }
}

