/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.google.common.reflect.TypeToken;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.model.BackpackDynamicModel;
import com.tiviacz.travelersbackpack.client.model.BackpackItemModel;
import com.tiviacz.travelersbackpack.client.renderer.BackpackEntityLayer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.client.renderer.HoseSpecialRenderer;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.tooltip.ClientBackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetRegistry;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.PotionFluidType;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.refill.RefillUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.AbstractSmeltingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.AbstractSmeltingWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.BlastFurnaceUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.FurnaceUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.SmokerUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterBlockStateModels;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterSelectItemModelPropertyEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.model.standalone.SimpleUnbakedStandaloneModel;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="travelersbackpack", value={Dist.CLIENT})
public class ModClientEventHandler {
    public static final KeyMapping.Category CATEGORY = new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"controls"));
    public static final KeyMapping OPEN_BACKPACK = new KeyMapping("key.travelersbackpack.inventory", 66, CATEGORY);
    public static final KeyMapping SORT_BACKPACK = new KeyMapping("key.travelersbackpack.sort", -1, CATEGORY);
    public static final KeyMapping ABILITY = new KeyMapping("key.travelersbackpack.ability", -1, CATEGORY);
    public static final KeyMapping SWAP_TOOL = new KeyMapping("key.travelersbackpack.cycle_tool", 90, CATEGORY);
    public static final KeyMapping TOGGLE_TANK = new KeyMapping("key.travelersbackpack.toggle_tank", 78, CATEGORY);
    public static final ResourceLocation STAR_MODEL_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"item/supporter_star");
    public static final StandaloneModelKey<SimpleModelWrapper> STAR_MODEL = new StandaloneModelKey(() -> ((ResourceLocation)STAR_MODEL_LOCATION).toString());

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_BACKPACK);
        event.register(SORT_BACKPACK);
        event.register(ABILITY);
        event.register(SWAP_TOOL);
        event.register(TOGGLE_TANK);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModItems.BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
    }

    @SubscribeEvent
    public static void onLoaderRegistry(ModelEvent.RegisterLoaders event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack"), (UnbakedModelLoader)BackpackDynamicModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerItemModel(RegisterItemModelsEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack"), BackpackItemModel.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    public static void registerBlockStateModel(RegisterBlockStateModels event) {
        event.registerModel(BackpackDynamicModel.UnbakedBlockStateModel.ID, BackpackDynamicModel.UnbakedBlockStateModel.CODEC);
    }

    @SubscribeEvent
    public static void registerSpecialModelRenderer(RegisterSelectItemModelPropertyEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"hose_modes"), HoseSpecialRenderer.TYPE);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterStandalone event) {
        event.register(STAR_MODEL, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.simpleModelWrapper((ResourceLocation)STAR_MODEL_LOCATION));
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, blockDisplayReader, pos, tintIndex) -> {
            BackpackBlockEntity backpack;
            if (tintIndex != 0 || pos == null) {
                return -1;
            }
            BlockEntity patt0$temp = blockDisplayReader.getBlockEntity(pos);
            if (patt0$temp instanceof BackpackBlockEntity && (backpack = (BackpackBlockEntity)patt0$temp).getWrapper().getBackpackStack().has(DataComponents.DYED_COLOR)) {
                return ARGB.opaque((int)((DyedItemColor)backpack.getWrapper().getBackpackStack().get(DataComponents.DYED_COLOR)).rgb());
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack_dye"), BackpackTintSource.MAP_CODEC);
    }

    @SubscribeEvent
    public static void registerClientExtenstions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final int EMPTY_COLOR = 0xF800F8;

            public int getTintColor() {
                return -524040;
            }

            public int getTintColor(FluidStack stack) {
                return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
            }

            public ResourceLocation getStillTexture() {
                return PotionFluidType.POTION_STILL_RL;
            }

            public ResourceLocation getFlowingTexture() {
                return PotionFluidType.POTION_FLOW_RL;
            }
        }, new Holder[]{ModFluids.POTION_FLUID_TYPE});
    }

    @SubscribeEvent
    public static void registerMenuScreensEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.BACKPACK_MENU.get(), BackpackScreen::new);
        event.register((MenuType)ModMenuTypes.BACKPACK_BLOCK_MENU.get(), BackpackScreen::new);
        event.register((MenuType)ModMenuTypes.BACKPACK_SETTINGS_MENU.get(), BackpackSettingsScreen::new);
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiLayersEvent evt) {
        evt.registerBelow(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"overlay"), (pGuiGraphics, pPartialTick) -> {
            Minecraft mc = Minecraft.getInstance();
            if (((Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get()).booleanValue() && !mc.options.hideGui && AttachmentUtils.isWearingBackpack((Player)mc.player) && mc.gameMode.getPlayerMode() != GameType.SPECTATOR) {
                HudOverlay.renderOverlay(AttachmentUtils.getWearingBackpack((Player)mc.player), mc, pGuiGraphics);
            }
        });
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BackpackTooltipComponent.class, ClientBackpackTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerRenderStateModifier(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(new TypeToken<AvatarRenderer<?>>(){}, (entity, state) -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (state instanceof AvatarRenderState) {
                    AvatarRenderState avatarState = state;
                    ItemStack backpack = AttachmentUtils.getWearingBackpack(player);
                    if (!backpack.isEmpty()) {
                        avatarState.setRenderData(BackpackLayer.BACKPACK_KEY, (Object)backpack);
                    }
                    avatarState.setRenderData(BackpackLayer.NAME_KEY, (Object)player.getGameProfile().name());
                }
            }
        });
        event.registerEntityModifier(ZombieRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(SkeletonRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(EndermanRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(WitherSkeletonRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(PiglinRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ModClientEventHandler.addPlayerLayer(evt, PlayerModelType.WIDE);
        ModClientEventHandler.addPlayerLayer(evt, PlayerModelType.SLIM);
        for (EntityType type : evt.getEntityTypes()) {
            HumanoidMobRenderer renderer;
            EntityRenderer entityRenderer = evt.getRenderer(type);
            if (!(entityRenderer instanceof HumanoidMobRenderer) || !((renderer = (HumanoidMobRenderer)entityRenderer).getModel() instanceof HumanoidModel) || TravelersBackpack.endermanOverhaulLoaded && type == EntityType.ENDERMAN) continue;
            renderer.addLayer((RenderLayer)new BackpackEntityLayer((RenderLayerParent<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>)renderer));
        }
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers event, PlayerModelType skinModel) {
        AvatarRenderer renderer = event.getPlayerRenderer(skinModel);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            livingRenderer.addLayer((RenderLayer)new BackpackLayer((RenderLayerParent<AvatarRenderState, PlayerModel>)livingRenderer));
        }
    }

    public static void registerUpgradeWidgets() {
        UpgradeWidgetRegistry.register(CraftingUpgrade.class, (screen, upgrade, x, y) -> new CraftingWidget(screen, (CraftingUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y)));
        UpgradeWidgetRegistry.register(FeedingUpgrade.class, (screen, upgrade, x, y) -> new FeedingWidget(screen, (FeedingUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y)));
        UpgradeWidgetRegistry.register(JukeboxUpgrade.class, (screen, upgrade, x, y) -> new JukeboxWidget(screen, (JukeboxUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y)));
        UpgradeWidgetRegistry.register(MagnetUpgrade.class, (screen, upgrade, x, y) -> new MagnetWidget(screen, (MagnetUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y)));
        UpgradeWidgetRegistry.register(AutoPickupUpgrade.class, (screen, upgrade, x, y) -> new AutoPickupWidget(screen, (AutoPickupUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y)));
        UpgradeWidgetRegistry.register(BlastFurnaceUpgrade.class, (screen, upgrade, x, y) -> new AbstractSmeltingWidget<BlastFurnaceUpgrade>(screen, (AbstractSmeltingUpgrade<BlastFurnaceUpgrade>)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), "screen.travelersbackpack." + upgrade.getUpgradeName()));
        UpgradeWidgetRegistry.register(SmokerUpgrade.class, (screen, upgrade, x, y) -> new AbstractSmeltingWidget<SmokerUpgrade>(screen, (AbstractSmeltingUpgrade<SmokerUpgrade>)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), "screen.travelersbackpack." + upgrade.getUpgradeName()));
        UpgradeWidgetRegistry.register(FurnaceUpgrade.class, (screen, upgrade, x, y) -> new AbstractSmeltingWidget<FurnaceUpgrade>(screen, (AbstractSmeltingUpgrade<FurnaceUpgrade>)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), "screen.travelersbackpack." + upgrade.getUpgradeName()));
        UpgradeWidgetRegistry.register(TanksUpgrade.class, (screen, upgrade, x, y) -> new TankWidget(screen, (TanksUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y)));
        UpgradeWidgetRegistry.register(VoidUpgrade.class, (screen, upgrade, x, y) -> new VoidWidget(screen, (VoidUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y)));
        UpgradeWidgetRegistry.register(RefillUpgrade.class, (screen, upgrade, x, y) -> new UpgradeWidgetBase<RefillUpgrade>(screen, (RefillUpgrade)upgrade, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), new Point(137, 0), "screen.travelersbackpack.refill_upgrade"));
    }

    public record BackpackTintSource(int defaultColor) implements ItemTintSource
    {
        public static final MapCodec<BackpackTintSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.ARGB_COLOR_CODEC.fieldOf("default").forGetter(BackpackTintSource::defaultColor)).apply((Applicative)instance, BackpackTintSource::new));

        public int calculate(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
            DyedItemColor color = (DyedItemColor)itemStack.get(DataComponents.DYED_COLOR);
            if (itemStack.getItem() == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && color != null) {
                return ARGB.opaque((int)color.rgb());
            }
            return this.defaultColor;
        }

        public MapCodec<? extends ItemTintSource> type() {
            return MAP_CODEC;
        }
    }
}

