/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class StorageAccessWrapper
implements ResourceHandler<ItemResource> {
    private final BackpackWrapper wrapper;
    private final BackpackResourceHandler parent;

    public StorageAccessWrapper(BackpackWrapper wrapper, BackpackResourceHandler parent) {
        this.wrapper = wrapper;
        this.parent = parent;
    }

    public int size() {
        return this.parent.size();
    }

    public ItemResource getResource(int index) {
        return (ItemResource)this.parent.getResource(index);
    }

    public long getAmountAsLong(int index) {
        return this.parent.getAmountAsLong(index);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        return this.parent.getCapacityAsLong(index, (Resource)resource);
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.parent.isValid(index, (Resource)resource);
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (this.tryVoiding(resource.toStack())) {
            return amount;
        }
        if (!this.wrapper.getMemorySlots().isEmpty()) {
            ItemStack stack = resource.toStack();
            for (Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack : this.wrapper.getMemorySlots()) {
                int result;
                if (((ItemStack)((Pair)memorizedStack.getSecond()).getFirst()).getItem() != stack.getItem() || (result = this.matchesStack(stack, memorizedStack)) == -1) continue;
                return this.parent.insert(result, (Resource)resource, amount, transaction);
            }
        }
        return this.wrapper.getUnsortableSlots().contains(index) ? 0 : this.parent.insert(index, (Resource)resource, amount, transaction);
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return this.wrapper.getUnsortableSlots().contains(index) ? 0 : this.parent.extract(index, (Resource)resource, amount, transaction);
    }

    public int matchesStack(ItemStack inserted, Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack) {
        if (((Boolean)((Pair)memorizedStack.getSecond()).getSecond()).booleanValue()) {
            return ItemStackUtils.isSameItemSameTags(inserted, (ItemStack)((Pair)memorizedStack.getSecond()).getFirst()) ? (Integer)memorizedStack.getFirst() : -1;
        }
        return ItemStack.isSameItem((ItemStack)inserted, (ItemStack)((ItemStack)((Pair)memorizedStack.getSecond()).getFirst())) ? (Integer)memorizedStack.getFirst() : -1;
    }

    public boolean tryVoiding(ItemStack stack) {
        return this.wrapper.getUpgradeManager().getUpgrade(VoidUpgrade.class).map(voidUpgrade -> voidUpgrade.canVoid(stack)).orElse(false);
    }
}

