/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackItemMenu
extends BackpackBaseMenu {
    public BackpackItemMenu(int windowID, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        this(windowID, playerInventory, BackpackItemMenu.createWrapper(playerInventory, data));
    }

    public BackpackItemMenu(int windowID, Inventory playerInventory, BackpackWrapper wrapper) {
        super((MenuType)ModMenuTypes.BACKPACK_MENU.get(), windowID, playerInventory, wrapper);
        this.wrapper.addUser(playerInventory.player);
    }

    private static BackpackWrapper createWrapper(Inventory inventory, RegistryFriendlyByteBuf data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        int screenID = data.readInt();
        int entityId = data.readInt();
        if (screenID == 2) {
            if (entityId != -1) {
                BackpackWrapper targetWrapper = AttachmentUtils.getBackpackWrapper((Player)inventory.player.level().getEntity(entityId));
                targetWrapper.addUser(inventory.player);
                return targetWrapper;
            }
            return AttachmentUtils.getBackpackWrapper(inventory.player);
        }
        ItemStack backpackStack = entityId == -1 ? inventory.player.getItemInHand(InteractionHand.MAIN_HAND) : (ItemStack)inventory.getNonEquipmentItems().get(entityId);
        return new BackpackWrapper(backpackStack, screenID, (HolderLookup.Provider)data.registryAccess(), inventory.player, inventory.player.level(), entityId);
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (this.getWrapper().getScreenID() == 1 && clickType == ClickType.SWAP) {
            ItemStack stack = player.getInventory().getItem(dragType);
            ItemStack currentItem = player.getInventory().getSelectedItem();
            if (!currentItem.isEmpty() && stack == currentItem) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    @Override
    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (x + y * 9 + 9 == currentItemIndex) {
                    this.addSlot(new DisabledSlot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
                    this.disabledSlotIndex = this.slots.size() - 1;
                    continue;
                }
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            if (x == currentItemIndex && this.wrapper.getScreenID() == 1) {
                this.addSlot(new DisabledSlot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
                this.disabledSlotIndex = this.slots.size() - 1;
                continue;
            }
            this.addSlot(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
        }
    }

    @Override
    public void removed(Player player) {
        if (player.containerMenu instanceof BackpackBaseMenu && player.level().isClientSide()) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.removed(player);
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.getWrapper().getBackpackOwner() != null) {
            return this.getWrapper().getBackpackOwner().isAlive() && AttachmentUtils.isWearingBackpack(this.getWrapper().getBackpackOwner());
        }
        if (this.getWrapper().getScreenID() == 1) {
            ItemStack backpackStack = this.getWrapper().getBackpackSlotIndex() == -1 ? player.getItemInHand(InteractionHand.MAIN_HAND) : this.inventory.getItem(this.getWrapper().getBackpackSlotIndex());
            return backpackStack.getItem() instanceof TravelersBackpackItem;
        }
        return true;
    }
}

