/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;

public class FilterSlotItemHandler
extends ResourceHandlerSlot {
    protected final UpgradeBase upgrade;
    protected final int activeSlotCount;
    protected final int index;

    public FilterSlotItemHandler(UpgradeBase upgrade, BackpackResourceHandler itemHandler, int index, int xPosition, int yPosition, int activeSlotCount) {
        super((ResourceHandler)itemHandler, (arg_0, arg_1, arg_2) -> ((BackpackResourceHandler)itemHandler).set(arg_0, arg_1, arg_2), index, xPosition, yPosition);
        this.upgrade = upgrade;
        this.activeSlotCount = activeSlotCount;
        this.index = index;
    }

    public boolean isActive() {
        return this.upgrade.isTabOpened() && this.index < this.activeSlotCount;
    }

    public boolean mayPlace(ItemStack pStack) {
        return this.upgrade.isTabOpened() && this.index < this.activeSlotCount && super.mayPlace(pStack);
    }

    public boolean isFake() {
        return true;
    }

    public boolean mayPickup(Player player) {
        return this.upgrade.getUpgradeManager().getWrapper().isOwner(player) && this.index < this.activeSlotCount;
    }

    public Optional<ItemStack> tryRemove(int count, int decrement, Player player) {
        if (!this.mayPickup(player)) {
            return Optional.empty();
        }
        this.set(ItemStack.EMPTY);
        return Optional.empty();
    }

    public ItemStack safeInsert(ItemStack stack, int increment) {
        if (!stack.isEmpty() && this.mayPlace(stack)) {
            this.set(stack.copyWithCount(1));
        }
        return stack;
    }
}

