/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.sorter.SortType;
import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemUtil;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ContainerSorter {
    public static final int SORT_BACKPACK = 0;
    public static final int QUICK_STACK = 1;
    public static final int TRANSFER_TO_BACKPACK = 2;
    public static final int TRANSFER_TO_PLAYER = 3;

    public static void selectSort(BackpackWrapper backpackWrapper, Player player, int button, boolean shiftPressed) {
        if (button == 0) {
            ContainerSorter.sortBackpack(backpackWrapper, player, SortType.Type.CATEGORY, shiftPressed);
        } else if (button == 1) {
            ContainerSorter.quickStackToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if (button == 2) {
            ContainerSorter.transferToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if (button == 3) {
            ContainerSorter.transferToPlayer(backpackWrapper, player);
        }
    }

    public static void sortBackpack(BackpackWrapper backpackWrapper, Player player, SortType.Type type, boolean shiftPressed) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        CustomResourceHandler storage = new CustomResourceHandler(backpackWrapper, backpackWrapper.getStorage());
        for (int i = 0; i < storage.getSlots(); ++i) {
            ContainerSorter.addStackWithMerge(stacks, backpackWrapper.getUnsortableSlots().contains(i) ? ItemStack.EMPTY : storage.getStackInSlot(i));
        }
        if (!stacks.isEmpty()) {
            stacks.sort(Comparator.comparing(stack -> SortType.getStringForSort(stack, type)));
        }
        if (stacks.isEmpty()) {
            return;
        }
        int j = 0;
        for (int i = 0; i < storage.getSlots(); ++i) {
            if (backpackWrapper.getUnsortableSlots().contains(i)) continue;
            storage.setStackInSlot(i, j < stacks.size() ? (ItemStack)stacks.get(j) : ItemStack.EMPTY);
            ++j;
        }
    }

    public static void quickStackToBackpackNoSort(BackpackWrapper backpackWrapper, Player player, boolean shiftPressed) {
        int i;
        ResourceHandler playerStacks = VanillaContainerWrapper.of((Container)player.getInventory());
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = ((ItemResource)playerStacks.getResource(i)).toStack(playerStacks.getAmountAsInt(i));
            if (!(playerStack.isEmpty() || backpackWrapper.getScreenID() == 1 && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.getInventory().getSelectedSlot() : backpackWrapper.getBackpackSlotIndex()))) {
                CustomResourceHandler storage = new CustomResourceHandler(backpackWrapper, backpackWrapper.getStorage());
                boolean hasExistingStack = IntStream.range(0, storage.getSlots()).mapToObj(storage::getStackInSlot).filter(existing -> !existing.isEmpty()).anyMatch(existing -> existing.getItem() == playerStack.getItem());
                if (hasExistingStack) {
                    ItemStack ext = InventoryHelper.extractItem((ResourceHandler<ItemResource>)playerStacks, i, Integer.MAX_VALUE, false);
                    for (int j = 0; j < storage.getSlots() && !(ext = ItemUtil.insertItemReturnRemaining((ResourceHandler)storage, (int)j, (ItemStack)ext, (boolean)false, null)).isEmpty(); ++j) {
                    }
                    if (!ext.isEmpty()) {
                        ItemUtil.insertItemReturnRemaining((ResourceHandler)playerStacks, (int)i, (ItemStack)ext, (boolean)false, null);
                    }
                }
            }
            ++i;
        }
    }

    public static void transferToBackpackNoSort(BackpackWrapper backpackWrapper, Player player, boolean shiftPressed) {
        int i;
        ResourceHandler playerStacks;
        block10: {
            playerStacks = VanillaContainerWrapper.of((Container)player.getInventory());
            if (backpackWrapper.getMemorySlots().isEmpty()) break block10;
            for (Pair<Integer, Pair<ItemStack, Boolean>> pair : backpackWrapper.getMemorySlots()) {
                int i2;
                int n = i2 = shiftPressed ? 0 : 9;
                while (i2 < 36) {
                    block11: {
                        ItemStack ext;
                        block12: {
                            ItemStack playerStack = ((ItemResource)playerStacks.getResource(i2)).toStack(playerStacks.getAmountAsInt(i2));
                            if (playerStack.isEmpty() || backpackWrapper.getScreenID() == 1 && i2 == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.getInventory().getSelectedSlot() : backpackWrapper.getBackpackSlotIndex())) break block11;
                            CustomResourceHandler wrapper = new CustomResourceHandler(backpackWrapper, backpackWrapper.getStorage());
                            ItemStack extSimulate = InventoryHelper.extractItem((ResourceHandler<ItemResource>)playerStacks, i2, Integer.MAX_VALUE, true);
                            ext = ItemStack.EMPTY;
                            if (!((Boolean)((Pair)pair.getSecond()).getSecond() != false ? ItemStackUtils.isSameItemSameTags((ItemStack)((Pair)pair.getSecond()).getFirst(), extSimulate) : ItemStack.isSameItem((ItemStack)((ItemStack)((Pair)pair.getSecond()).getFirst()), (ItemStack)extSimulate))) break block12;
                            ext = InventoryHelper.extractItem((ResourceHandler<ItemResource>)playerStacks, i2, Integer.MAX_VALUE, false);
                            ext = ItemUtil.insertItemReturnRemaining((ResourceHandler)wrapper, (int)((Integer)pair.getFirst()), (ItemStack)ext, (boolean)false, null);
                            if (ext.isEmpty()) break block11;
                        }
                        if (!ext.isEmpty()) {
                            ItemUtil.insertItemReturnRemaining((ResourceHandler)playerStacks, (int)i2, (ItemStack)ext, (boolean)false, null);
                        }
                    }
                    ++i2;
                }
            }
        }
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = ((ItemResource)playerStacks.getResource(i)).toStack(playerStacks.getAmountAsInt(i));
            if (!(playerStack.isEmpty() || backpackWrapper.getScreenID() == 1 && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.getInventory().getSelectedSlot() : backpackWrapper.getBackpackSlotIndex()))) {
                CustomResourceHandler wrapper = new CustomResourceHandler(backpackWrapper, backpackWrapper.getStorage());
                ItemStack ext = InventoryHelper.extractItem((ResourceHandler<ItemResource>)playerStacks, i, Integer.MAX_VALUE, false);
                for (int j = 0; j < wrapper.getSlots() && !(ext = ItemUtil.insertItemReturnRemaining((ResourceHandler)wrapper, (int)j, (ItemStack)ext, (boolean)false, null)).isEmpty(); ++j) {
                }
                if (!ext.isEmpty()) {
                    ItemUtil.insertItemReturnRemaining((ResourceHandler)playerStacks, (int)i, (ItemStack)ext, (boolean)false, null);
                }
            }
            ++i;
        }
    }

    public static void transferToPlayer(BackpackWrapper backpackWrapper, Player player) {
        ResourceHandler playerStacks = VanillaContainerWrapper.of((Container)player.getInventory());
        CustomResourceHandler wrapper = new CustomResourceHandler(backpackWrapper, backpackWrapper.getStorage());
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            ItemStack stack = wrapper.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemStack ext = InventoryHelper.extractItem(wrapper, i, Integer.MAX_VALUE, false);
            for (int j = 9; j < 36 && !(ext = ItemUtil.insertItemReturnRemaining((ResourceHandler)playerStacks, (int)j, (ItemStack)ext, (boolean)false, null)).isEmpty(); ++j) {
            }
            if (ext.isEmpty()) continue;
            wrapper.isTransferToPlayer = true;
            ItemUtil.insertItemReturnRemaining((ResourceHandler)wrapper, (int)i, (ItemStack)ext, (boolean)false, null);
            wrapper.isTransferToPlayer = false;
        }
    }

    private static void addStackWithMerge(List<ItemStack> stacks, ItemStack newStack) {
        if (newStack.isEmpty()) {
            return;
        }
        if (newStack.isStackable() && newStack.getCount() != newStack.getMaxStackSize()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                ItemStack oldStack = stacks.get(j);
                if (!ContainerSorter.canMergeItems(newStack, oldStack)) continue;
                ContainerSorter.combineStacks(newStack, oldStack);
                if (!oldStack.isEmpty() && oldStack.getCount() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(ItemStack stack, ItemStack stack2) {
        if (stack.getMaxStackSize() >= stack.getCount() + stack2.getCount()) {
            stack.grow(stack2.getCount());
            stack2.setCount(0);
        }
        int maxInsertAmount = Math.min(stack.getMaxStackSize() - stack.getCount(), stack2.getCount());
        stack.grow(maxInsertAmount);
        stack2.shrink(maxInsertAmount);
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.isStackable() || !stack2.isStackable()) {
            return false;
        }
        if (stack1.getCount() == stack2.getMaxStackSize() || stack2.getCount() == stack2.getMaxStackSize()) {
            return false;
        }
        if (stack1.getItem() != stack2.getItem()) {
            return false;
        }
        if (stack1.getDamageValue() != stack2.getDamageValue()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static class CustomResourceHandler
    implements ResourceHandler<ItemResource> {
        public final BackpackWrapper wrapper;
        public final BackpackResourceHandler parent;
        public boolean isTransferToPlayer;

        public CustomResourceHandler(BackpackWrapper wrapper, BackpackResourceHandler parent) {
            this(wrapper, parent, false);
        }

        public CustomResourceHandler(BackpackWrapper wrapper, BackpackResourceHandler parent, boolean isTransferToPlayer) {
            this.wrapper = wrapper;
            this.parent = parent;
            this.isTransferToPlayer = isTransferToPlayer;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.getResource(slot).toStack(this.getAmountAsInt(slot));
        }

        public int getSlots() {
            return this.size();
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.parent.set(slot, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
        }

        public int size() {
            return this.parent.size();
        }

        public ItemResource getResource(int index) {
            return (ItemResource)this.parent.getResource(index);
        }

        public long getAmountAsLong(int index) {
            return this.parent.getAmountAsLong(index);
        }

        public long getCapacityAsLong(int index, ItemResource resource) {
            return this.parent.getCapacityAsLong(index, (Resource)resource);
        }

        public boolean isValid(int index, ItemResource resource) {
            return this.parent.isValid(index, (Resource)resource);
        }

        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (this.wrapper.getMemorizedSlot(index).isPresent()) {
                return this.wrapper.getMemorySlots().stream().noneMatch(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        return (Integer)pair.getFirst() == index && ItemStackUtils.isSameItemSameTags((ItemStack)((Pair)pair.getSecond()).getFirst(), resource.toStack());
                    }
                    return (Integer)pair.getFirst() == index && ItemStack.isSameItem((ItemStack)((ItemStack)((Pair)pair.getSecond()).getFirst()), (ItemStack)resource.toStack());
                }) ? 0 : this.parent.insert(index, (Resource)resource, amount, transaction);
            }
            return this.wrapper.getUnsortableSlots().contains(index) ? 0 : this.parent.insert(index, (Resource)resource, amount, transaction);
        }

        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            return this.wrapper.getUnsortableSlots().contains(index) ? 0 : this.parent.extract(index, (Resource)resource, amount, transaction);
        }
    }
}

