/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.transfer;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class BackpackResourceHandler
extends ItemStacksResourceHandler {
    public BackpackResourceHandler(int size) {
        super(size);
    }

    public BackpackResourceHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public ItemStack getStackInSlot(int slot) {
        return ((ItemResource)this.getResource(slot)).toStack(this.getAmountAsInt(slot));
    }

    public int getSlots() {
        return this.size();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.set(slot, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        ItemResource resource = (ItemResource)this.getResource(slot);
        if (resource.isEmpty()) {
            return ItemStack.EMPTY;
        }
        amount = Math.min(amount, resource.getMaxStackSize());
        try (Transaction tx = Transaction.openRoot();){
            int extracted = this.extract(slot, (Resource)resource, amount, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = resource.toStack(extracted);
            return itemStack;
        }
    }
}

