/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.upgrades.IMoveSelector;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public class ResultArrowElement {
    private final BackpackScreen backpackScreen;
    private final UpgradeWidgetBase<?> upgradeWidgetBase;
    private final WidgetElement arrowElement;

    public ResultArrowElement(BackpackScreen backpackScreen, UpgradeWidgetBase<?> upgradeWidgetBase, WidgetElement arrowElement) {
        this.backpackScreen = backpackScreen;
        this.upgradeWidgetBase = upgradeWidgetBase;
        this.arrowElement = arrowElement;
    }

    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        Object obj;
        if (this.upgradeWidgetBase.isTabOpened() && (obj = this.upgradeWidgetBase.getUpgrade()) instanceof IMoveSelector) {
            IMoveSelector selector = (IMoveSelector)obj;
            if (selector.shiftClickToBackpack(((UpgradeBase)this.upgradeWidgetBase.getUpgrade()).getDataHolderStack())) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.upgradeWidgetBase.getPos().x() + this.arrowElement.pos().x(), this.upgradeWidgetBase.getPos().y() + this.arrowElement.pos().y(), 12.0f, 55.0f, this.arrowElement.size().x(), this.arrowElement.size().y(), 256, 256);
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.upgradeWidgetBase.getPos().x() + this.arrowElement.pos().x(), this.upgradeWidgetBase.getPos().y() + this.arrowElement.pos().y(), 0.0f, 55.0f, this.arrowElement.size().x(), this.arrowElement.size().y(), 256, 256);
            }
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Object obj;
        if (this.upgradeWidgetBase.isTabOpened() && this.isMouseOverShiftClickButton(mouseX, mouseY) && (obj = this.upgradeWidgetBase.getUpgrade()) instanceof IMoveSelector) {
            IMoveSelector selector = (IMoveSelector)obj;
            if (selector.shiftClickToBackpack(((UpgradeBase)this.upgradeWidgetBase.getUpgrade()).getDataHolderStack())) {
                guiGraphics.setTooltipForNextFrame(this.backpackScreen.getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.crafting_to_backpack"), mouseX, mouseY);
            } else {
                guiGraphics.setTooltipForNextFrame(this.backpackScreen.getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.crafting_to_player"), mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(MouseButtonEvent event) {
        Object obj;
        if (this.isMouseOverShiftClickButton(event.x(), event.y()) && this.upgradeWidgetBase.isTabOpened() && (obj = this.upgradeWidgetBase.getUpgrade()) instanceof IMoveSelector) {
            IMoveSelector selector = (IMoveSelector)obj;
            ServerboundActionTagPacket.create(0, ((UpgradeBase)this.upgradeWidgetBase.getUpgrade()).getDataHolderSlot(), !selector.shiftClickToBackpack(((UpgradeBase)this.upgradeWidgetBase.getUpgrade()).getDataHolderStack()), 2);
            this.backpackScreen.playUIClickSound();
            return true;
        }
        return false;
    }

    public boolean isMouseOverShiftClickButton(double mouseX, double mouseY) {
        return this.upgradeWidgetBase.isWithinBounds(mouseX, mouseY, this.arrowElement);
    }
}

