/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import org.jetbrains.annotations.Nullable;

public class FeedingUpgrade
extends FilterUpgradeBase<FeedingUpgrade, FeedingFilterSettings>
implements IEnable,
ITickableUpgrade {
    private static final int STILL_HUNGRY_COOLDOWN = 10;

    public FeedingUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter) {
        super(manager, dataHolderSlot, new Point(66, 49), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get(), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.slotsInRow.get(), filter, List.of());
    }

    @Override
    public boolean hasTagSelector() {
        return false;
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().getOrDefault(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0)));
    }

    @Override
    public FeedingFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new FeedingFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.isEmpty()).toList(), this.getFilter(), manager.getWrapper().getRegistriesAccess());
    }

    public boolean canEat(Player player, ItemStack stack) {
        return ((FeedingFilterSettings)this.getFilterSettings()).matchesFilter(player, stack) && !player.getCooldowns().isOnCooldown(stack);
    }

    @Override
    protected FilterHandler createFilter(NonNullList<ItemStack> stacks, final int size) {
        return new FilterHandler(stacks, size){

            protected void onContentsChanged(int slot, ItemStack previousStack) {
                FeedingUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(size, FeedingUpgrade.this.filter));
                ((FeedingFilterSettings)FeedingUpgrade.this.getFilterSettings()).updateFilter((List<ItemStack>)((BackpackContainerContents)FeedingUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            @Override
            public boolean isValid(int slot, ItemResource resource) {
                return resource.has(DataComponents.FOOD);
            }
        };
    }

    @Override
    public int getTickRate() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.tickRate.get();
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        this.getUpgradeManager().getWrapper().loadAdditionally(0);
        if (this.feedPlayerAndGetHungry(player, level)) {
            this.setCooldown(10);
            return;
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    private boolean feedPlayerAndGetHungry(Player player, Level level) {
        int hungerLevel = 20 - player.getFoodData().getFoodLevel();
        if (hungerLevel == 0 || level.isClientSide()) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.getFoodData().getFoodLevel() < 20;
    }

    private boolean tryFeedingFoodFromStorage(Level level, int hungerLevel, Player player) {
        BackpackResourceHandler storage = this.getUpgradeManager().getWrapper().getStorage();
        return InventoryHelper.iterate(storage, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (ItemStack)stack, storage));
    }

    private boolean tryFeedingStack(Level level, int hungerLevel, Player player, Integer slot, ItemStack stack, BackpackResourceHandler backpackStorage) {
        if (FeedingUpgrade.isEdible(stack, (LivingEntity)player) && this.canEat(player, stack)) {
            ItemStack mainHandItem = player.getMainHandItem();
            player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)stack);
            ItemStack singleItemCopy = stack.copy();
            singleItemCopy.setCount(1);
            if (singleItemCopy.use(level, player, InteractionHand.MAIN_HAND) == InteractionResult.CONSUME) {
                int inserted;
                player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)mainHandItem);
                stack.shrink(1);
                backpackStorage.setStackInSlot(slot, stack);
                ItemStack resultItem = EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)singleItemCopy, (int)0, (ItemStack)singleItemCopy.getItem().finishUsingItem(singleItemCopy, level, (LivingEntity)player));
                if (!resultItem.isEmpty() && (inserted = ResourceHandlerUtil.insertStacking((ResourceHandler)new StorageAccessWrapper(this.getUpgradeManager().getWrapper(), backpackStorage), (Resource)ItemResource.of((ItemStack)resultItem), (int)resultItem.getCount(), null)) == 0) {
                    player.drop(resultItem, true);
                }
                return true;
            }
            player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(ItemStack stack, LivingEntity player) {
        if (!stack.has(DataComponents.FOOD)) {
            return false;
        }
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        return foodProperties != null && foodProperties.nutrition() >= 1;
    }
}

