/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TankActions {
    public static void fillTank(ServerPlayer player, boolean leftTank) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = player;
            AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                ItemStack newCarried;
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                BackpackWrapper wrapper = menu.getWrapper();
                FluidTank tank = leftTank ? wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get().getLeftTank() : wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get().getRightTank();
                ItemStack carried = menu.getCarried();
                if (FluidUtil.getFluidContained((ItemStack)carried).isPresent() && carried.getCount() == 1) {
                    SoundEvent fluidSound = tank.isEmpty() ? SoundEvents.BUCKET_EMPTY : tank.getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_EMPTY);
                    FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)carried, (IFluidHandler)tank, (int)wrapper.getBackpackTankCapacity(), (Player)(wrapper.getScreenID() == 1 ? null : serverPlayer), (boolean)true);
                    if (result.isSuccess()) {
                        if (wrapper.getScreenID() == 1) {
                            InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), fluidSound, false);
                        }
                        menu.setCarried(result.getResult());
                    }
                } else if (FluidUtil.getFluidHandler((ItemStack)carried).isPresent() && FluidUtil.getFluidContained((ItemStack)carried).isEmpty()) {
                    ItemStack carriedCopy = carried.copy();
                    int count = carriedCopy.getCount();
                    carriedCopy.setCount(count - 1);
                    SoundEvent fluidSound = tank.isEmpty() ? SoundEvents.BUCKET_FILL : tank.getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_FILL);
                    FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)carried, (IFluidHandler)tank, (int)wrapper.getBackpackTankCapacity(), (Player)(wrapper.getScreenID() == 1 ? null : serverPlayer), (boolean)true);
                    if (result.isSuccess()) {
                        if (carriedCopy.getCount() > 0) {
                            serverPlayer.getInventory().placeItemBackInInventory(result.getResult());
                            menu.setCarried(carriedCopy);
                        } else {
                            menu.setCarried(result.getResult());
                        }
                        if (wrapper.getScreenID() == 1) {
                            InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), fluidSound, true);
                        }
                    }
                } else if (carried.getItem() instanceof PotionItem && carried.getItem() != Items.GLASS_BOTTLE) {
                    if (carried.getCount() == 1) {
                        int potionType = 0;
                        if (carried.getItem() == Items.SPLASH_POTION) {
                            potionType = 1;
                        }
                        if (carried.getItem() == Items.LINGERING_POTION) {
                            potionType = 2;
                        }
                        if (TankActions.tryEmptyPotion(carried, tank, potionType)) {
                            InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), SoundEvents.BREWING_STAND_BREW, true);
                            menu.setCarried(potionType != 0 ? ItemStack.EMPTY.copy() : new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                        }
                    }
                } else if (carried.getItem() == Items.GLASS_BOTTLE && !(newCarried = TankActions.tryFillPotion(carried, tank, serverPlayer, true)).isEmpty()) {
                    ItemStack result = TankActions.tryFillPotion(carried, tank, serverPlayer, false);
                    InventoryActions.playFluidSound(wrapper.getBackpackOwner(), wrapper.getPlayersUsing(), SoundEvents.BREWING_STAND_BREW, false);
                    menu.setCarried(result);
                }
            }
        }
    }

    public static boolean tryEmptyPotion(ItemStack carried, FluidTank tank, int potionType) {
        int amount = 250;
        FluidStack fluidStack = new FluidStack((Fluid)ModFluids.POTION_FLUID.get(), amount);
        FluidStackHelper.setFluidStackData(carried, fluidStack, potionType);
        if ((tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidStack)) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static ItemStack tryFillPotion(ItemStack carried, FluidTank tank, ServerPlayer player, boolean simulate) {
        if (tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && tank.getFluidAmount() >= 250) {
            ItemStack filledPotion = FluidStackHelper.getItemStackFromFluidStack(tank.getFluid());
            if (simulate) {
                return filledPotion;
            }
            ItemStack carriedCopy = carried.copy();
            int count = carriedCopy.getCount();
            carriedCopy.setCount(count - 1);
            tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
            if (carriedCopy.getCount() > 0) {
                player.getInventory().placeItemBackInInventory(filledPotion);
                return carriedCopy;
            }
            return filledPotion;
        }
        return ItemStack.EMPTY;
    }
}

