/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TankWidget
extends UpgradeWidgetBase<TanksUpgrade> {
    public final int tankWidth = 18;
    public final int tankHeight;
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TankWidget(BackpackScreen screen, TanksUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(0, 0), "screen.travelersbackpack.tanks_upgrade");
        this.tankHeight = 18 * screen.visibleRows;
        this.leftTankPos = upgrade.leftTankPos;
        this.rightTankPos = upgrade.rightTankPos;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.inTank(this.leftTankPos, mouseX, mouseY)) {
            guiGraphics.setComponentTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).leftTank), mouseX, mouseY);
        }
        if (this.inTank(this.rightTankPos, mouseX, mouseY)) {
            guiGraphics.setComponentTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).rightTank), mouseX, mouseY);
        }
    }

    @Override
    public void renderAboveBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int extendedOffset = 0;
        int rows = ((TanksUpgrade)this.upgrade).getUpgradeManager().getWrapper().getRows();
        this.renderTank(guiGraphics, rows, x + 7, y += 10);
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).leftTank, x + 8, y + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) * 18 - 2, 16.0);
        if (((TanksUpgrade)this.upgrade).getUpgradeManager().getWrapper().isExtended()) {
            extendedOffset = 36;
        }
        this.renderTank(guiGraphics, rows, x + 195 + extendedOffset, y);
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).rightTank, x + 196 + extendedOffset, y + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) * 18 - 2, 16.0);
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean pButton) {
        if (this.inTank(this.leftTankPos, (int)event.x(), (int)event.y()) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getCarried())) {
            ServerboundActionTagPacket.create(5, true);
            return true;
        }
        if (this.inTank(this.rightTankPos, (int)event.x(), (int)event.y()) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getCarried())) {
            ServerboundActionTagPacket.create(5, false);
            return true;
        }
        return super.mouseClicked(event, pButton);
    }

    @Override
    public boolean isMouseOver(double pMouseX, double pMouseY) {
        if ((this.inTank(this.leftTankPos, (int)pMouseX, (int)pMouseY) || this.inTank(this.rightTankPos, (int)pMouseX, (int)pMouseY)) && !((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getCarried().isEmpty()) {
            return true;
        }
        return super.isMouseOver(pMouseX, pMouseY);
    }

    public boolean isValid(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent() || stack.getItem() instanceof PotionItem || stack.getItem() == Items.GLASS_BOTTLE;
    }

    public void renderTank(GuiGraphics guiGraphics, int rows, int x, int y) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, x, y + 7, 0.0f, 95.0f, 18, 18, 256, 256);
        for (int i = 1; i <= (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) - 2; ++i) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, x, y + 7 + 18 * i, 0.0f, 113.0f, 18, 18, 256, 256);
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, x, y + 7 + 18 * ((((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) - 1), 0.0f, 131.0f, 18, 18, 256, 256);
    }

    public List<Component> getTankTooltip(FluidTank tank) {
        Object fluidAmount;
        FluidStack fluidStack = tank.getFluid();
        ArrayList<Component> tankTips = new ArrayList<Component>();
        String fluidName = !fluidStack.isEmpty() ? fluidStack.getHoverName().getString() : I18n.get((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object object = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + tank.getCapacity() : I18n.get((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.has(DataComponents.POTION_CONTENTS)) {
            float durationFactor = 1.0f;
            if (fluidStack.has(DataComponents.CUSTOM_DATA) && ((CustomData)fluidStack.get(DataComponents.CUSTOM_DATA)).copyTag().contains("PotionType")) {
                int potionType = ((CustomData)fluidStack.get(DataComponents.CUSTOM_DATA)).copyTag().getIntOr("PotionType", 0);
                if (potionType == 1) {
                    tankTips.add((Component)Component.translatable((String)"item.minecraft.splash_potion"));
                }
                if (potionType == 2) {
                    tankTips.add((Component)Component.translatable((String)"item.minecraft.lingering_potion"));
                    durationFactor = 0.25f;
                }
            }
            fluidName = null;
            PotionContents contents = (PotionContents)fluidStack.get(DataComponents.POTION_CONTENTS);
            if (Minecraft.getInstance().level != null) {
                PotionContents.addPotionTooltip((Iterable)contents.getAllEffects(), tankTips::add, (float)durationFactor, (float)Minecraft.getInstance().level.tickRateManager().tickrate());
            }
        }
        if (fluidName != null) {
            tankTips.add((Component)Component.literal((String)fluidName));
        }
        tankTips.add((Component)Component.literal((String)fluidAmount));
        return tankTips;
    }

    public boolean inTank(Point tankPos, int mouseX, int mouseY) {
        return ((BackpackScreen)this.screen).getGuiLeft() + tankPos.x() <= mouseX && mouseX <= tankPos.x() + this.tankWidth + ((BackpackScreen)this.screen).getGuiLeft() && tankPos.y() + ((BackpackScreen)this.screen).getGuiTop() <= mouseY && mouseY <= tankPos.y() + this.tankHeight + ((BackpackScreen)this.screen).getGuiTop();
    }
}

