/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.mojang.serialization.DynamicOps;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.transfer.BackpackResourceHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;

public class TanksUpgrade
extends UpgradeBase<TanksUpgrade> {
    private final BackpackResourceHandler fluidSlotsHandler = this.createTemporaryHandler();
    protected final FluidTank leftTank = this.createFluidHandler(1000);
    protected final FluidTank rightTank = this.createFluidHandler(1000);
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TanksUpgrade(UpgradeManager manager, int dataHolderSlot, Fluids fluids) {
        super(manager, dataHolderSlot, new Point(51, 72));
        this.setTanksCapacity();
        this.setFluids(fluids);
        this.leftTankPos = new Point(7, 15);
        this.rightTankPos = new Point(195 + (manager.getWrapper().isExtended() ? 36 : 0), 15);
        this.getUpgradeManager().getWrapper().setRenderInfo(this.writeToRenderData());
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public BackpackResourceHandler getFluidSlotsHandler() {
        return this.fluidSlotsHandler;
    }

    public void setTanksCapacity() {
        this.leftTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
        this.rightTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
    }

    public void setFluids(Fluids tanks) {
        this.leftTank.setFluid(tanks.leftFluidStack());
        this.rightTank.setFluid(tanks.rightFluidStack());
    }

    public void syncClients(ItemStack backpack) {
        int slot = this.getDataHolderSlot();
        BackpackContainerContents contents = (BackpackContainerContents)backpack.get(ModDataComponents.UPGRADES);
        if (contents == null) {
            return;
        }
        if (slot >= contents.getItems().size()) {
            return;
        }
        ItemStack stack = (ItemStack)contents.getItems().get(slot);
        this.setFluids((Fluids)stack.getOrDefault(ModDataComponents.FLUIDS, (Object)Fluids.empty()));
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TanksUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.FLUIDS.get(), new Fluids(TanksUpgrade.this.leftTank.getFluid(), TanksUpgrade.this.rightTank.getFluid()));
                TanksUpgrade.this.getUpgradeManager().getWrapper().setRenderInfo(TanksUpgrade.this.writeToRenderData());
                TanksUpgrade.this.getUpgradeManager().getWrapper().sendDataToClients((DataComponentType)ModDataComponents.RENDER_INFO.get(), (DataComponentType)ModDataComponents.UPGRADES.get());
            }
        };
    }

    public CompoundTag writeToRenderData() {
        CompoundTag tag = new CompoundTag();
        Tag leftFluid = FluidStack.CODEC.encodeStart((DynamicOps)this.getUpgradeManager().getWrapper().getRegistriesAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.leftTank.getFluid()).result().orElseGet(CompoundTag::new);
        Tag rightFluid = FluidStack.CODEC.encodeStart((DynamicOps)this.getUpgradeManager().getWrapper().getRegistriesAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.rightTank.getFluid()).result().orElseGet(CompoundTag::new);
        tag.put("LeftTank", leftFluid);
        tag.put("RightTank", rightFluid);
        tag.putInt("Capacity", this.leftTank.getCapacity());
        return tag;
    }

    @Override
    public void remove() {
        this.getUpgradeManager().getWrapper().removeRenderInfo();
    }

    @Override
    public List<ResourceHandlerSlot> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<ResourceHandlerSlot> slots = new ArrayList<ResourceHandlerSlot>();
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 0, x + 7, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 1, x + 7, y + 49));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 2, x + 28, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 3, x + 28, y + 49));
        return slots;
    }

    public BackpackResourceHandler createTemporaryHandler() {
        return new BackpackResourceHandler(4){

            protected void onContentsChanged(int slot, ItemStack previousStack) {
                if (ItemStack.isSameItemSameComponents((ItemStack)previousStack, (ItemStack)this.getStackInSlot(slot))) {
                    if (slot == 0) {
                        InventoryActions.transferContainerTank(TanksUpgrade.this, TanksUpgrade.this.getLeftTank(), 0);
                    }
                    if (slot == 2) {
                        InventoryActions.transferContainerTank(TanksUpgrade.this, TanksUpgrade.this.getRightTank(), 2);
                    }
                }
            }

            public boolean isValid(int slot, ItemResource stack) {
                Optional container = FluidUtil.getFluidHandler((ItemStack)stack.toStack());
                if (slot == 1 || slot == 3) {
                    return false;
                }
                if (stack.getItem() instanceof PotionItem || stack.getItem() == Items.GLASS_BOTTLE) {
                    return true;
                }
                return container.isPresent();
            }
        };
    }
}

