/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.items.HoseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStackUtils {
    public static boolean isSameItemSameTags(ItemStack stack1, ItemStack stack2) {
        if (stack1.getItem() instanceof HoseItem && stack1.is(stack2.getItem())) {
            return true;
        }
        return ItemStackUtils.isSameItemSameComponents(stack1, stack2);
    }

    public static boolean isSameItemSameComponents(ItemStack pStack, ItemStack pOther) {
        if (!pStack.is(pOther.getItem())) {
            return false;
        }
        return pStack.isEmpty() && pOther.isEmpty() || ItemStackUtils.checkComponentsIgnoreDamage(pStack.getComponents(), pOther.getComponents());
    }

    public static boolean checkComponentsIgnoreDamage(DataComponentMap map, DataComponentMap other) {
        map.keySet().removeIf(type -> type == DataComponents.DAMAGE);
        other.keySet().removeIf(type -> type == DataComponents.DAMAGE);
        return Objects.equals(map, other);
    }

    public static DataComponentMap createDataComponentMap(ItemStack serverDataHolder, DataComponentType ... dataComponentTypes) {
        DataComponentMap.Builder mapBuilder = DataComponentMap.builder();
        ItemStack serverDataHolderCopy = serverDataHolder.copy();
        serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolderCopy);
        for (DataComponentType type : dataComponentTypes) {
            if (!serverDataHolderCopy.has(type)) continue;
            mapBuilder.set(type, serverDataHolderCopy.get(type));
        }
        return mapBuilder.build();
    }

    public static ItemStack reduceSize(ItemStack backpack) {
        ItemStack backpackCopy = backpack.copy();
        if (backpackCopy.has(ModDataComponents.BACKPACK_CONTAINER)) {
            backpackCopy.remove(ModDataComponents.BACKPACK_CONTAINER);
        }
        if (backpackCopy.has(ModDataComponents.SLOTS)) {
            Slots slots = (Slots)backpackCopy.get(ModDataComponents.SLOTS);
            List<Pair<Integer, Pair<ItemStack, Boolean>>> memorizedStacksHeavy = slots.memory();
            ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>> reduced = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
            for (Pair<Integer, Pair<ItemStack, Boolean>> outerPair : memorizedStacksHeavy) {
                int index = (Integer)outerPair.getFirst();
                ItemStack innerStack = ((ItemStack)((Pair)outerPair.getSecond()).getFirst()).copy();
                boolean matchComponents = (Boolean)((Pair)outerPair.getSecond()).getSecond();
                if (matchComponents) {
                    innerStack = new ItemStack((ItemLike)innerStack.getItem(), innerStack.getCount());
                }
                if (innerStack.isEmpty()) continue;
                reduced.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)index, (Object)Pair.of((Object)innerStack, (Object)matchComponents)));
            }
            backpackCopy.set(ModDataComponents.SLOTS, (Object)new Slots(slots.unsortables(), reduced));
        }
        return backpackCopy;
    }
}

